import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafDomainV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#certificate_id WafDomainV1#certificate_id}.
     *
     * @stability stable
     */
    readonly certificateId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#cipher WafDomainV1#cipher}.
     *
     * @stability stable
     */
    readonly cipher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#hostname WafDomainV1#hostname}.
     *
     * @stability stable
     */
    readonly hostname: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#policy_id WafDomainV1#policy_id}.
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#proxy WafDomainV1#proxy}.
     *
     * @stability stable
     */
    readonly proxy: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#sip_header_list WafDomainV1#sip_header_list}.
     *
     * @stability stable
     */
    readonly sipHeaderList?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#sip_header_name WafDomainV1#sip_header_name}.
     *
     * @stability stable
     */
    readonly sipHeaderName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#tls WafDomainV1#tls}.
     *
     * @stability stable
     */
    readonly tls?: string;
    /**
     * server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#server WafDomainV1#server}
     *
     * @stability stable
     */
    readonly server: WafDomainV1Server[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#timeouts WafDomainV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WafDomainV1Timeouts;
}
/**
 * @stability stable
 */
export interface WafDomainV1Server {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#address WafDomainV1#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#back_protocol WafDomainV1#back_protocol}.
     *
     * @stability stable
     */
    readonly backProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#client_protocol WafDomainV1#client_protocol}.
     *
     * @stability stable
     */
    readonly clientProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#front_protocol WafDomainV1#front_protocol}.
     *
     * @stability stable
     */
    readonly frontProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#port WafDomainV1#port}.
     *
     * @stability stable
     */
    readonly port: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#server_protocol WafDomainV1#server_protocol}.
     *
     * @stability stable
     */
    readonly serverProtocol?: string;
}
/**
 * @stability stable
 */
export interface WafDomainV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#create WafDomainV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html#delete WafDomainV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class WafDomainV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html opentelekomcloud_waf_domain_v1}.
 *
 * @stability stable
 */
export declare class WafDomainV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1.html opentelekomcloud_waf_domain_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafDomainV1Config);
    /**
     * @stability stable
     */
    get accessCode(): string;
    /**
     * @stability stable
     */
    get accessStatus(): number;
    private _certificateId?;
    /**
     * @stability stable
     */
    get certificateId(): string | undefined;
    /**
     * @stability stable
     */
    set certificateId(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertificateId(): void;
    /**
     * @stability stable
     */
    get certificateIdInput(): string | undefined;
    private _cipher?;
    /**
     * @stability stable
     */
    get cipher(): string | undefined;
    /**
     * @stability stable
     */
    set cipher(value: string | undefined);
    /**
     * @stability stable
     */
    resetCipher(): void;
    /**
     * @stability stable
     */
    get cipherInput(): string | undefined;
    /**
     * @stability stable
     */
    get cname(): string;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string | undefined;
    /**
     * @stability stable
     */
    set policyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get protectStatus(): number;
    /**
     * @stability stable
     */
    get protocol(): string;
    private _proxy?;
    /**
     * @stability stable
     */
    get proxy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set proxy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get proxyInput(): boolean | cdktf.IResolvable | undefined;
    private _sipHeaderList?;
    /**
     * @stability stable
     */
    get sipHeaderList(): string[] | undefined;
    /**
     * @stability stable
     */
    set sipHeaderList(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSipHeaderList(): void;
    /**
     * @stability stable
     */
    get sipHeaderListInput(): string[] | undefined;
    private _sipHeaderName?;
    /**
     * @stability stable
     */
    get sipHeaderName(): string | undefined;
    /**
     * @stability stable
     */
    set sipHeaderName(value: string | undefined);
    /**
     * @stability stable
     */
    resetSipHeaderName(): void;
    /**
     * @stability stable
     */
    get sipHeaderNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subDomain(): string;
    private _tls?;
    /**
     * @stability stable
     */
    get tls(): string | undefined;
    /**
     * @stability stable
     */
    set tls(value: string | undefined);
    /**
     * @stability stable
     */
    resetTls(): void;
    /**
     * @stability stable
     */
    get tlsInput(): string | undefined;
    /**
     * @stability stable
     */
    get txtCode(): string;
    private _server?;
    /**
     * @stability stable
     */
    get server(): WafDomainV1Server[];
    /**
     * @stability stable
     */
    set server(value: WafDomainV1Server[]);
    /**
     * @stability stable
     */
    get serverInput(): WafDomainV1Server[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WafDomainV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WafDomainV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WafDomainV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
