import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#full_detection WafPolicyV1#full_detection}.
     *
     * @stability stable
     */
    readonly fullDetection?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#hosts WafPolicyV1#hosts}.
     *
     * @stability stable
     */
    readonly hosts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#level WafPolicyV1#level}.
     *
     * @stability stable
     */
    readonly level?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#name WafPolicyV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#action WafPolicyV1#action}
     *
     * @stability stable
     */
    readonly action?: WafPolicyV1Action;
    /**
     * options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#options WafPolicyV1#options}
     *
     * @stability stable
     */
    readonly options?: WafPolicyV1Options;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#timeouts WafPolicyV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WafPolicyV1Timeouts;
}
/**
 * @stability stable
 */
export interface WafPolicyV1Action {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#category WafPolicyV1#category}.
     *
     * @stability stable
     */
    readonly category: string;
}
/**
 * @stability stable
 */
export declare class WafPolicyV1ActionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _category?;
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    set category(value: string);
    /**
     * @stability stable
     */
    get categoryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WafPolicyV1Options {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#antitamper WafPolicyV1#antitamper}.
     *
     * @stability stable
     */
    readonly antitamper?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#cc WafPolicyV1#cc}.
     *
     * @stability stable
     */
    readonly cc?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#common WafPolicyV1#common}.
     *
     * @stability stable
     */
    readonly common?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#crawler WafPolicyV1#crawler}.
     *
     * @stability stable
     */
    readonly crawler?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#crawler_engine WafPolicyV1#crawler_engine}.
     *
     * @stability stable
     */
    readonly crawlerEngine?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#crawler_other WafPolicyV1#crawler_other}.
     *
     * @stability stable
     */
    readonly crawlerOther?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#crawler_scanner WafPolicyV1#crawler_scanner}.
     *
     * @stability stable
     */
    readonly crawlerScanner?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#crawler_script WafPolicyV1#crawler_script}.
     *
     * @stability stable
     */
    readonly crawlerScript?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#custom WafPolicyV1#custom}.
     *
     * @stability stable
     */
    readonly custom?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#ignore WafPolicyV1#ignore}.
     *
     * @stability stable
     */
    readonly ignore?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#privacy WafPolicyV1#privacy}.
     *
     * @stability stable
     */
    readonly privacy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#webattack WafPolicyV1#webattack}.
     *
     * @stability stable
     */
    readonly webattack?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#webshell WafPolicyV1#webshell}.
     *
     * @stability stable
     */
    readonly webshell?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#whiteblackip WafPolicyV1#whiteblackip}.
     *
     * @stability stable
     */
    readonly whiteblackip?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class WafPolicyV1OptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _antitamper?;
    /**
     * @stability stable
     */
    get antitamper(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set antitamper(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAntitamper(): void;
    /**
     * @stability stable
     */
    get antitamperInput(): boolean | cdktf.IResolvable | undefined;
    private _cc?;
    /**
     * @stability stable
     */
    get cc(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set cc(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCc(): void;
    /**
     * @stability stable
     */
    get ccInput(): boolean | cdktf.IResolvable | undefined;
    private _common?;
    /**
     * @stability stable
     */
    get common(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set common(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCommon(): void;
    /**
     * @stability stable
     */
    get commonInput(): boolean | cdktf.IResolvable | undefined;
    private _crawler?;
    /**
     * @stability stable
     */
    get crawler(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crawler(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrawler(): void;
    /**
     * @stability stable
     */
    get crawlerInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerEngine?;
    /**
     * @stability stable
     */
    get crawlerEngine(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crawlerEngine(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrawlerEngine(): void;
    /**
     * @stability stable
     */
    get crawlerEngineInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerOther?;
    /**
     * @stability stable
     */
    get crawlerOther(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crawlerOther(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrawlerOther(): void;
    /**
     * @stability stable
     */
    get crawlerOtherInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerScanner?;
    /**
     * @stability stable
     */
    get crawlerScanner(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crawlerScanner(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrawlerScanner(): void;
    /**
     * @stability stable
     */
    get crawlerScannerInput(): boolean | cdktf.IResolvable | undefined;
    private _crawlerScript?;
    /**
     * @stability stable
     */
    get crawlerScript(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crawlerScript(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrawlerScript(): void;
    /**
     * @stability stable
     */
    get crawlerScriptInput(): boolean | cdktf.IResolvable | undefined;
    private _custom?;
    /**
     * @stability stable
     */
    get custom(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set custom(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCustom(): void;
    /**
     * @stability stable
     */
    get customInput(): boolean | cdktf.IResolvable | undefined;
    private _ignore?;
    /**
     * @stability stable
     */
    get ignore(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ignore(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIgnore(): void;
    /**
     * @stability stable
     */
    get ignoreInput(): boolean | cdktf.IResolvable | undefined;
    private _privacy?;
    /**
     * @stability stable
     */
    get privacy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set privacy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPrivacy(): void;
    /**
     * @stability stable
     */
    get privacyInput(): boolean | cdktf.IResolvable | undefined;
    private _webattack?;
    /**
     * @stability stable
     */
    get webattack(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set webattack(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetWebattack(): void;
    /**
     * @stability stable
     */
    get webattackInput(): boolean | cdktf.IResolvable | undefined;
    private _webshell?;
    /**
     * @stability stable
     */
    get webshell(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set webshell(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetWebshell(): void;
    /**
     * @stability stable
     */
    get webshellInput(): boolean | cdktf.IResolvable | undefined;
    private _whiteblackip?;
    /**
     * @stability stable
     */
    get whiteblackip(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set whiteblackip(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetWhiteblackip(): void;
    /**
     * @stability stable
     */
    get whiteblackipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WafPolicyV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#create WafPolicyV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html#delete WafPolicyV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class WafPolicyV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html opentelekomcloud_waf_policy_v1}.
 *
 * @stability stable
 */
export declare class WafPolicyV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_policy_v1.html opentelekomcloud_waf_policy_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafPolicyV1Config);
    private _fullDetection?;
    /**
     * @stability stable
     */
    get fullDetection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set fullDetection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetFullDetection(): void;
    /**
     * @stability stable
     */
    get fullDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _hosts?;
    /**
     * @stability stable
     */
    get hosts(): string[] | undefined;
    /**
     * @stability stable
     */
    set hosts(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetHosts(): void;
    /**
     * @stability stable
     */
    get hostsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _level?;
    /**
     * @stability stable
     */
    get level(): number | undefined;
    /**
     * @stability stable
     */
    set level(value: number | undefined);
    /**
     * @stability stable
     */
    resetLevel(): void;
    /**
     * @stability stable
     */
    get levelInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _action?;
    private __actionOutput;
    /**
     * @stability stable
     */
    get action(): WafPolicyV1ActionOutputReference;
    /**
     * @stability stable
     */
    putAction(value: WafPolicyV1Action | undefined): void;
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): WafPolicyV1Action | undefined;
    private _options?;
    private __optionsOutput;
    /**
     * @stability stable
     */
    get options(): WafPolicyV1OptionsOutputReference;
    /**
     * @stability stable
     */
    putOptions(value: WafPolicyV1Options | undefined): void;
    /**
     * @stability stable
     */
    resetOptions(): void;
    /**
     * @stability stable
     */
    get optionsInput(): WafPolicyV1Options | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WafPolicyV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WafPolicyV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WafPolicyV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
