import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafPreciseprotectionRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#action_category WafPreciseprotectionRuleV1#action_category}.
     *
     * @stability stable
     */
    readonly actionCategory: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#end WafPreciseprotectionRuleV1#end}.
     *
     * @stability stable
     */
    readonly end?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#name WafPreciseprotectionRuleV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#policy_id WafPreciseprotectionRuleV1#policy_id}.
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#priority WafPreciseprotectionRuleV1#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#start WafPreciseprotectionRuleV1#start}.
     *
     * @stability stable
     */
    readonly start?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#time WafPreciseprotectionRuleV1#time}.
     *
     * @stability stable
     */
    readonly time?: boolean | cdktf.IResolvable;
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#conditions WafPreciseprotectionRuleV1#conditions}
     *
     * @stability stable
     */
    readonly conditions: WafPreciseprotectionRuleV1Conditions[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#timeouts WafPreciseprotectionRuleV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WafPreciseprotectionRuleV1Timeouts;
}
/**
 * @stability stable
 */
export interface WafPreciseprotectionRuleV1Conditions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#category WafPreciseprotectionRuleV1#category}.
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#contents WafPreciseprotectionRuleV1#contents}.
     *
     * @stability stable
     */
    readonly contents: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#index WafPreciseprotectionRuleV1#index}.
     *
     * @stability stable
     */
    readonly index?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#logic WafPreciseprotectionRuleV1#logic}.
     *
     * @stability stable
     */
    readonly logic: string;
}
/**
 * @stability stable
 */
export interface WafPreciseprotectionRuleV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#create WafPreciseprotectionRuleV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html#delete WafPreciseprotectionRuleV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class WafPreciseprotectionRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html opentelekomcloud_waf_preciseprotection_rule_v1}.
 *
 * @stability stable
 */
export declare class WafPreciseprotectionRuleV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1.html opentelekomcloud_waf_preciseprotection_rule_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafPreciseprotectionRuleV1Config);
    private _actionCategory?;
    /**
     * @stability stable
     */
    get actionCategory(): string;
    /**
     * @stability stable
     */
    set actionCategory(value: string);
    /**
     * @stability stable
     */
    get actionCategoryInput(): string | undefined;
    private _end?;
    /**
     * @stability stable
     */
    get end(): string | undefined;
    /**
     * @stability stable
     */
    set end(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnd(): void;
    /**
     * @stability stable
     */
    get endInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number | undefined;
    /**
     * @stability stable
     */
    set priority(value: number | undefined);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): string | undefined;
    /**
     * @stability stable
     */
    set start(value: string | undefined);
    /**
     * @stability stable
     */
    resetStart(): void;
    /**
     * @stability stable
     */
    get startInput(): string | undefined;
    private _time?;
    /**
     * @stability stable
     */
    get time(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set time(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTime(): void;
    /**
     * @stability stable
     */
    get timeInput(): boolean | cdktf.IResolvable | undefined;
    private _conditions?;
    /**
     * @stability stable
     */
    get conditions(): WafPreciseprotectionRuleV1Conditions[];
    /**
     * @stability stable
     */
    set conditions(value: WafPreciseprotectionRuleV1Conditions[]);
    /**
     * @stability stable
     */
    get conditionsInput(): WafPreciseprotectionRuleV1Conditions[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WafPreciseprotectionRuleV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WafPreciseprotectionRuleV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WafPreciseprotectionRuleV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
