import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafWhiteblackipRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#addr WafWhiteblackipRuleV1#addr}.
     *
     * @stability stable
     */
    readonly addr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#policy_id WafWhiteblackipRuleV1#policy_id}.
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#white WafWhiteblackipRuleV1#white}.
     *
     * @stability stable
     */
    readonly white?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#timeouts WafWhiteblackipRuleV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WafWhiteblackipRuleV1Timeouts;
}
/**
 * @stability stable
 */
export interface WafWhiteblackipRuleV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#create WafWhiteblackipRuleV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html#delete WafWhiteblackipRuleV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class WafWhiteblackipRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html opentelekomcloud_waf_whiteblackip_rule_v1}.
 *
 * @stability stable
 */
export declare class WafWhiteblackipRuleV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1.html opentelekomcloud_waf_whiteblackip_rule_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafWhiteblackipRuleV1Config);
    private _addr?;
    /**
     * @stability stable
     */
    get addr(): string;
    /**
     * @stability stable
     */
    set addr(value: string);
    /**
     * @stability stable
     */
    get addrInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _white?;
    /**
     * @stability stable
     */
    get white(): number | undefined;
    /**
     * @stability stable
     */
    set white(value: number | undefined);
    /**
     * @stability stable
     */
    resetWhite(): void;
    /**
     * @stability stable
     */
    get whiteInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WafWhiteblackipRuleV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WafWhiteblackipRuleV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WafWhiteblackipRuleV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
