# mypy-boto3-macie2<a id="mypy-boto3-macie2"></a>

[![PyPI - mypy-boto3-macie2](https://img.shields.io/pypi/v/mypy-boto3-macie2.svg?color=blue)](https://pypi.org/project/mypy-boto3-macie2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-macie2.svg?color=blue)](https://pypi.org/project/mypy-boto3-macie2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-macie2?color=blue)](https://pypistats.org/packages/mypy-boto3-macie2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Macie2 1.17.72](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/macie2.html#Macie2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-macie2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_macie2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-macie2](#mypy-boto3-macie2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `Macie2` service.

```bash
python -m pip install boto3-stubs[macie2]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[macie2]` in your environment:
  `python -m pip install 'boto3-stubs[macie2]'`

Both type checking and auto-complete should work for `Macie2` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[macie2]` in your environment:
  `python -m pip install 'boto3-stubs[macie2]'`

Both type checking and auto-complete should work for `Macie2` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[macie2]` in your environment:
  `python -m pip install 'boto3-stubs[macie2]'`
- Run `mypy` as usual

Type checking should work for `Macie2` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[macie2]` in your environment:
  `python -m pip install 'boto3-stubs[macie2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Macie2` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`Macie2Client` provides annotations for `boto3.client("macie2")`.

```python
import boto3

from mypy_boto3_macie2 import Macie2Client

client: Macie2Client = boto3.client("macie2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Macie2Client = session.client("macie2")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_macie2.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_macie2 import Macie2Client
from mypy_boto3_macie2.paginator import (
    DescribeBucketsPaginator,
    GetUsageStatisticsPaginator,
    ListClassificationJobsPaginator,
    ListCustomDataIdentifiersPaginator,
    ListFindingsPaginator,
    ListFindingsFiltersPaginator,
    ListInvitationsPaginator,
    ListMembersPaginator,
    ListOrganizationAdminAccountsPaginator,
)

client: Macie2Client = boto3.client("macie2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_buckets_paginator: DescribeBucketsPaginator = client.get_paginator("describe_buckets")
get_usage_statistics_paginator: GetUsageStatisticsPaginator = client.get_paginator("get_usage_statistics")
list_classification_jobs_paginator: ListClassificationJobsPaginator = client.get_paginator("list_classification_jobs")
list_custom_data_identifiers_paginator: ListCustomDataIdentifiersPaginator = client.get_paginator("list_custom_data_identifiers")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
list_findings_filters_paginator: ListFindingsFiltersPaginator = client.get_paginator("list_findings_filters")
list_invitations_paginator: ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: ListMembersPaginator = client.get_paginator("list_members")
list_organization_admin_accounts_paginator: ListOrganizationAdminAccountsPaginator = client.get_paginator("list_organization_admin_accounts")
```

### Literals<a id="literals"></a>

`mypy_boto3_macie2.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_macie2.literals import (
    AdminStatusType,
    AllowsUnencryptedObjectUploadsType,
    CurrencyType,
    DayOfWeekType,
    DescribeBucketsPaginatorName,
    EffectivePermissionType,
    EncryptionTypeType,
    ErrorCodeType,
    FindingActionTypeType,
    FindingCategoryType,
    FindingPublishingFrequencyType,
    FindingStatisticsSortAttributeNameType,
    FindingTypeType,
    FindingsFilterActionType,
    GetUsageStatisticsPaginatorName,
    GroupByType,
    IsDefinedInJobType,
    IsMonitoredByJobType,
    JobComparatorType,
    JobStatusType,
    JobTypeType,
    LastRunErrorStatusCodeType,
    ListClassificationJobsPaginatorName,
    ListCustomDataIdentifiersPaginatorName,
    ListFindingsFiltersPaginatorName,
    ListFindingsPaginatorName,
    ListInvitationsPaginatorName,
    ListJobsFilterKeyType,
    ListJobsSortAttributeNameType,
    ListMembersPaginatorName,
    ListOrganizationAdminAccountsPaginatorName,
    MacieStatusType,
    OrderByType,
    RelationshipStatusType,
    ScopeFilterKeyType,
    SensitiveDataItemCategoryType,
    SeverityDescriptionType,
    SharedAccessType,
    StorageClassType,
    TagTargetType,
    TimeRangeType,
    TypeType,
    UnitType,
    UsageStatisticsFilterComparatorType,
    UsageStatisticsFilterKeyType,
    UsageStatisticsSortKeyType,
    UsageTypeType,
    UserIdentityTypeType,
)

def check_value(value: AdminStatusType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_macie2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_macie2.type_defs import (
    AccessControlListTypeDef,
    AccountDetailTypeDef,
    AccountLevelPermissionsTypeDef,
    AdminAccountTypeDef,
    ApiCallDetailsTypeDef,
    AssumedRoleTypeDef,
    AwsAccountTypeDef,
    AwsServiceTypeDef,
    BatchGetCustomDataIdentifierSummaryTypeDef,
    BatchGetCustomDataIdentifiersResponseTypeDef,
    BlockPublicAccessTypeDef,
    BucketCountByEffectivePermissionTypeDef,
    BucketCountByEncryptionTypeTypeDef,
    BucketCountBySharedAccessTypeTypeDef,
    BucketCountPolicyAllowsUnencryptedObjectUploadsTypeDef,
    BucketCriteriaAdditionalPropertiesTypeDef,
    BucketLevelPermissionsTypeDef,
    BucketMetadataTypeDef,
    BucketPermissionConfigurationTypeDef,
    BucketPolicyTypeDef,
    BucketPublicAccessTypeDef,
    BucketServerSideEncryptionTypeDef,
    BucketSortCriteriaTypeDef,
    CellTypeDef,
    ClassificationDetailsTypeDef,
    ClassificationExportConfigurationTypeDef,
    ClassificationResultStatusTypeDef,
    ClassificationResultTypeDef,
    CreateClassificationJobResponseTypeDef,
    CreateCustomDataIdentifierResponseTypeDef,
    CreateFindingsFilterResponseTypeDef,
    CreateInvitationsResponseTypeDef,
    CreateMemberResponseTypeDef,
    CriterionAdditionalPropertiesTypeDef,
    CustomDataIdentifierSummaryTypeDef,
    CustomDataIdentifiersTypeDef,
    CustomDetectionTypeDef,
    DeclineInvitationsResponseTypeDef,
    DefaultDetectionTypeDef,
    DeleteInvitationsResponseTypeDef,
    DescribeBucketsResponseTypeDef,
    DescribeClassificationJobResponseTypeDef,
    DescribeOrganizationConfigurationResponseTypeDef,
    DomainDetailsTypeDef,
    FederatedUserTypeDef,
    FindingActionTypeDef,
    FindingActorTypeDef,
    FindingCriteriaTypeDef,
    FindingStatisticsSortCriteriaTypeDef,
    FindingTypeDef,
    FindingsFilterListItemTypeDef,
    GetAdministratorAccountResponseTypeDef,
    GetBucketStatisticsResponseTypeDef,
    GetClassificationExportConfigurationResponseTypeDef,
    GetCustomDataIdentifierResponseTypeDef,
    GetFindingStatisticsResponseTypeDef,
    GetFindingsFilterResponseTypeDef,
    GetFindingsPublicationConfigurationResponseTypeDef,
    GetFindingsResponseTypeDef,
    GetInvitationsCountResponseTypeDef,
    GetMacieSessionResponseTypeDef,
    GetMasterAccountResponseTypeDef,
    GetMemberResponseTypeDef,
    GetUsageStatisticsResponseTypeDef,
    GetUsageTotalsResponseTypeDef,
    GroupCountTypeDef,
    IamUserTypeDef,
    InvitationTypeDef,
    IpAddressDetailsTypeDef,
    IpCityTypeDef,
    IpCountryTypeDef,
    IpGeoLocationTypeDef,
    IpOwnerTypeDef,
    JobDetailsTypeDef,
    JobScheduleFrequencyTypeDef,
    JobScopeTermTypeDef,
    JobScopingBlockTypeDef,
    JobSummaryTypeDef,
    KeyValuePairTypeDef,
    LastRunErrorStatusTypeDef,
    ListClassificationJobsResponseTypeDef,
    ListCustomDataIdentifiersResponseTypeDef,
    ListFindingsFiltersResponseTypeDef,
    ListFindingsResponseTypeDef,
    ListInvitationsResponseTypeDef,
    ListJobsFilterCriteriaTypeDef,
    ListJobsFilterTermTypeDef,
    ListJobsSortCriteriaTypeDef,
    ListMembersResponseTypeDef,
    ListOrganizationAdminAccountsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    MemberTypeDef,
    MonthlyScheduleTypeDef,
    ObjectCountByEncryptionTypeTypeDef,
    ObjectLevelStatisticsTypeDef,
    OccurrencesTypeDef,
    PageTypeDef,
    PaginatorConfigTypeDef,
    PolicyDetailsTypeDef,
    PutClassificationExportConfigurationResponseTypeDef,
    RangeTypeDef,
    RecordTypeDef,
    ReplicationDetailsTypeDef,
    ResourcesAffectedTypeDef,
    S3BucketDefinitionForJobTypeDef,
    S3BucketOwnerTypeDef,
    S3BucketTypeDef,
    S3DestinationTypeDef,
    S3JobDefinitionTypeDef,
    S3ObjectTypeDef,
    ScopingTypeDef,
    SecurityHubConfigurationTypeDef,
    SensitiveDataItemTypeDef,
    ServerSideEncryptionTypeDef,
    ServiceLimitTypeDef,
    SessionContextAttributesTypeDef,
    SessionContextTypeDef,
    SessionIssuerTypeDef,
    SeverityTypeDef,
    SimpleScopeTermTypeDef,
    SortCriteriaTypeDef,
    StatisticsTypeDef,
    TagScopeTermTypeDef,
    TagValuePairTypeDef,
    TestCustomDataIdentifierResponseTypeDef,
    UnprocessedAccountTypeDef,
    UpdateFindingsFilterResponseTypeDef,
    UsageByAccountTypeDef,
    UsageRecordTypeDef,
    UsageStatisticsFilterTypeDef,
    UsageStatisticsSortByTypeDef,
    UsageTotalTypeDef,
    UserIdentityRootTypeDef,
    UserIdentityTypeDef,
    UserPausedDetailsTypeDef,
    WeeklyScheduleTypeDef,
)

def get_structure() -> AccessControlListTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-macie2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-macie2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_macie2/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
