"""
Type annotations for macie2 service literal definitions.

[Open documentation](./literals.md)

Usage::

    ```python
    from mypy_boto3_macie2.literals import AdminStatusType

    data: AdminStatusType = "DISABLING_IN_PROGRESS"
    ```
"""
import sys

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "AdminStatusType",
    "AllowsUnencryptedObjectUploadsType",
    "CurrencyType",
    "DayOfWeekType",
    "DescribeBucketsPaginatorName",
    "EffectivePermissionType",
    "EncryptionTypeType",
    "ErrorCodeType",
    "FindingActionTypeType",
    "FindingCategoryType",
    "FindingPublishingFrequencyType",
    "FindingStatisticsSortAttributeNameType",
    "FindingTypeType",
    "FindingsFilterActionType",
    "GetUsageStatisticsPaginatorName",
    "GroupByType",
    "IsDefinedInJobType",
    "IsMonitoredByJobType",
    "JobComparatorType",
    "JobStatusType",
    "JobTypeType",
    "LastRunErrorStatusCodeType",
    "ListClassificationJobsPaginatorName",
    "ListCustomDataIdentifiersPaginatorName",
    "ListFindingsFiltersPaginatorName",
    "ListFindingsPaginatorName",
    "ListInvitationsPaginatorName",
    "ListJobsFilterKeyType",
    "ListJobsSortAttributeNameType",
    "ListMembersPaginatorName",
    "ListOrganizationAdminAccountsPaginatorName",
    "MacieStatusType",
    "OrderByType",
    "RelationshipStatusType",
    "ScopeFilterKeyType",
    "SensitiveDataItemCategoryType",
    "SeverityDescriptionType",
    "SharedAccessType",
    "StorageClassType",
    "TagTargetType",
    "TimeRangeType",
    "TypeType",
    "UnitType",
    "UsageStatisticsFilterComparatorType",
    "UsageStatisticsFilterKeyType",
    "UsageStatisticsSortKeyType",
    "UsageTypeType",
    "UserIdentityTypeType",
)


AdminStatusType = Literal["DISABLING_IN_PROGRESS", "ENABLED"]
AllowsUnencryptedObjectUploadsType = Literal["FALSE", "TRUE", "UNKNOWN"]
CurrencyType = Literal["USD"]
DayOfWeekType = Literal[
    "FRIDAY", "MONDAY", "SATURDAY", "SUNDAY", "THURSDAY", "TUESDAY", "WEDNESDAY"
]
DescribeBucketsPaginatorName = Literal["describe_buckets"]
EffectivePermissionType = Literal["NOT_PUBLIC", "PUBLIC", "UNKNOWN"]
EncryptionTypeType = Literal["AES256", "NONE", "UNKNOWN", "aws:kms"]
ErrorCodeType = Literal["ClientError", "InternalError"]
FindingActionTypeType = Literal["AWS_API_CALL"]
FindingCategoryType = Literal["CLASSIFICATION", "POLICY"]
FindingPublishingFrequencyType = Literal["FIFTEEN_MINUTES", "ONE_HOUR", "SIX_HOURS"]
FindingStatisticsSortAttributeNameType = Literal["count", "groupKey"]
FindingTypeType = Literal[
    "Policy:IAMUser/S3BlockPublicAccessDisabled",
    "Policy:IAMUser/S3BucketEncryptionDisabled",
    "Policy:IAMUser/S3BucketPublic",
    "Policy:IAMUser/S3BucketReplicatedExternally",
    "Policy:IAMUser/S3BucketSharedExternally",
    "SensitiveData:S3Object/Credentials",
    "SensitiveData:S3Object/CustomIdentifier",
    "SensitiveData:S3Object/Financial",
    "SensitiveData:S3Object/Multiple",
    "SensitiveData:S3Object/Personal",
]
FindingsFilterActionType = Literal["ARCHIVE", "NOOP"]
GetUsageStatisticsPaginatorName = Literal["get_usage_statistics"]
GroupByType = Literal[
    "classificationDetails.jobId", "resourcesAffected.s3Bucket.name", "severity.description", "type"
]
IsDefinedInJobType = Literal["FALSE", "TRUE", "UNKNOWN"]
IsMonitoredByJobType = Literal["FALSE", "TRUE", "UNKNOWN"]
JobComparatorType = Literal["CONTAINS", "EQ", "GT", "GTE", "LT", "LTE", "NE", "STARTS_WITH"]
JobStatusType = Literal["CANCELLED", "COMPLETE", "IDLE", "PAUSED", "RUNNING", "USER_PAUSED"]
JobTypeType = Literal["ONE_TIME", "SCHEDULED"]
LastRunErrorStatusCodeType = Literal["ERROR", "NONE"]
ListClassificationJobsPaginatorName = Literal["list_classification_jobs"]
ListCustomDataIdentifiersPaginatorName = Literal["list_custom_data_identifiers"]
ListFindingsFiltersPaginatorName = Literal["list_findings_filters"]
ListFindingsPaginatorName = Literal["list_findings"]
ListInvitationsPaginatorName = Literal["list_invitations"]
ListJobsFilterKeyType = Literal["createdAt", "jobStatus", "jobType", "name"]
ListJobsSortAttributeNameType = Literal["createdAt", "jobStatus", "jobType", "name"]
ListMembersPaginatorName = Literal["list_members"]
ListOrganizationAdminAccountsPaginatorName = Literal["list_organization_admin_accounts"]
MacieStatusType = Literal["ENABLED", "PAUSED"]
OrderByType = Literal["ASC", "DESC"]
RelationshipStatusType = Literal[
    "AccountSuspended",
    "Created",
    "EmailVerificationFailed",
    "EmailVerificationInProgress",
    "Enabled",
    "Invited",
    "Paused",
    "RegionDisabled",
    "Removed",
    "Resigned",
]
ScopeFilterKeyType = Literal[
    "BUCKET_CREATION_DATE",
    "OBJECT_EXTENSION",
    "OBJECT_KEY",
    "OBJECT_LAST_MODIFIED_DATE",
    "OBJECT_SIZE",
    "TAG",
]
SensitiveDataItemCategoryType = Literal[
    "CREDENTIALS", "CUSTOM_IDENTIFIER", "FINANCIAL_INFORMATION", "PERSONAL_INFORMATION"
]
SeverityDescriptionType = Literal["High", "Low", "Medium"]
SharedAccessType = Literal["EXTERNAL", "INTERNAL", "NOT_SHARED", "UNKNOWN"]
StorageClassType = Literal[
    "DEEP_ARCHIVE",
    "GLACIER",
    "INTELLIGENT_TIERING",
    "ONEZONE_IA",
    "REDUCED_REDUNDANCY",
    "STANDARD",
    "STANDARD_IA",
]
TagTargetType = Literal["S3_OBJECT"]
TimeRangeType = Literal["MONTH_TO_DATE", "PAST_30_DAYS"]
TypeType = Literal["AES256", "NONE", "aws:kms"]
UnitType = Literal["TERABYTES"]
UsageStatisticsFilterComparatorType = Literal["CONTAINS", "EQ", "GT", "GTE", "LT", "LTE", "NE"]
UsageStatisticsFilterKeyType = Literal["accountId", "freeTrialStartDate", "serviceLimit", "total"]
UsageStatisticsSortKeyType = Literal[
    "accountId", "freeTrialStartDate", "serviceLimitValue", "total"
]
UsageTypeType = Literal["DATA_INVENTORY_EVALUATION", "SENSITIVE_DATA_DISCOVERY"]
UserIdentityTypeType = Literal[
    "AWSAccount", "AWSService", "AssumedRole", "FederatedUser", "IAMUser", "Root"
]
