<p align="center">
  <img src="https://raw.githubusercontent.com/engineer0427/Atlas/main/docs/AtlasImage.png" alt="Atlas Logo" width="400"/>
</p>

<p align="center">
  <a href="https://pypi.org/project/atlas-research/">
    <img src="https://img.shields.io/pypi/v/atlas-research?color=blue&style=for-the-badge&cacheSeconds=0" alt="PyPI version"/>
  </a>
  <a href="#">
    <img src="https://img.shields.io/badge/Python-3.10%2B-brightgreen?style=for-the-badge&logo=python" alt="Python"/>
  </a>
  <a href="https://github.com/engineer0427/Atlas/blob/main/LICENSE">
    <img src="https://img.shields.io/badge/License-Apache%202.0-lightgrey?style=for-the-badge" alt="License"/>
  </a>
</p>

---

> 🧭 **AI로 지식을 그리다.**  
> Atlas는 인공지능이 텍스트, 코드, 데이터의 의미를 이해하고  
> 관계를 분석해 지식의 지도를 시각적으로 그리는 **AI-Powered Knowledge Mapping Platform**입니다.

Atlas는 연구 중심 프레임워크를 넘어  
누구나 AI로 지식을 구조화하고 탐색할 수 있는 **웹 기반 플랫폼(SaaS)** 으로 발전했습니다.  
FastAPI 백엔드와 Next.js 프론트엔드가 완전히 통합되어 있으며,  
Koyeb·Vercel·PyPI 자동 배포 파이프라인까지 구축되어 있습니다.

---

## 🌐 Live Demo

> 📍 **Web App:** [https://atlas-gamma-wine.vercel.app](https://atlas-gamma-wine.vercel.app)  
> ☁️ **API Endpoint:** `/api/analyze`  
> 📦 **PyPI Package:** [https://pypi.org/project/atlas-research/](https://pypi.org/project/atlas-research/)

---

## 💡 Vision
> **From Framework to Platform. From Knowledge to Insight.**

Atlas는 AI가 인간의 사고 구조를 이해하고,  
지식의 연결을 '지도(map)' 형태로 시각화하는 플랫폼을 목표로 합니다.  
AI가 지식을 분석하고, 사용자는 이를 탐색·확장할 수 있습니다.

---

## ⚙️ CI/CD Pipeline

| 구성 요소 | 역할 |
|------------|------|
| 🧱 **GitHub Actions** | 릴리스 및 PyPI 업로드 자동화 |
| ☁️ **Koyeb** | FastAPI 백엔드 자동 배포 |
| 🌐 **Vercel** | Next.js 프론트엔드 자동 배포 |
| 🔐 **Secrets** | `VERCEL_TOKEN`, `KOYEB_API_KEY`, `PYPI_API_TOKEN` 관리 |

---

## ⚖️ License

이 프로젝트는 **Apache License 2.0** 하에 배포됩니다.  
자유로운 수정 및 상업적 활용이 가능하며, 원저작자 명시만 유지하시면 됩니다.  
자세한 내용은 [LICENSE](./LICENSE) 참고.