"""### Contains all the variables related to the configuration."""

SEND_INSTALLATION_STATISTICS = 'SEND_INSTALLATION_STATISTICS'
CMAKE = 'CMAKE'
CC = 'CMAKE_C_COMPILER'
CXX = 'CMAKE_CXX_COMPILER'
CC_FLAGS = 'CMAKE_C_FLAGS'
CXX_FLAGS = 'CMAKE_CXX_FLAGS'
CMAKE_INSTALL_PREFIX = 'CMAKE_INSTALL_PREFIX'
CUDA = 'XMIPP_USE_CUDA'
CUDA_COMPILER = 'CMAKE_CUDA_COMPILER'
MPI = 'XMIPP_USE_MPI'
PREFIX_PATH = 'CMAKE_PREFIX_PATH'
MPI_HOME = 'MPI_HOME'
PYTHON_HOME = 'Python3_ROOT_DIR'
FFTW_HOME = 'FFTW_ROOT'
TIFF_HOME = 'TIFF_ROOT'
HDF5_HOME = 'HDF5_ROOT'
JPEG_HOME = 'JPEG_ROOT'
SQLITE_HOME = 'SQLite_ROOT'
CUDA_CXX = 'CMAKE_CUDA_HOST_COMPILER'
MATLAB = 'XMIPP_USE_MATLAB'
LINK_SCIPION = 'XMIPP_LINK_TO_SCIPION'
BUILD_TESTING = 'BUILD_TESTING'
SKIP_RPATH='CMAKE_SKIP_RPATH'
BUILD_TYPE = "BUILD_TYPE"

# Not stored in ket=value format
LAST_MODIFIED_KEY = "last_modified"

# File structure
TOGGLES = 'toggles'
LOCATIONS = 'locations'
COMPILATION_FLAGS = 'flags'
CONFIG_VARIABLES = {
  TOGGLES: [
    SEND_INSTALLATION_STATISTICS, CUDA, MPI, MATLAB, LINK_SCIPION, BUILD_TESTING, SKIP_RPATH
  ],
  LOCATIONS: [
    CMAKE, CC, CXX, CMAKE_INSTALL_PREFIX, PREFIX_PATH, MPI_HOME,
    CUDA_COMPILER, PYTHON_HOME, FFTW_HOME, TIFF_HOME, 
     HDF5_HOME, JPEG_HOME, SQLITE_HOME, CUDA_CXX
  ],
  COMPILATION_FLAGS: [CC_FLAGS, CXX_FLAGS, BUILD_TYPE]
}

# Do not pass this variables to CMake, only for installer logic
INTERNAL_LOGIC_VARS = [SEND_INSTALLATION_STATISTICS, CMAKE, BUILD_TYPE]
