"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from apideck_unify import models, utils
from apideck_unify._hooks import HookContext
from apideck_unify.types import Nullable, OptionalNullable, UNSET
from apideck_unify.utils import get_security_from_env
from apideck_unify.utils.unmarshal_json_response import unmarshal_json_response
from datetime import date
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class Employees(BaseSDK):
    def list(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.EmployeesFilter, models.EmployeesFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.EmployeesSort, models.EmployeesSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.HrisEmployeesAllResponse]:
        r"""List Employees

        Apideck operates as a stateless Unified API, which means that the list endpoint only provides a portion of the employee model. This is due to the fact that most HRIS systems do not readily provide all data in every call. However, you can access the complete employee model through an employee detail call.

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(filter_, Optional[models.EmployeesFilter]),
            sort=utils.get_pydantic_model(sort, Optional[models.EmployeesSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request(
            method="GET",
            path="/hris/employees",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesAll",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.HrisEmployeesAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesAllResponse(
                get_employees_response=unmarshal_json_response(
                    Optional[models.GetEmployeesResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.EmployeesFilter, models.EmployeesFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.EmployeesSort, models.EmployeesSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.HrisEmployeesAllResponse]:
        r"""List Employees

        Apideck operates as a stateless Unified API, which means that the list endpoint only provides a portion of the employee model. This is due to the fact that most HRIS systems do not readily provide all data in every call. However, you can access the complete employee model through an employee detail call.

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(filter_, Optional[models.EmployeesFilter]),
            sort=utils.get_pydantic_model(sort, Optional[models.EmployeesSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request_async(
            method="GET",
            path="/hris/employees",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesAll",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.HrisEmployeesAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesAllResponse(
                get_employees_response=unmarshal_json_response(
                    Optional[models.GetEmployeesResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    def create(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        id: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        preferred_name: OptionalNullable[str] = UNSET,
        initials: OptionalNullable[str] = UNSET,
        salutation: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        marital_status: OptionalNullable[str] = UNSET,
        partner: Optional[
            Union[models.PersonInput, models.PersonInputTypedDict]
        ] = None,
        division: OptionalNullable[str] = UNSET,
        division_id: OptionalNullable[str] = UNSET,
        department: OptionalNullable[str] = UNSET,
        department_id: OptionalNullable[str] = UNSET,
        department_name: OptionalNullable[str] = UNSET,
        team: OptionalNullable[Union[models.Team, models.TeamTypedDict]] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        employment_start_date: OptionalNullable[str] = UNSET,
        employment_end_date: OptionalNullable[str] = UNSET,
        leaving_reason: OptionalNullable[models.LeavingReason] = UNSET,
        employee_number: OptionalNullable[str] = UNSET,
        employment_status: OptionalNullable[models.EmploymentStatus] = UNSET,
        employment_role: Optional[
            Union[models.EmploymentRole, models.EmploymentRoleTypedDict]
        ] = None,
        ethnicity: OptionalNullable[str] = UNSET,
        manager: Optional[Union[models.Manager, models.ManagerTypedDict]] = None,
        direct_reports: OptionalNullable[List[str]] = UNSET,
        social_security_number: OptionalNullable[str] = UNSET,
        birthday: OptionalNullable[date] = UNSET,
        deceased_on: OptionalNullable[date] = UNSET,
        country_of_birth: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        gender: OptionalNullable[models.Gender] = UNSET,
        pronouns: OptionalNullable[str] = UNSET,
        preferred_language: OptionalNullable[str] = UNSET,
        languages: Optional[List[Nullable[str]]] = None,
        nationalities: Optional[List[Nullable[str]]] = None,
        photo_url: OptionalNullable[str] = UNSET,
        timezone: OptionalNullable[str] = UNSET,
        source: OptionalNullable[str] = UNSET,
        source_id: OptionalNullable[str] = UNSET,
        record_url: OptionalNullable[str] = UNSET,
        jobs: OptionalNullable[
            Union[List[models.EmployeeJobInput], List[models.EmployeeJobInputTypedDict]]
        ] = UNSET,
        compensations: OptionalNullable[
            Union[
                List[models.EmployeeCompensationInput],
                List[models.EmployeeCompensationInputTypedDict],
            ]
        ] = UNSET,
        works_remote: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        social_links: Optional[
            Union[List[models.SocialLink], List[models.SocialLinkTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        tax_code: OptionalNullable[str] = UNSET,
        tax_id: OptionalNullable[str] = UNSET,
        dietary_preference: OptionalNullable[str] = UNSET,
        food_allergies: OptionalNullable[List[str]] = UNSET,
        probation_period: Optional[
            Union[models.ProbationPeriod, models.ProbationPeriodTypedDict]
        ] = None,
        tags: OptionalNullable[List[str]] = UNSET,
        row_version: OptionalNullable[str] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesAddResponse:
        r"""Create Employee

        Create Employee

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param id: A unique identifier for an object.
        :param first_name: The first name of the person.
        :param last_name: The last name of the person.
        :param middle_name: Middle name of the person.
        :param display_name: The name used to display the employee, often a combination of their first and last names.
        :param preferred_name: The name the employee prefers to be addressed by, which may be different from their legal name.
        :param initials: The initials of the person, usually derived from their first, middle, and last names.
        :param salutation: A formal salutation for the person. For example, 'Mr', 'Mrs'
        :param title: The job title of the person.
        :param marital_status: The marital status of the employee.
        :param partner:
        :param division: The division the person is currently in. Usually a collection of departments or teams or regions.
        :param division_id: Unique identifier of the division this employee belongs to.
        :param department: The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field.
        :param department_id: Unique identifier of the department ID this employee belongs to.
        :param department_name: Name of the department this employee belongs to.
        :param team: The team the person is currently in.
        :param company_id: The unique identifier of the company.
        :param company_name: The name of the company.
        :param employment_start_date: A Start Date is the date that the employee started working at the company
        :param employment_end_date: An End Date is the date that the employee ended working at the company
        :param leaving_reason: The reason because the employment ended.
        :param employee_number: An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company.
        :param employment_status: The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status.
        :param employment_role:
        :param ethnicity: The ethnicity of the employee
        :param manager:
        :param direct_reports: Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee.
        :param social_security_number: A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions.
        :param birthday: The date of birth of the person.
        :param deceased_on: The date the person deceased.
        :param country_of_birth: Country code according to ISO 3166-1 alpha-2.
        :param description: A description of the object.
        :param gender: The gender represents the gender identity of a person.
        :param pronouns: The preferred pronouns of the person.
        :param preferred_language: language code according to ISO 639-1. For the United States - EN
        :param languages:
        :param nationalities:
        :param photo_url: The URL of the photo of a person.
        :param timezone: The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London.
        :param source: When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from.
        :param source_id: Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS).
        :param record_url:
        :param jobs:
        :param compensations:
        :param works_remote: Indicates if the employee works from a remote location.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param custom_fields:
        :param social_links:
        :param bank_accounts:
        :param tax_code:
        :param tax_id:
        :param dietary_preference: Indicate the employee's dietary preference.
        :param food_allergies: Indicate the employee's food allergies.
        :param probation_period:
        :param tags:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param deleted: Flag to indicate if the object is deleted.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            employee=models.EmployeeInput(
                id=id,
                first_name=first_name,
                last_name=last_name,
                middle_name=middle_name,
                display_name=display_name,
                preferred_name=preferred_name,
                initials=initials,
                salutation=salutation,
                title=title,
                marital_status=marital_status,
                partner=utils.get_pydantic_model(partner, Optional[models.PersonInput]),
                division=division,
                division_id=division_id,
                department=department,
                department_id=department_id,
                department_name=department_name,
                team=utils.get_pydantic_model(team, OptionalNullable[models.Team]),
                company_id=company_id,
                company_name=company_name,
                employment_start_date=employment_start_date,
                employment_end_date=employment_end_date,
                leaving_reason=leaving_reason,
                employee_number=employee_number,
                employment_status=employment_status,
                employment_role=utils.get_pydantic_model(
                    employment_role, Optional[models.EmploymentRole]
                ),
                ethnicity=ethnicity,
                manager=utils.get_pydantic_model(manager, Optional[models.Manager]),
                direct_reports=direct_reports,
                social_security_number=social_security_number,
                birthday=birthday,
                deceased_on=deceased_on,
                country_of_birth=country_of_birth,
                description=description,
                gender=gender,
                pronouns=pronouns,
                preferred_language=preferred_language,
                languages=languages,
                nationalities=nationalities,
                photo_url=photo_url,
                timezone=timezone,
                source=source,
                source_id=source_id,
                record_url=record_url,
                jobs=utils.get_pydantic_model(
                    jobs, OptionalNullable[List[models.EmployeeJobInput]]
                ),
                compensations=utils.get_pydantic_model(
                    compensations,
                    OptionalNullable[List[models.EmployeeCompensationInput]],
                ),
                works_remote=works_remote,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                social_links=utils.get_pydantic_model(
                    social_links, Optional[List[models.SocialLink]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                tax_code=tax_code,
                tax_id=tax_id,
                dietary_preference=dietary_preference,
                food_allergies=food_allergies,
                probation_period=utils.get_pydantic_model(
                    probation_period, Optional[models.ProbationPeriod]
                ),
                tags=tags,
                row_version=row_version,
                deleted=deleted,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/hris/employees",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee, False, False, "json", models.EmployeeInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesAdd",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.HrisEmployeesAddResponse(
                create_employee_response=unmarshal_json_response(
                    Optional[models.CreateEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        id: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        preferred_name: OptionalNullable[str] = UNSET,
        initials: OptionalNullable[str] = UNSET,
        salutation: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        marital_status: OptionalNullable[str] = UNSET,
        partner: Optional[
            Union[models.PersonInput, models.PersonInputTypedDict]
        ] = None,
        division: OptionalNullable[str] = UNSET,
        division_id: OptionalNullable[str] = UNSET,
        department: OptionalNullable[str] = UNSET,
        department_id: OptionalNullable[str] = UNSET,
        department_name: OptionalNullable[str] = UNSET,
        team: OptionalNullable[Union[models.Team, models.TeamTypedDict]] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        employment_start_date: OptionalNullable[str] = UNSET,
        employment_end_date: OptionalNullable[str] = UNSET,
        leaving_reason: OptionalNullable[models.LeavingReason] = UNSET,
        employee_number: OptionalNullable[str] = UNSET,
        employment_status: OptionalNullable[models.EmploymentStatus] = UNSET,
        employment_role: Optional[
            Union[models.EmploymentRole, models.EmploymentRoleTypedDict]
        ] = None,
        ethnicity: OptionalNullable[str] = UNSET,
        manager: Optional[Union[models.Manager, models.ManagerTypedDict]] = None,
        direct_reports: OptionalNullable[List[str]] = UNSET,
        social_security_number: OptionalNullable[str] = UNSET,
        birthday: OptionalNullable[date] = UNSET,
        deceased_on: OptionalNullable[date] = UNSET,
        country_of_birth: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        gender: OptionalNullable[models.Gender] = UNSET,
        pronouns: OptionalNullable[str] = UNSET,
        preferred_language: OptionalNullable[str] = UNSET,
        languages: Optional[List[Nullable[str]]] = None,
        nationalities: Optional[List[Nullable[str]]] = None,
        photo_url: OptionalNullable[str] = UNSET,
        timezone: OptionalNullable[str] = UNSET,
        source: OptionalNullable[str] = UNSET,
        source_id: OptionalNullable[str] = UNSET,
        record_url: OptionalNullable[str] = UNSET,
        jobs: OptionalNullable[
            Union[List[models.EmployeeJobInput], List[models.EmployeeJobInputTypedDict]]
        ] = UNSET,
        compensations: OptionalNullable[
            Union[
                List[models.EmployeeCompensationInput],
                List[models.EmployeeCompensationInputTypedDict],
            ]
        ] = UNSET,
        works_remote: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        social_links: Optional[
            Union[List[models.SocialLink], List[models.SocialLinkTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        tax_code: OptionalNullable[str] = UNSET,
        tax_id: OptionalNullable[str] = UNSET,
        dietary_preference: OptionalNullable[str] = UNSET,
        food_allergies: OptionalNullable[List[str]] = UNSET,
        probation_period: Optional[
            Union[models.ProbationPeriod, models.ProbationPeriodTypedDict]
        ] = None,
        tags: OptionalNullable[List[str]] = UNSET,
        row_version: OptionalNullable[str] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesAddResponse:
        r"""Create Employee

        Create Employee

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param id: A unique identifier for an object.
        :param first_name: The first name of the person.
        :param last_name: The last name of the person.
        :param middle_name: Middle name of the person.
        :param display_name: The name used to display the employee, often a combination of their first and last names.
        :param preferred_name: The name the employee prefers to be addressed by, which may be different from their legal name.
        :param initials: The initials of the person, usually derived from their first, middle, and last names.
        :param salutation: A formal salutation for the person. For example, 'Mr', 'Mrs'
        :param title: The job title of the person.
        :param marital_status: The marital status of the employee.
        :param partner:
        :param division: The division the person is currently in. Usually a collection of departments or teams or regions.
        :param division_id: Unique identifier of the division this employee belongs to.
        :param department: The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field.
        :param department_id: Unique identifier of the department ID this employee belongs to.
        :param department_name: Name of the department this employee belongs to.
        :param team: The team the person is currently in.
        :param company_id: The unique identifier of the company.
        :param company_name: The name of the company.
        :param employment_start_date: A Start Date is the date that the employee started working at the company
        :param employment_end_date: An End Date is the date that the employee ended working at the company
        :param leaving_reason: The reason because the employment ended.
        :param employee_number: An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company.
        :param employment_status: The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status.
        :param employment_role:
        :param ethnicity: The ethnicity of the employee
        :param manager:
        :param direct_reports: Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee.
        :param social_security_number: A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions.
        :param birthday: The date of birth of the person.
        :param deceased_on: The date the person deceased.
        :param country_of_birth: Country code according to ISO 3166-1 alpha-2.
        :param description: A description of the object.
        :param gender: The gender represents the gender identity of a person.
        :param pronouns: The preferred pronouns of the person.
        :param preferred_language: language code according to ISO 639-1. For the United States - EN
        :param languages:
        :param nationalities:
        :param photo_url: The URL of the photo of a person.
        :param timezone: The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London.
        :param source: When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from.
        :param source_id: Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS).
        :param record_url:
        :param jobs:
        :param compensations:
        :param works_remote: Indicates if the employee works from a remote location.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param custom_fields:
        :param social_links:
        :param bank_accounts:
        :param tax_code:
        :param tax_id:
        :param dietary_preference: Indicate the employee's dietary preference.
        :param food_allergies: Indicate the employee's food allergies.
        :param probation_period:
        :param tags:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param deleted: Flag to indicate if the object is deleted.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            employee=models.EmployeeInput(
                id=id,
                first_name=first_name,
                last_name=last_name,
                middle_name=middle_name,
                display_name=display_name,
                preferred_name=preferred_name,
                initials=initials,
                salutation=salutation,
                title=title,
                marital_status=marital_status,
                partner=utils.get_pydantic_model(partner, Optional[models.PersonInput]),
                division=division,
                division_id=division_id,
                department=department,
                department_id=department_id,
                department_name=department_name,
                team=utils.get_pydantic_model(team, OptionalNullable[models.Team]),
                company_id=company_id,
                company_name=company_name,
                employment_start_date=employment_start_date,
                employment_end_date=employment_end_date,
                leaving_reason=leaving_reason,
                employee_number=employee_number,
                employment_status=employment_status,
                employment_role=utils.get_pydantic_model(
                    employment_role, Optional[models.EmploymentRole]
                ),
                ethnicity=ethnicity,
                manager=utils.get_pydantic_model(manager, Optional[models.Manager]),
                direct_reports=direct_reports,
                social_security_number=social_security_number,
                birthday=birthday,
                deceased_on=deceased_on,
                country_of_birth=country_of_birth,
                description=description,
                gender=gender,
                pronouns=pronouns,
                preferred_language=preferred_language,
                languages=languages,
                nationalities=nationalities,
                photo_url=photo_url,
                timezone=timezone,
                source=source,
                source_id=source_id,
                record_url=record_url,
                jobs=utils.get_pydantic_model(
                    jobs, OptionalNullable[List[models.EmployeeJobInput]]
                ),
                compensations=utils.get_pydantic_model(
                    compensations,
                    OptionalNullable[List[models.EmployeeCompensationInput]],
                ),
                works_remote=works_remote,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                social_links=utils.get_pydantic_model(
                    social_links, Optional[List[models.SocialLink]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                tax_code=tax_code,
                tax_id=tax_id,
                dietary_preference=dietary_preference,
                food_allergies=food_allergies,
                probation_period=utils.get_pydantic_model(
                    probation_period, Optional[models.ProbationPeriod]
                ),
                tags=tags,
                row_version=row_version,
                deleted=deleted,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/hris/employees",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee, False, False, "json", models.EmployeeInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesAdd",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.HrisEmployeesAddResponse(
                create_employee_response=unmarshal_json_response(
                    Optional[models.CreateEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        filter_: Optional[
            Union[models.EmployeesOneFilter, models.EmployeesOneFilterTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesOneResponse:
        r"""Get Employee

        Get Employee

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param filter_: Apply filters
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
            filter_=utils.get_pydantic_model(
                filter_, Optional[models.EmployeesOneFilter]
            ),
            pass_through=pass_through,
        )

        req = self._build_request(
            method="GET",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesOne",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesOneResponse(
                get_employee_response=unmarshal_json_response(
                    Optional[models.GetEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        filter_: Optional[
            Union[models.EmployeesOneFilter, models.EmployeesOneFilterTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesOneResponse:
        r"""Get Employee

        Get Employee

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param filter_: Apply filters
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
            filter_=utils.get_pydantic_model(
                filter_, Optional[models.EmployeesOneFilter]
            ),
            pass_through=pass_through,
        )

        req = self._build_request_async(
            method="GET",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesOne",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesOneResponse(
                get_employee_response=unmarshal_json_response(
                    Optional[models.GetEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id_param: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        id: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        preferred_name: OptionalNullable[str] = UNSET,
        initials: OptionalNullable[str] = UNSET,
        salutation: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        marital_status: OptionalNullable[str] = UNSET,
        partner: Optional[
            Union[models.PersonInput, models.PersonInputTypedDict]
        ] = None,
        division: OptionalNullable[str] = UNSET,
        division_id: OptionalNullable[str] = UNSET,
        department: OptionalNullable[str] = UNSET,
        department_id: OptionalNullable[str] = UNSET,
        department_name: OptionalNullable[str] = UNSET,
        team: OptionalNullable[Union[models.Team, models.TeamTypedDict]] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        employment_start_date: OptionalNullable[str] = UNSET,
        employment_end_date: OptionalNullable[str] = UNSET,
        leaving_reason: OptionalNullable[models.LeavingReason] = UNSET,
        employee_number: OptionalNullable[str] = UNSET,
        employment_status: OptionalNullable[models.EmploymentStatus] = UNSET,
        employment_role: Optional[
            Union[models.EmploymentRole, models.EmploymentRoleTypedDict]
        ] = None,
        ethnicity: OptionalNullable[str] = UNSET,
        manager: Optional[Union[models.Manager, models.ManagerTypedDict]] = None,
        direct_reports: OptionalNullable[List[str]] = UNSET,
        social_security_number: OptionalNullable[str] = UNSET,
        birthday: OptionalNullable[date] = UNSET,
        deceased_on: OptionalNullable[date] = UNSET,
        country_of_birth: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        gender: OptionalNullable[models.Gender] = UNSET,
        pronouns: OptionalNullable[str] = UNSET,
        preferred_language: OptionalNullable[str] = UNSET,
        languages: Optional[List[Nullable[str]]] = None,
        nationalities: Optional[List[Nullable[str]]] = None,
        photo_url: OptionalNullable[str] = UNSET,
        timezone: OptionalNullable[str] = UNSET,
        source: OptionalNullable[str] = UNSET,
        source_id: OptionalNullable[str] = UNSET,
        record_url: OptionalNullable[str] = UNSET,
        jobs: OptionalNullable[
            Union[List[models.EmployeeJobInput], List[models.EmployeeJobInputTypedDict]]
        ] = UNSET,
        compensations: OptionalNullable[
            Union[
                List[models.EmployeeCompensationInput],
                List[models.EmployeeCompensationInputTypedDict],
            ]
        ] = UNSET,
        works_remote: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        social_links: Optional[
            Union[List[models.SocialLink], List[models.SocialLinkTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        tax_code: OptionalNullable[str] = UNSET,
        tax_id: OptionalNullable[str] = UNSET,
        dietary_preference: OptionalNullable[str] = UNSET,
        food_allergies: OptionalNullable[List[str]] = UNSET,
        probation_period: Optional[
            Union[models.ProbationPeriod, models.ProbationPeriodTypedDict]
        ] = None,
        tags: OptionalNullable[List[str]] = UNSET,
        row_version: OptionalNullable[str] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesUpdateResponse:
        r"""Update Employee

        Update Employee

        :param id_param: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param id: A unique identifier for an object.
        :param first_name: The first name of the person.
        :param last_name: The last name of the person.
        :param middle_name: Middle name of the person.
        :param display_name: The name used to display the employee, often a combination of their first and last names.
        :param preferred_name: The name the employee prefers to be addressed by, which may be different from their legal name.
        :param initials: The initials of the person, usually derived from their first, middle, and last names.
        :param salutation: A formal salutation for the person. For example, 'Mr', 'Mrs'
        :param title: The job title of the person.
        :param marital_status: The marital status of the employee.
        :param partner:
        :param division: The division the person is currently in. Usually a collection of departments or teams or regions.
        :param division_id: Unique identifier of the division this employee belongs to.
        :param department: The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field.
        :param department_id: Unique identifier of the department ID this employee belongs to.
        :param department_name: Name of the department this employee belongs to.
        :param team: The team the person is currently in.
        :param company_id: The unique identifier of the company.
        :param company_name: The name of the company.
        :param employment_start_date: A Start Date is the date that the employee started working at the company
        :param employment_end_date: An End Date is the date that the employee ended working at the company
        :param leaving_reason: The reason because the employment ended.
        :param employee_number: An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company.
        :param employment_status: The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status.
        :param employment_role:
        :param ethnicity: The ethnicity of the employee
        :param manager:
        :param direct_reports: Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee.
        :param social_security_number: A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions.
        :param birthday: The date of birth of the person.
        :param deceased_on: The date the person deceased.
        :param country_of_birth: Country code according to ISO 3166-1 alpha-2.
        :param description: A description of the object.
        :param gender: The gender represents the gender identity of a person.
        :param pronouns: The preferred pronouns of the person.
        :param preferred_language: language code according to ISO 639-1. For the United States - EN
        :param languages:
        :param nationalities:
        :param photo_url: The URL of the photo of a person.
        :param timezone: The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London.
        :param source: When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from.
        :param source_id: Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS).
        :param record_url:
        :param jobs:
        :param compensations:
        :param works_remote: Indicates if the employee works from a remote location.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param custom_fields:
        :param social_links:
        :param bank_accounts:
        :param tax_code:
        :param tax_id:
        :param dietary_preference: Indicate the employee's dietary preference.
        :param food_allergies: Indicate the employee's food allergies.
        :param probation_period:
        :param tags:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param deleted: Flag to indicate if the object is deleted.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesUpdateRequest(
            id_param=id_param,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            employee=models.EmployeeInput(
                id=id,
                first_name=first_name,
                last_name=last_name,
                middle_name=middle_name,
                display_name=display_name,
                preferred_name=preferred_name,
                initials=initials,
                salutation=salutation,
                title=title,
                marital_status=marital_status,
                partner=utils.get_pydantic_model(partner, Optional[models.PersonInput]),
                division=division,
                division_id=division_id,
                department=department,
                department_id=department_id,
                department_name=department_name,
                team=utils.get_pydantic_model(team, OptionalNullable[models.Team]),
                company_id=company_id,
                company_name=company_name,
                employment_start_date=employment_start_date,
                employment_end_date=employment_end_date,
                leaving_reason=leaving_reason,
                employee_number=employee_number,
                employment_status=employment_status,
                employment_role=utils.get_pydantic_model(
                    employment_role, Optional[models.EmploymentRole]
                ),
                ethnicity=ethnicity,
                manager=utils.get_pydantic_model(manager, Optional[models.Manager]),
                direct_reports=direct_reports,
                social_security_number=social_security_number,
                birthday=birthday,
                deceased_on=deceased_on,
                country_of_birth=country_of_birth,
                description=description,
                gender=gender,
                pronouns=pronouns,
                preferred_language=preferred_language,
                languages=languages,
                nationalities=nationalities,
                photo_url=photo_url,
                timezone=timezone,
                source=source,
                source_id=source_id,
                record_url=record_url,
                jobs=utils.get_pydantic_model(
                    jobs, OptionalNullable[List[models.EmployeeJobInput]]
                ),
                compensations=utils.get_pydantic_model(
                    compensations,
                    OptionalNullable[List[models.EmployeeCompensationInput]],
                ),
                works_remote=works_remote,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                social_links=utils.get_pydantic_model(
                    social_links, Optional[List[models.SocialLink]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                tax_code=tax_code,
                tax_id=tax_id,
                dietary_preference=dietary_preference,
                food_allergies=food_allergies,
                probation_period=utils.get_pydantic_model(
                    probation_period, Optional[models.ProbationPeriod]
                ),
                tags=tags,
                row_version=row_version,
                deleted=deleted,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee, False, False, "json", models.EmployeeInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesUpdateResponse(
                update_employee_response=unmarshal_json_response(
                    Optional[models.UpdateEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id_param: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        id: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        preferred_name: OptionalNullable[str] = UNSET,
        initials: OptionalNullable[str] = UNSET,
        salutation: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        marital_status: OptionalNullable[str] = UNSET,
        partner: Optional[
            Union[models.PersonInput, models.PersonInputTypedDict]
        ] = None,
        division: OptionalNullable[str] = UNSET,
        division_id: OptionalNullable[str] = UNSET,
        department: OptionalNullable[str] = UNSET,
        department_id: OptionalNullable[str] = UNSET,
        department_name: OptionalNullable[str] = UNSET,
        team: OptionalNullable[Union[models.Team, models.TeamTypedDict]] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        employment_start_date: OptionalNullable[str] = UNSET,
        employment_end_date: OptionalNullable[str] = UNSET,
        leaving_reason: OptionalNullable[models.LeavingReason] = UNSET,
        employee_number: OptionalNullable[str] = UNSET,
        employment_status: OptionalNullable[models.EmploymentStatus] = UNSET,
        employment_role: Optional[
            Union[models.EmploymentRole, models.EmploymentRoleTypedDict]
        ] = None,
        ethnicity: OptionalNullable[str] = UNSET,
        manager: Optional[Union[models.Manager, models.ManagerTypedDict]] = None,
        direct_reports: OptionalNullable[List[str]] = UNSET,
        social_security_number: OptionalNullable[str] = UNSET,
        birthday: OptionalNullable[date] = UNSET,
        deceased_on: OptionalNullable[date] = UNSET,
        country_of_birth: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        gender: OptionalNullable[models.Gender] = UNSET,
        pronouns: OptionalNullable[str] = UNSET,
        preferred_language: OptionalNullable[str] = UNSET,
        languages: Optional[List[Nullable[str]]] = None,
        nationalities: Optional[List[Nullable[str]]] = None,
        photo_url: OptionalNullable[str] = UNSET,
        timezone: OptionalNullable[str] = UNSET,
        source: OptionalNullable[str] = UNSET,
        source_id: OptionalNullable[str] = UNSET,
        record_url: OptionalNullable[str] = UNSET,
        jobs: OptionalNullable[
            Union[List[models.EmployeeJobInput], List[models.EmployeeJobInputTypedDict]]
        ] = UNSET,
        compensations: OptionalNullable[
            Union[
                List[models.EmployeeCompensationInput],
                List[models.EmployeeCompensationInputTypedDict],
            ]
        ] = UNSET,
        works_remote: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        social_links: Optional[
            Union[List[models.SocialLink], List[models.SocialLinkTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        tax_code: OptionalNullable[str] = UNSET,
        tax_id: OptionalNullable[str] = UNSET,
        dietary_preference: OptionalNullable[str] = UNSET,
        food_allergies: OptionalNullable[List[str]] = UNSET,
        probation_period: Optional[
            Union[models.ProbationPeriod, models.ProbationPeriodTypedDict]
        ] = None,
        tags: OptionalNullable[List[str]] = UNSET,
        row_version: OptionalNullable[str] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesUpdateResponse:
        r"""Update Employee

        Update Employee

        :param id_param: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param id: A unique identifier for an object.
        :param first_name: The first name of the person.
        :param last_name: The last name of the person.
        :param middle_name: Middle name of the person.
        :param display_name: The name used to display the employee, often a combination of their first and last names.
        :param preferred_name: The name the employee prefers to be addressed by, which may be different from their legal name.
        :param initials: The initials of the person, usually derived from their first, middle, and last names.
        :param salutation: A formal salutation for the person. For example, 'Mr', 'Mrs'
        :param title: The job title of the person.
        :param marital_status: The marital status of the employee.
        :param partner:
        :param division: The division the person is currently in. Usually a collection of departments or teams or regions.
        :param division_id: Unique identifier of the division this employee belongs to.
        :param department: The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field.
        :param department_id: Unique identifier of the department ID this employee belongs to.
        :param department_name: Name of the department this employee belongs to.
        :param team: The team the person is currently in.
        :param company_id: The unique identifier of the company.
        :param company_name: The name of the company.
        :param employment_start_date: A Start Date is the date that the employee started working at the company
        :param employment_end_date: An End Date is the date that the employee ended working at the company
        :param leaving_reason: The reason because the employment ended.
        :param employee_number: An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company.
        :param employment_status: The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status.
        :param employment_role:
        :param ethnicity: The ethnicity of the employee
        :param manager:
        :param direct_reports: Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee.
        :param social_security_number: A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions.
        :param birthday: The date of birth of the person.
        :param deceased_on: The date the person deceased.
        :param country_of_birth: Country code according to ISO 3166-1 alpha-2.
        :param description: A description of the object.
        :param gender: The gender represents the gender identity of a person.
        :param pronouns: The preferred pronouns of the person.
        :param preferred_language: language code according to ISO 639-1. For the United States - EN
        :param languages:
        :param nationalities:
        :param photo_url: The URL of the photo of a person.
        :param timezone: The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London.
        :param source: When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from.
        :param source_id: Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS).
        :param record_url:
        :param jobs:
        :param compensations:
        :param works_remote: Indicates if the employee works from a remote location.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param custom_fields:
        :param social_links:
        :param bank_accounts:
        :param tax_code:
        :param tax_id:
        :param dietary_preference: Indicate the employee's dietary preference.
        :param food_allergies: Indicate the employee's food allergies.
        :param probation_period:
        :param tags:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param deleted: Flag to indicate if the object is deleted.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesUpdateRequest(
            id_param=id_param,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            employee=models.EmployeeInput(
                id=id,
                first_name=first_name,
                last_name=last_name,
                middle_name=middle_name,
                display_name=display_name,
                preferred_name=preferred_name,
                initials=initials,
                salutation=salutation,
                title=title,
                marital_status=marital_status,
                partner=utils.get_pydantic_model(partner, Optional[models.PersonInput]),
                division=division,
                division_id=division_id,
                department=department,
                department_id=department_id,
                department_name=department_name,
                team=utils.get_pydantic_model(team, OptionalNullable[models.Team]),
                company_id=company_id,
                company_name=company_name,
                employment_start_date=employment_start_date,
                employment_end_date=employment_end_date,
                leaving_reason=leaving_reason,
                employee_number=employee_number,
                employment_status=employment_status,
                employment_role=utils.get_pydantic_model(
                    employment_role, Optional[models.EmploymentRole]
                ),
                ethnicity=ethnicity,
                manager=utils.get_pydantic_model(manager, Optional[models.Manager]),
                direct_reports=direct_reports,
                social_security_number=social_security_number,
                birthday=birthday,
                deceased_on=deceased_on,
                country_of_birth=country_of_birth,
                description=description,
                gender=gender,
                pronouns=pronouns,
                preferred_language=preferred_language,
                languages=languages,
                nationalities=nationalities,
                photo_url=photo_url,
                timezone=timezone,
                source=source,
                source_id=source_id,
                record_url=record_url,
                jobs=utils.get_pydantic_model(
                    jobs, OptionalNullable[List[models.EmployeeJobInput]]
                ),
                compensations=utils.get_pydantic_model(
                    compensations,
                    OptionalNullable[List[models.EmployeeCompensationInput]],
                ),
                works_remote=works_remote,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                social_links=utils.get_pydantic_model(
                    social_links, Optional[List[models.SocialLink]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                tax_code=tax_code,
                tax_id=tax_id,
                dietary_preference=dietary_preference,
                food_allergies=food_allergies,
                probation_period=utils.get_pydantic_model(
                    probation_period, Optional[models.ProbationPeriod]
                ),
                tags=tags,
                row_version=row_version,
                deleted=deleted,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.employee, False, False, "json", models.EmployeeInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesUpdate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesUpdateResponse(
                update_employee_response=unmarshal_json_response(
                    Optional[models.UpdateEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesDeleteResponse:
        r"""Delete Employee

        Delete Employee

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request(
            method="DELETE",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesDeleteResponse(
                delete_employee_response=unmarshal_json_response(
                    Optional[models.DeleteEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.HrisEmployeesDeleteResponse:
        r"""Delete Employee

        Delete Employee

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.HrisEmployeesDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/hris/employees/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.HrisEmployeesDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="hris.employeesDelete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.HrisEmployeesDeleteResponse(
                delete_employee_response=unmarshal_json_response(
                    Optional[models.DeleteEmployeeResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.HrisEmployeesDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)
