"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentreferencetype import AttachmentReferenceType
from .createattachmentresponse import (
    CreateAttachmentResponse,
    CreateAttachmentResponseTypedDict,
)
from .httpmetadata import HTTPMetadata, HTTPMetadataTypedDict
from .unexpectederrorresponse import (
    UnexpectedErrorResponse,
    UnexpectedErrorResponseTypedDict,
)
from apideck_unify.types import BaseModel
from apideck_unify.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import io
import pydantic
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ACCOUNTING_ATTACHMENTS_UPLOAD_OP_SERVERS = [
    "https://upload.apideck.com",
]


class AccountingAttachmentsUploadGlobalsTypedDict(TypedDict):
    consumer_id: NotRequired[str]
    r"""ID of the consumer which you want to get or push data from"""
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""


class AccountingAttachmentsUploadGlobals(BaseModel):
    consumer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-consumer-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""ID of the consumer which you want to get or push data from"""

    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""


class AccountingAttachmentsUploadRequestTypedDict(TypedDict):
    reference_type: AttachmentReferenceType
    r"""The reference type of the document."""
    reference_id: str
    r"""The reference id of the object to retrieve."""
    request_body: Union[bytes, IO[bytes], io.BufferedReader]
    raw: NotRequired[bool]
    r"""Include raw response. Mostly used for debugging purposes"""
    x_apideck_metadata: NotRequired[str]
    r"""Metadata to attach to the attachment file (JSON string)"""
    consumer_id: NotRequired[str]
    r"""ID of the consumer which you want to get or push data from"""
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""
    service_id: NotRequired[str]
    r"""Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API."""


class AccountingAttachmentsUploadRequest(BaseModel):
    reference_type: Annotated[
        AttachmentReferenceType,
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The reference type of the document."""

    reference_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The reference id of the object to retrieve."""

    request_body: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        FieldMetadata(request=RequestMetadata(media_type="*/*")),
    ]

    raw: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Include raw response. Mostly used for debugging purposes"""

    x_apideck_metadata: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-metadata"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Metadata to attach to the attachment file (JSON string)"""

    consumer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-consumer-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""ID of the consumer which you want to get or push data from"""

    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""

    service_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-service-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API."""


class AccountingAttachmentsUploadResponseTypedDict(TypedDict):
    http_meta: HTTPMetadataTypedDict
    create_attachment_response: NotRequired[CreateAttachmentResponseTypedDict]
    r"""Attachments"""
    unexpected_error_response: NotRequired[UnexpectedErrorResponseTypedDict]
    r"""Unexpected error"""


class AccountingAttachmentsUploadResponse(BaseModel):
    http_meta: Annotated[Optional[HTTPMetadata], pydantic.Field(exclude=True)] = None

    create_attachment_response: Optional[CreateAttachmentResponse] = None
    r"""Attachments"""

    unexpected_error_response: Optional[UnexpectedErrorResponse] = None
    r"""Unexpected error"""
