"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import BaseModel
from datetime import date
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class TransactionType(str, Enum):
    r"""Type of the transaction."""

    INVOICE = "invoice"
    CREDIT_NOTE = "credit_note"
    BILL = "bill"
    PAYMENT = "payment"
    BILL_PAYMENT = "bill_payment"


class BalanceByTransactionTypedDict(TypedDict):
    transaction_id: NotRequired[str]
    r"""Unique identifier for the transaction."""
    transaction_date: NotRequired[date]
    r"""Date of the transaction."""
    transaction_type: NotRequired[TransactionType]
    r"""Type of the transaction."""
    due_date: NotRequired[date]
    r"""Due date of the transaction."""
    original_amount: NotRequired[float]
    r"""Original amount of the transaction."""
    outstanding_balance: NotRequired[float]
    r"""Outstanding balance of the transaction."""
    transaction_number: NotRequired[str]
    r"""Transaction number of the transaction."""


class BalanceByTransaction(BaseModel):
    transaction_id: Optional[str] = None
    r"""Unique identifier for the transaction."""

    transaction_date: Optional[date] = None
    r"""Date of the transaction."""

    transaction_type: Optional[TransactionType] = None
    r"""Type of the transaction."""

    due_date: Optional[date] = None
    r"""Due date of the transaction."""

    original_amount: Optional[float] = None
    r"""Original amount of the transaction."""

    outstanding_balance: Optional[float] = None
    r"""Outstanding balance of the transaction."""

    transaction_number: Optional[str] = None
    r"""Transaction number of the transaction."""
