"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class AccountType(str, Enum):
    r"""The type of bank account."""

    BANK_ACCOUNT = "bank_account"
    CREDIT_CARD = "credit_card"
    OTHER = "other"


class BankAccountTypedDict(TypedDict):
    bank_name: NotRequired[Nullable[str]]
    r"""The name of the bank"""
    account_number: NotRequired[Nullable[str]]
    r"""A bank account number is a number that is tied to your bank account. If you have several bank accounts, such as personal, joint, business (and so on), each account will have a different account number."""
    account_name: NotRequired[Nullable[str]]
    r"""The name which you used in opening your bank account."""
    account_type: NotRequired[Nullable[AccountType]]
    r"""The type of bank account."""
    iban: NotRequired[Nullable[str]]
    r"""The International Bank Account Number (IBAN)."""
    bic: NotRequired[Nullable[str]]
    r"""The Bank Identifier Code (BIC)."""
    routing_number: NotRequired[Nullable[str]]
    r"""A routing number is a nine-digit code used to identify a financial institution in the United States."""
    bsb_number: NotRequired[Nullable[str]]
    r"""A BSB is a 6 digit numeric code used for identifying the branch of an Australian or New Zealand bank or financial institution."""
    branch_identifier: NotRequired[Nullable[str]]
    r"""A branch identifier is a unique identifier for a branch of a bank or financial institution."""
    bank_code: NotRequired[Nullable[str]]
    r"""A bank code is a code assigned by a central bank, a bank supervisory body or a Bankers Association in a country to all its licensed member banks or financial institutions."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""


class BankAccount(BaseModel):
    bank_name: OptionalNullable[str] = UNSET
    r"""The name of the bank"""

    account_number: OptionalNullable[str] = UNSET
    r"""A bank account number is a number that is tied to your bank account. If you have several bank accounts, such as personal, joint, business (and so on), each account will have a different account number."""

    account_name: OptionalNullable[str] = UNSET
    r"""The name which you used in opening your bank account."""

    account_type: OptionalNullable[AccountType] = UNSET
    r"""The type of bank account."""

    iban: OptionalNullable[str] = UNSET
    r"""The International Bank Account Number (IBAN)."""

    bic: OptionalNullable[str] = UNSET
    r"""The Bank Identifier Code (BIC)."""

    routing_number: OptionalNullable[str] = UNSET
    r"""A routing number is a nine-digit code used to identify a financial institution in the United States."""

    bsb_number: OptionalNullable[str] = UNSET
    r"""A BSB is a 6 digit numeric code used for identifying the branch of an Australian or New Zealand bank or financial institution."""

    branch_identifier: OptionalNullable[str] = UNSET
    r"""A branch identifier is a unique identifier for a branch of a bank or financial institution."""

    bank_code: OptionalNullable[str] = UNSET
    r"""A bank code is a code assigned by a central bank, a bank supervisory body or a Bankers Association in a country to all its licensed member banks or financial institutions."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "bank_name",
            "account_number",
            "account_name",
            "account_type",
            "iban",
            "bic",
            "routing_number",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "currency",
            "country",
        ]
        nullable_fields = [
            "bank_name",
            "account_number",
            "account_name",
            "account_type",
            "iban",
            "bic",
            "routing_number",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "currency",
            "country",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
