"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class BankAccountType(str, Enum):
    r"""Type of the bank account."""

    BANK = "bank"
    CREDIT_CARD = "credit_card"


class FeedStatus(str, Enum):
    r"""Current status of the bank feed."""

    PENDING = "pending"
    REJECTED = "rejected"


class BankFeedAccountTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    bank_account_type: NotRequired[BankAccountType]
    r"""Type of the bank account."""
    source_account_id: NotRequired[str]
    r"""The source account's unique identifier."""
    target_account_id: NotRequired[str]
    r"""The target account's unique identifier in the accounting connector."""
    target_account_name: NotRequired[str]
    r"""Name associated with the target account."""
    target_account_number: NotRequired[str]
    r"""Account number of the destination bank account."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    feed_status: NotRequired[FeedStatus]
    r"""Current status of the bank feed."""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""


class BankFeedAccount(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    bank_account_type: Optional[BankAccountType] = None
    r"""Type of the bank account."""

    source_account_id: Optional[str] = None
    r"""The source account's unique identifier."""

    target_account_id: Optional[str] = None
    r"""The target account's unique identifier in the accounting connector."""

    target_account_name: Optional[str] = None
    r"""Name associated with the target account."""

    target_account_number: Optional[str] = None
    r"""Account number of the destination bank account."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    feed_status: Optional[FeedStatus] = None
    r"""Current status of the bank feed."""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    custom_fields: Optional[List[CustomField]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "bank_account_type",
            "source_account_id",
            "target_account_id",
            "target_account_name",
            "target_account_number",
            "currency",
            "feed_status",
            "country",
            "custom_fields",
            "custom_mappings",
            "created_at",
            "updated_at",
            "updated_by",
            "created_by",
        ]
        nullable_fields = [
            "currency",
            "country",
            "custom_mappings",
            "created_at",
            "updated_at",
            "updated_by",
            "created_by",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BankFeedAccountInputTypedDict(TypedDict):
    bank_account_type: NotRequired[BankAccountType]
    r"""Type of the bank account."""
    source_account_id: NotRequired[str]
    r"""The source account's unique identifier."""
    target_account_id: NotRequired[str]
    r"""The target account's unique identifier in the accounting connector."""
    target_account_name: NotRequired[str]
    r"""Name associated with the target account."""
    target_account_number: NotRequired[str]
    r"""Account number of the destination bank account."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    feed_status: NotRequired[FeedStatus]
    r"""Current status of the bank feed."""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]


class BankFeedAccountInput(BaseModel):
    bank_account_type: Optional[BankAccountType] = None
    r"""Type of the bank account."""

    source_account_id: Optional[str] = None
    r"""The source account's unique identifier."""

    target_account_id: Optional[str] = None
    r"""The target account's unique identifier in the accounting connector."""

    target_account_name: Optional[str] = None
    r"""Name associated with the target account."""

    target_account_number: Optional[str] = None
    r"""Account number of the destination bank account."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    feed_status: Optional[FeedStatus] = None
    r"""Current status of the bank feed."""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    custom_fields: Optional[List[CustomField]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "bank_account_type",
            "source_account_id",
            "target_account_id",
            "target_account_name",
            "target_account_number",
            "currency",
            "feed_status",
            "country",
            "custom_fields",
        ]
        nullable_fields = ["currency", "country"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
