"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .creditordebit import CreditOrDebit
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class StatementStatus(str, Enum):
    r"""The current status of the bank feed statement."""

    PENDING = "pending"
    REJECTED = "rejected"
    SUCCESS = "success"


class BankFeedStatementTransactionType(str, Enum):
    r"""Type of transaction."""

    CREDIT = "credit"
    DEBIT = "debit"
    DEPOSIT = "deposit"
    TRANSFER = "transfer"
    PAYMENT = "payment"
    OTHER = "other"


class TransactionsTypedDict(TypedDict):
    posted_date: datetime
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""
    amount: float
    r"""The amount of the transaction."""
    credit_or_debit: CreditOrDebit
    r"""Whether the amount is a credit or debit."""
    source_transaction_id: str
    r"""The ID of the source transaction."""
    description: NotRequired[str]
    r"""A description of the transaction."""
    counterparty: NotRequired[str]
    r"""The counterparty of the transaction."""
    reference: NotRequired[str]
    r"""The reference of the transaction."""
    transaction_type: NotRequired[BankFeedStatementTransactionType]
    r"""Type of transaction."""


class Transactions(BaseModel):
    posted_date: datetime
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""

    amount: float
    r"""The amount of the transaction."""

    credit_or_debit: CreditOrDebit
    r"""Whether the amount is a credit or debit."""

    source_transaction_id: str
    r"""The ID of the source transaction."""

    description: Optional[str] = None
    r"""A description of the transaction."""

    counterparty: Optional[str] = None
    r"""The counterparty of the transaction."""

    reference: Optional[str] = None
    r"""The reference of the transaction."""

    transaction_type: Optional[BankFeedStatementTransactionType] = None
    r"""Type of transaction."""


class BankFeedStatementTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    bank_feed_account_id: NotRequired[str]
    r"""The ID of the bank feed account this statement belongs to."""
    status: NotRequired[StatementStatus]
    r"""The current status of the bank feed statement."""
    start_date: NotRequired[datetime]
    r"""Start date of the bank feed statement."""
    end_date: NotRequired[datetime]
    r"""End date of the bank feed statement."""
    start_balance: NotRequired[float]
    r"""Balance amount at the start of the period."""
    start_balance_credit_or_debit: NotRequired[CreditOrDebit]
    r"""Whether the amount is a credit or debit."""
    end_balance: NotRequired[float]
    r"""Balance amount at the end of the period."""
    end_balance_credit_or_debit: NotRequired[CreditOrDebit]
    r"""Whether the amount is a credit or debit."""
    transactions: NotRequired[List[TransactionsTypedDict]]
    r"""List of transactions in the bank feed statement."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""


class BankFeedStatement(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    bank_feed_account_id: Optional[str] = None
    r"""The ID of the bank feed account this statement belongs to."""

    status: Optional[StatementStatus] = None
    r"""The current status of the bank feed statement."""

    start_date: Optional[datetime] = None
    r"""Start date of the bank feed statement."""

    end_date: Optional[datetime] = None
    r"""End date of the bank feed statement."""

    start_balance: Optional[float] = None
    r"""Balance amount at the start of the period."""

    start_balance_credit_or_debit: Optional[CreditOrDebit] = None
    r"""Whether the amount is a credit or debit."""

    end_balance: Optional[float] = None
    r"""Balance amount at the end of the period."""

    end_balance_credit_or_debit: Optional[CreditOrDebit] = None
    r"""Whether the amount is a credit or debit."""

    transactions: Optional[List[Transactions]] = None
    r"""List of transactions in the bank feed statement."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "bank_feed_account_id",
            "status",
            "start_date",
            "end_date",
            "start_balance",
            "start_balance_credit_or_debit",
            "end_balance",
            "end_balance_credit_or_debit",
            "transactions",
            "created_at",
            "created_by",
            "updated_at",
            "updated_by",
        ]
        nullable_fields = ["created_at", "created_by", "updated_at", "updated_by"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BankFeedStatementInputTypedDict(TypedDict):
    bank_feed_account_id: NotRequired[str]
    r"""The ID of the bank feed account this statement belongs to."""
    status: NotRequired[StatementStatus]
    r"""The current status of the bank feed statement."""
    start_date: NotRequired[datetime]
    r"""Start date of the bank feed statement."""
    end_date: NotRequired[datetime]
    r"""End date of the bank feed statement."""
    start_balance: NotRequired[float]
    r"""Balance amount at the start of the period."""
    start_balance_credit_or_debit: NotRequired[CreditOrDebit]
    r"""Whether the amount is a credit or debit."""
    end_balance: NotRequired[float]
    r"""Balance amount at the end of the period."""
    end_balance_credit_or_debit: NotRequired[CreditOrDebit]
    r"""Whether the amount is a credit or debit."""
    transactions: NotRequired[List[TransactionsTypedDict]]
    r"""List of transactions in the bank feed statement."""


class BankFeedStatementInput(BaseModel):
    bank_feed_account_id: Optional[str] = None
    r"""The ID of the bank feed account this statement belongs to."""

    status: Optional[StatementStatus] = None
    r"""The current status of the bank feed statement."""

    start_date: Optional[datetime] = None
    r"""Start date of the bank feed statement."""

    end_date: Optional[datetime] = None
    r"""End date of the bank feed statement."""

    start_balance: Optional[float] = None
    r"""Balance amount at the start of the period."""

    start_balance_credit_or_debit: Optional[CreditOrDebit] = None
    r"""Whether the amount is a credit or debit."""

    end_balance: Optional[float] = None
    r"""Balance amount at the end of the period."""

    end_balance_credit_or_debit: Optional[CreditOrDebit] = None
    r"""Whether the amount is a credit or debit."""

    transactions: Optional[List[Transactions]] = None
    r"""List of transactions in the bank feed statement."""
