"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .bankaccount1 import BankAccount1, BankAccount1TypedDict
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from .email import Email, EmailTypedDict
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .sociallink import SocialLink, SocialLinkTypedDict
from .website import Website, WebsiteTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import date, datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class CompanyRowTypeTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    name: NotRequired[Nullable[str]]


class CompanyRowType(BaseModel):
    id: OptionalNullable[str] = UNSET

    name: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "name"]
        nullable_fields = ["id", "name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Company1TypedDict(TypedDict):
    name: Nullable[str]
    r"""Name of the company"""
    id: NotRequired[str]
    r"""Unique identifier for the company"""
    interaction_count: NotRequired[Nullable[int]]
    r"""Number of interactions"""
    owner_id: NotRequired[Nullable[str]]
    r"""Owner ID"""
    image: NotRequired[Nullable[str]]
    r"""The Image URL of the company"""
    description: NotRequired[Nullable[str]]
    r"""A description of the company"""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the company"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    status: NotRequired[Nullable[str]]
    r"""The status of the company"""
    fax: NotRequired[Nullable[str]]
    r"""The fax number of the company"""
    annual_revenue: NotRequired[Nullable[str]]
    r"""The annual revenue of the company"""
    number_of_employees: NotRequired[Nullable[str]]
    r"""Number of employees"""
    industry: NotRequired[Nullable[str]]
    r"""The industry represents the type of business the company is in."""
    ownership: NotRequired[Nullable[str]]
    r"""The ownership indicates the type of ownership of the company."""
    sales_tax_number: NotRequired[Nullable[str]]
    r"""A sales tax number is a unique number that identifies a company for tax purposes."""
    payee_number: NotRequired[Nullable[str]]
    r"""A payee number is a unique number that identifies a payee for tax purposes."""
    abn_or_tfn: NotRequired[Nullable[str]]
    r"""An ABN is necessary for operating a business, while a TFN (Tax File Number) is required for any person working in Australia."""
    abn_branch: NotRequired[Nullable[str]]
    r"""An ABN Branch (also known as a GST Branch) is used if part of your business needs to account for GST separately from its parent entity."""
    acn: NotRequired[Nullable[str]]
    r"""The Australian Company Number (ACN) is a nine digit number with the last digit being a check digit calculated using a modified modulus 10 calculation. ASIC has adopted a convention of always printing and displaying the ACN in the format XXX XXX XXX; three blocks of three characters, each block separated by a blank."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    parent_id: NotRequired[Nullable[str]]
    r"""Parent ID"""
    bank_accounts: NotRequired[List[BankAccount1TypedDict]]
    websites: NotRequired[List[WebsiteTypedDict]]
    addresses: NotRequired[List[AddressTypedDict]]
    social_links: NotRequired[List[SocialLinkTypedDict]]
    phone_numbers: NotRequired[List[PhoneNumberTypedDict]]
    emails: NotRequired[List[EmailTypedDict]]
    row_type: NotRequired[CompanyRowTypeTypedDict]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    tags: NotRequired[Nullable[List[str]]]
    read_only: NotRequired[Nullable[bool]]
    r"""Whether the company is read-only or not"""
    last_activity_at: NotRequired[Nullable[datetime]]
    r"""Last activity date"""
    deleted: NotRequired[bool]
    r"""Whether the company is deleted or not"""
    salutation: NotRequired[Nullable[str]]
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""
    birthday: NotRequired[Nullable[date]]
    r"""The date of birth of the person."""
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    updated_by: NotRequired[Nullable[str]]
    r"""Updated by user ID"""
    created_by: NotRequired[Nullable[str]]
    r"""Created by user ID"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Last updated date"""
    created_at: NotRequired[Nullable[datetime]]
    r"""Creation date"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Company1(BaseModel):
    name: Nullable[str]
    r"""Name of the company"""

    id: Optional[str] = None
    r"""Unique identifier for the company"""

    interaction_count: OptionalNullable[int] = UNSET
    r"""Number of interactions"""

    owner_id: OptionalNullable[str] = UNSET
    r"""Owner ID"""

    image: OptionalNullable[str] = UNSET
    r"""The Image URL of the company"""

    description: OptionalNullable[str] = UNSET
    r"""A description of the company"""

    vat_number: OptionalNullable[str] = UNSET
    r"""The VAT number of the company"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    status: OptionalNullable[str] = UNSET
    r"""The status of the company"""

    fax: OptionalNullable[str] = UNSET
    r"""The fax number of the company"""

    annual_revenue: OptionalNullable[str] = UNSET
    r"""The annual revenue of the company"""

    number_of_employees: OptionalNullable[str] = UNSET
    r"""Number of employees"""

    industry: OptionalNullable[str] = UNSET
    r"""The industry represents the type of business the company is in."""

    ownership: OptionalNullable[str] = UNSET
    r"""The ownership indicates the type of ownership of the company."""

    sales_tax_number: OptionalNullable[str] = UNSET
    r"""A sales tax number is a unique number that identifies a company for tax purposes."""

    payee_number: OptionalNullable[str] = UNSET
    r"""A payee number is a unique number that identifies a payee for tax purposes."""

    abn_or_tfn: OptionalNullable[str] = UNSET
    r"""An ABN is necessary for operating a business, while a TFN (Tax File Number) is required for any person working in Australia."""

    abn_branch: OptionalNullable[str] = UNSET
    r"""An ABN Branch (also known as a GST Branch) is used if part of your business needs to account for GST separately from its parent entity."""

    acn: OptionalNullable[str] = UNSET
    r"""The Australian Company Number (ACN) is a nine digit number with the last digit being a check digit calculated using a modified modulus 10 calculation. ASIC has adopted a convention of always printing and displaying the ACN in the format XXX XXX XXX; three blocks of three characters, each block separated by a blank."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    parent_id: OptionalNullable[str] = UNSET
    r"""Parent ID"""

    bank_accounts: Optional[List[BankAccount1]] = None

    websites: Optional[List[Website]] = None

    addresses: Optional[List[Address]] = None

    social_links: Optional[List[SocialLink]] = None

    phone_numbers: Optional[List[PhoneNumber]] = None

    emails: Optional[List[Email]] = None

    row_type: Optional[CompanyRowType] = None

    custom_fields: Optional[List[CustomField]] = None

    tags: OptionalNullable[List[str]] = UNSET

    read_only: OptionalNullable[bool] = UNSET
    r"""Whether the company is read-only or not"""

    last_activity_at: OptionalNullable[datetime] = UNSET
    r"""Last activity date"""

    deleted: Optional[bool] = None
    r"""Whether the company is deleted or not"""

    salutation: OptionalNullable[str] = UNSET
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""

    birthday: OptionalNullable[date] = UNSET
    r"""The date of birth of the person."""

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    updated_by: OptionalNullable[str] = UNSET
    r"""Updated by user ID"""

    created_by: OptionalNullable[str] = UNSET
    r"""Created by user ID"""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""Last updated date"""

    created_at: OptionalNullable[datetime] = UNSET
    r"""Creation date"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "interaction_count",
            "owner_id",
            "image",
            "description",
            "vat_number",
            "currency",
            "status",
            "fax",
            "annual_revenue",
            "number_of_employees",
            "industry",
            "ownership",
            "sales_tax_number",
            "payee_number",
            "abn_or_tfn",
            "abn_branch",
            "acn",
            "first_name",
            "last_name",
            "parent_id",
            "bank_accounts",
            "websites",
            "addresses",
            "social_links",
            "phone_numbers",
            "emails",
            "row_type",
            "custom_fields",
            "tags",
            "read_only",
            "last_activity_at",
            "deleted",
            "salutation",
            "birthday",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "name",
            "interaction_count",
            "owner_id",
            "image",
            "description",
            "vat_number",
            "currency",
            "status",
            "fax",
            "annual_revenue",
            "number_of_employees",
            "industry",
            "ownership",
            "sales_tax_number",
            "payee_number",
            "abn_or_tfn",
            "abn_branch",
            "acn",
            "first_name",
            "last_name",
            "parent_id",
            "tags",
            "read_only",
            "last_activity_at",
            "salutation",
            "birthday",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Company1InputTypedDict(TypedDict):
    name: Nullable[str]
    r"""Name of the company"""
    owner_id: NotRequired[Nullable[str]]
    r"""Owner ID"""
    image: NotRequired[Nullable[str]]
    r"""The Image URL of the company"""
    description: NotRequired[Nullable[str]]
    r"""A description of the company"""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the company"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    status: NotRequired[Nullable[str]]
    r"""The status of the company"""
    fax: NotRequired[Nullable[str]]
    r"""The fax number of the company"""
    annual_revenue: NotRequired[Nullable[str]]
    r"""The annual revenue of the company"""
    number_of_employees: NotRequired[Nullable[str]]
    r"""Number of employees"""
    industry: NotRequired[Nullable[str]]
    r"""The industry represents the type of business the company is in."""
    ownership: NotRequired[Nullable[str]]
    r"""The ownership indicates the type of ownership of the company."""
    sales_tax_number: NotRequired[Nullable[str]]
    r"""A sales tax number is a unique number that identifies a company for tax purposes."""
    payee_number: NotRequired[Nullable[str]]
    r"""A payee number is a unique number that identifies a payee for tax purposes."""
    abn_or_tfn: NotRequired[Nullable[str]]
    r"""An ABN is necessary for operating a business, while a TFN (Tax File Number) is required for any person working in Australia."""
    abn_branch: NotRequired[Nullable[str]]
    r"""An ABN Branch (also known as a GST Branch) is used if part of your business needs to account for GST separately from its parent entity."""
    acn: NotRequired[Nullable[str]]
    r"""The Australian Company Number (ACN) is a nine digit number with the last digit being a check digit calculated using a modified modulus 10 calculation. ASIC has adopted a convention of always printing and displaying the ACN in the format XXX XXX XXX; three blocks of three characters, each block separated by a blank."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    bank_accounts: NotRequired[List[BankAccount1TypedDict]]
    websites: NotRequired[List[WebsiteTypedDict]]
    addresses: NotRequired[List[AddressTypedDict]]
    social_links: NotRequired[List[SocialLinkTypedDict]]
    phone_numbers: NotRequired[List[PhoneNumberTypedDict]]
    emails: NotRequired[List[EmailTypedDict]]
    row_type: NotRequired[CompanyRowTypeTypedDict]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    tags: NotRequired[Nullable[List[str]]]
    read_only: NotRequired[Nullable[bool]]
    r"""Whether the company is read-only or not"""
    salutation: NotRequired[Nullable[str]]
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""
    birthday: NotRequired[Nullable[date]]
    r"""The date of birth of the person."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Company1Input(BaseModel):
    name: Nullable[str]
    r"""Name of the company"""

    owner_id: OptionalNullable[str] = UNSET
    r"""Owner ID"""

    image: OptionalNullable[str] = UNSET
    r"""The Image URL of the company"""

    description: OptionalNullable[str] = UNSET
    r"""A description of the company"""

    vat_number: OptionalNullable[str] = UNSET
    r"""The VAT number of the company"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    status: OptionalNullable[str] = UNSET
    r"""The status of the company"""

    fax: OptionalNullable[str] = UNSET
    r"""The fax number of the company"""

    annual_revenue: OptionalNullable[str] = UNSET
    r"""The annual revenue of the company"""

    number_of_employees: OptionalNullable[str] = UNSET
    r"""Number of employees"""

    industry: OptionalNullable[str] = UNSET
    r"""The industry represents the type of business the company is in."""

    ownership: OptionalNullable[str] = UNSET
    r"""The ownership indicates the type of ownership of the company."""

    sales_tax_number: OptionalNullable[str] = UNSET
    r"""A sales tax number is a unique number that identifies a company for tax purposes."""

    payee_number: OptionalNullable[str] = UNSET
    r"""A payee number is a unique number that identifies a payee for tax purposes."""

    abn_or_tfn: OptionalNullable[str] = UNSET
    r"""An ABN is necessary for operating a business, while a TFN (Tax File Number) is required for any person working in Australia."""

    abn_branch: OptionalNullable[str] = UNSET
    r"""An ABN Branch (also known as a GST Branch) is used if part of your business needs to account for GST separately from its parent entity."""

    acn: OptionalNullable[str] = UNSET
    r"""The Australian Company Number (ACN) is a nine digit number with the last digit being a check digit calculated using a modified modulus 10 calculation. ASIC has adopted a convention of always printing and displaying the ACN in the format XXX XXX XXX; three blocks of three characters, each block separated by a blank."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    bank_accounts: Optional[List[BankAccount1]] = None

    websites: Optional[List[Website]] = None

    addresses: Optional[List[Address]] = None

    social_links: Optional[List[SocialLink]] = None

    phone_numbers: Optional[List[PhoneNumber]] = None

    emails: Optional[List[Email]] = None

    row_type: Optional[CompanyRowType] = None

    custom_fields: Optional[List[CustomField]] = None

    tags: OptionalNullable[List[str]] = UNSET

    read_only: OptionalNullable[bool] = UNSET
    r"""Whether the company is read-only or not"""

    salutation: OptionalNullable[str] = UNSET
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""

    birthday: OptionalNullable[date] = UNSET
    r"""The date of birth of the person."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "owner_id",
            "image",
            "description",
            "vat_number",
            "currency",
            "status",
            "fax",
            "annual_revenue",
            "number_of_employees",
            "industry",
            "ownership",
            "sales_tax_number",
            "payee_number",
            "abn_or_tfn",
            "abn_branch",
            "acn",
            "first_name",
            "last_name",
            "bank_accounts",
            "websites",
            "addresses",
            "social_links",
            "phone_numbers",
            "emails",
            "row_type",
            "custom_fields",
            "tags",
            "read_only",
            "salutation",
            "birthday",
            "pass_through",
        ]
        nullable_fields = [
            "name",
            "owner_id",
            "image",
            "description",
            "vat_number",
            "currency",
            "status",
            "fax",
            "annual_revenue",
            "number_of_employees",
            "industry",
            "ownership",
            "sales_tax_number",
            "payee_number",
            "abn_or_tfn",
            "abn_branch",
            "acn",
            "first_name",
            "last_name",
            "tags",
            "read_only",
            "salutation",
            "birthday",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
