"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .getconnectorresourceresponse import (
    GetConnectorResourceResponse,
    GetConnectorResourceResponseTypedDict,
)
from .httpmetadata import HTTPMetadata, HTTPMetadataTypedDict
from .unexpectederrorresponse import (
    UnexpectedErrorResponse,
    UnexpectedErrorResponseTypedDict,
)
from .unifiedapiid import UnifiedAPIID
from apideck_unify.types import BaseModel
from apideck_unify.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ConnectorConnectorResourcesOneGlobalsTypedDict(TypedDict):
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""


class ConnectorConnectorResourcesOneGlobals(BaseModel):
    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""


class ConnectorConnectorResourcesOneRequestTypedDict(TypedDict):
    id: str
    r"""ID of the record you are acting upon."""
    resource_id: str
    r"""ID of the resource you are acting upon."""
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""
    unified_api: NotRequired[UnifiedAPIID]
    r"""Specify unified API for the connector resource. This is useful when a resource appears in multiple APIs"""


class ConnectorConnectorResourcesOneRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the record you are acting upon."""

    resource_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the resource you are acting upon."""

    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""

    unified_api: Annotated[
        Optional[UnifiedAPIID],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Specify unified API for the connector resource. This is useful when a resource appears in multiple APIs"""


class ConnectorConnectorResourcesOneResponseTypedDict(TypedDict):
    http_meta: HTTPMetadataTypedDict
    get_connector_resource_response: NotRequired[GetConnectorResourceResponseTypedDict]
    r"""ConnectorResources"""
    unexpected_error_response: NotRequired[UnexpectedErrorResponseTypedDict]
    r"""Unexpected error"""


class ConnectorConnectorResourcesOneResponse(BaseModel):
    http_meta: Annotated[Optional[HTTPMetadata], pydantic.Field(exclude=True)] = None

    get_connector_resource_response: Optional[GetConnectorResourceResponse] = None
    r"""ConnectorResources"""

    unexpected_error_response: Optional[UnexpectedErrorResponse] = None
    r"""Unexpected error"""
