"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ecommercediscount import EcommerceDiscount, EcommerceDiscountTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class OptionsTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for the option."""
    name: NotRequired[Nullable[str]]
    r"""The name of the option."""
    value: NotRequired[Nullable[str]]
    r"""The value of the option."""


class Options(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for the option."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the option."""

    value: OptionalNullable[str] = UNSET
    r"""The value of the option."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "name", "value"]
        nullable_fields = ["id", "name", "value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EcommerceOrderLineItemTypedDict(TypedDict):
    r"""A single line item of an ecommerce order, representing a product or variant with associated options, quantity, and pricing information."""

    name: Nullable[str]
    r"""The name of the product or variant associated with the line item."""
    quantity: Nullable[str]
    r"""The quantity of the product or variant associated with the line item."""
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    product_id: NotRequired[Nullable[str]]
    r"""A unique identifier for the product associated with the line item."""
    variant_id: NotRequired[Nullable[str]]
    r"""A unique identifier for the variant of the product associated with the line item, if applicable."""
    sku: NotRequired[Nullable[str]]
    r"""The SKU of the product or variant associated with the line item."""
    description: NotRequired[Nullable[str]]
    r"""The description of the product or variant associated with the line item."""
    options: NotRequired[List[OptionsTypedDict]]
    unit_price: NotRequired[Nullable[str]]
    r"""The unit price of the product or variant associated with the line item."""
    tax_rate: NotRequired[Nullable[str]]
    r"""The tax rate applied to the product or variant associated with the line item."""
    tax_amount: NotRequired[Nullable[str]]
    r"""The total tax amount applied to the product or variant associated with the line item."""
    is_refunded: NotRequired[Nullable[bool]]
    r"""Whether the line item has been refunded."""
    refunded_amount: NotRequired[Nullable[str]]
    r"""The amount of the line item that has been refunded."""
    refunded_quantity: NotRequired[Nullable[str]]
    r"""The quantity of the line item that has been refunded."""
    sub_total: NotRequired[Nullable[str]]
    r"""The sub total for the product(s) or variant associated with the line item, excluding taxes and discounts."""
    total_amount: NotRequired[Nullable[str]]
    r"""The total amount for the product(s) or variant associated with the line item, including taxes and discounts."""
    discounts: NotRequired[List[EcommerceDiscountTypedDict]]


class EcommerceOrderLineItem(BaseModel):
    r"""A single line item of an ecommerce order, representing a product or variant with associated options, quantity, and pricing information."""

    name: Nullable[str]
    r"""The name of the product or variant associated with the line item."""

    quantity: Nullable[str]
    r"""The quantity of the product or variant associated with the line item."""

    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    product_id: OptionalNullable[str] = UNSET
    r"""A unique identifier for the product associated with the line item."""

    variant_id: OptionalNullable[str] = UNSET
    r"""A unique identifier for the variant of the product associated with the line item, if applicable."""

    sku: OptionalNullable[str] = UNSET
    r"""The SKU of the product or variant associated with the line item."""

    description: OptionalNullable[str] = UNSET
    r"""The description of the product or variant associated with the line item."""

    options: Optional[List[Options]] = None

    unit_price: OptionalNullable[str] = UNSET
    r"""The unit price of the product or variant associated with the line item."""

    tax_rate: OptionalNullable[str] = UNSET
    r"""The tax rate applied to the product or variant associated with the line item."""

    tax_amount: OptionalNullable[str] = UNSET
    r"""The total tax amount applied to the product or variant associated with the line item."""

    is_refunded: OptionalNullable[bool] = UNSET
    r"""Whether the line item has been refunded."""

    refunded_amount: OptionalNullable[str] = UNSET
    r"""The amount of the line item that has been refunded."""

    refunded_quantity: OptionalNullable[str] = UNSET
    r"""The quantity of the line item that has been refunded."""

    sub_total: OptionalNullable[str] = UNSET
    r"""The sub total for the product(s) or variant associated with the line item, excluding taxes and discounts."""

    total_amount: OptionalNullable[str] = UNSET
    r"""The total amount for the product(s) or variant associated with the line item, including taxes and discounts."""

    discounts: Optional[List[EcommerceDiscount]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "product_id",
            "variant_id",
            "sku",
            "description",
            "options",
            "unit_price",
            "tax_rate",
            "tax_amount",
            "is_refunded",
            "refunded_amount",
            "refunded_quantity",
            "sub_total",
            "total_amount",
            "discounts",
        ]
        nullable_fields = [
            "id",
            "product_id",
            "variant_id",
            "sku",
            "name",
            "description",
            "quantity",
            "unit_price",
            "tax_rate",
            "tax_amount",
            "is_refunded",
            "refunded_amount",
            "refunded_quantity",
            "sub_total",
            "total_amount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
