"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class EcommerceStoreTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    name: NotRequired[Nullable[str]]
    r"""The store's name"""
    store_url: NotRequired[Nullable[str]]
    r"""The store's website URL"""
    admin_url: NotRequired[Nullable[str]]
    r"""The store's admin login URL"""
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""


class EcommerceStore(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    name: OptionalNullable[str] = UNSET
    r"""The store's name"""

    store_url: OptionalNullable[str] = UNSET
    r"""The store's website URL"""

    admin_url: OptionalNullable[str] = UNSET
    r"""The store's admin login URL"""

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "store_url",
            "admin_url",
            "custom_mappings",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "name",
            "store_url",
            "admin_url",
            "custom_mappings",
            "created_at",
            "updated_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
