"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .bankaccount import BankAccount, BankAccountTypedDict
from .customfield import CustomField, CustomFieldTypedDict
from .email import Email, EmailTypedDict
from .employeecompensation import (
    EmployeeCompensation,
    EmployeeCompensationInput,
    EmployeeCompensationInputTypedDict,
    EmployeeCompensationTypedDict,
)
from .employeejob import (
    EmployeeJob,
    EmployeeJobInput,
    EmployeeJobInputTypedDict,
    EmployeeJobTypedDict,
)
from .employmentstatus import EmploymentStatus
from .gender import Gender
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from .person import Person, PersonTypedDict
from .person_input import PersonInput, PersonInputTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .sociallink import SocialLink, SocialLinkTypedDict
from .team import Team, TeamTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import date, datetime
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class LeavingReason(str, Enum):
    r"""The reason because the employment ended."""

    DISMISSED = "dismissed"
    RESIGNED = "resigned"
    REDUNDANCY = "redundancy"
    OTHER = "other"


class EmploymentType(str, Enum):
    r"""The type of employment relationship the employee has with the organization."""

    CONTRACTOR = "contractor"
    EMPLOYEE = "employee"
    FREELANCE = "freelance"
    TEMP = "temp"
    INTERNSHIP = "internship"
    OTHER = "other"


class EmploymentSubType(str, Enum):
    r"""The work schedule of the employee."""

    FULL_TIME = "full_time"
    PART_TIME = "part_time"
    HOURLY = "hourly"
    OTHER = "other"
    NOT_SPECIFIED = "not_specified"


class EmploymentRoleTypedDict(TypedDict):
    type: NotRequired[Nullable[EmploymentType]]
    r"""The type of employment relationship the employee has with the organization."""
    sub_type: NotRequired[Nullable[EmploymentSubType]]
    r"""The work schedule of the employee."""


class EmploymentRole(BaseModel):
    type: OptionalNullable[EmploymentType] = UNSET
    r"""The type of employment relationship the employee has with the organization."""

    sub_type: OptionalNullable[EmploymentSubType] = UNSET
    r"""The work schedule of the employee."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "sub_type"]
        nullable_fields = ["type", "sub_type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ManagerTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    name: NotRequired[Nullable[str]]
    r"""The name of the manager, often a combination of their first and last names."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    email: NotRequired[Nullable[str]]
    r"""The email address of the manager."""
    employment_status: NotRequired[Nullable[EmploymentStatus]]
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""


class Manager(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the manager, often a combination of their first and last names."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    email: OptionalNullable[str] = UNSET
    r"""The email address of the manager."""

    employment_status: OptionalNullable[EmploymentStatus] = UNSET
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "first_name",
            "last_name",
            "email",
            "employment_status",
        ]
        nullable_fields = [
            "id",
            "name",
            "first_name",
            "last_name",
            "email",
            "employment_status",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ProbationPeriodTypedDict(TypedDict):
    start_date: NotRequired[Nullable[date]]
    r"""The date that the employee started their probation period at the company."""
    end_date: NotRequired[Nullable[date]]
    r"""The date that the employee ended their probation period at the company."""


class ProbationPeriod(BaseModel):
    start_date: OptionalNullable[date] = UNSET
    r"""The date that the employee started their probation period at the company."""

    end_date: OptionalNullable[date] = UNSET
    r"""The date that the employee ended their probation period at the company."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["start_date", "end_date"]
        nullable_fields = ["start_date", "end_date"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    middle_name: NotRequired[Nullable[str]]
    r"""Middle name of the person."""
    display_name: NotRequired[Nullable[str]]
    r"""The name used to display the employee, often a combination of their first and last names."""
    preferred_name: NotRequired[Nullable[str]]
    r"""The name the employee prefers to be addressed by, which may be different from their legal name."""
    initials: NotRequired[Nullable[str]]
    r"""The initials of the person, usually derived from their first, middle, and last names."""
    salutation: NotRequired[Nullable[str]]
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""
    title: NotRequired[Nullable[str]]
    r"""The job title of the person."""
    marital_status: NotRequired[Nullable[str]]
    r"""The marital status of the employee."""
    partner: NotRequired[PersonTypedDict]
    division: NotRequired[Nullable[str]]
    r"""The division the person is currently in. Usually a collection of departments or teams or regions."""
    division_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the division this employee belongs to."""
    department: NotRequired[Nullable[str]]
    r"""The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field."""
    department_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the department ID this employee belongs to."""
    department_name: NotRequired[Nullable[str]]
    r"""Name of the department this employee belongs to."""
    team: NotRequired[Nullable[TeamTypedDict]]
    r"""The team the person is currently in."""
    company_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the company."""
    company_name: NotRequired[Nullable[str]]
    r"""The name of the company."""
    employment_start_date: NotRequired[Nullable[str]]
    r"""A Start Date is the date that the employee started working at the company"""
    employment_end_date: NotRequired[Nullable[str]]
    r"""An End Date is the date that the employee ended working at the company"""
    leaving_reason: NotRequired[Nullable[LeavingReason]]
    r"""The reason because the employment ended."""
    employee_number: NotRequired[Nullable[str]]
    r"""An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company."""
    employment_status: NotRequired[Nullable[EmploymentStatus]]
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""
    employment_role: NotRequired[EmploymentRoleTypedDict]
    ethnicity: NotRequired[Nullable[str]]
    r"""The ethnicity of the employee"""
    manager: NotRequired[ManagerTypedDict]
    direct_reports: NotRequired[Nullable[List[str]]]
    r"""Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee."""
    social_security_number: NotRequired[Nullable[str]]
    r"""A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions."""
    birthday: NotRequired[Nullable[date]]
    r"""The date of birth of the person."""
    deceased_on: NotRequired[Nullable[date]]
    r"""The date the person deceased."""
    country_of_birth: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    description: NotRequired[Nullable[str]]
    r"""A description of the object."""
    gender: NotRequired[Nullable[Gender]]
    r"""The gender represents the gender identity of a person."""
    pronouns: NotRequired[Nullable[str]]
    r"""The preferred pronouns of the person."""
    preferred_language: NotRequired[Nullable[str]]
    r"""language code according to ISO 639-1. For the United States - EN"""
    languages: NotRequired[List[Nullable[str]]]
    nationalities: NotRequired[List[Nullable[str]]]
    photo_url: NotRequired[Nullable[str]]
    r"""The URL of the photo of a person."""
    timezone: NotRequired[Nullable[str]]
    r"""The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London."""
    source: NotRequired[Nullable[str]]
    r"""When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from."""
    source_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS)."""
    record_url: NotRequired[Nullable[str]]
    jobs: NotRequired[Nullable[List[EmployeeJobTypedDict]]]
    compensations: NotRequired[Nullable[List[EmployeeCompensationTypedDict]]]
    works_remote: NotRequired[Nullable[bool]]
    r"""Indicates if the employee works from a remote location."""
    addresses: NotRequired[List[AddressTypedDict]]
    phone_numbers: NotRequired[List[PhoneNumberTypedDict]]
    emails: NotRequired[List[EmailTypedDict]]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    social_links: NotRequired[List[SocialLinkTypedDict]]
    bank_accounts: NotRequired[List[BankAccountTypedDict]]
    tax_code: NotRequired[Nullable[str]]
    tax_id: NotRequired[Nullable[str]]
    dietary_preference: NotRequired[Nullable[str]]
    r"""Indicate the employee's dietary preference."""
    food_allergies: NotRequired[Nullable[List[str]]]
    r"""Indicate the employee's food allergies."""
    probation_period: NotRequired[ProbationPeriodTypedDict]
    tags: NotRequired[Nullable[List[str]]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    deleted: NotRequired[Nullable[bool]]
    r"""Flag to indicate if the object is deleted."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Employee(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    middle_name: OptionalNullable[str] = UNSET
    r"""Middle name of the person."""

    display_name: OptionalNullable[str] = UNSET
    r"""The name used to display the employee, often a combination of their first and last names."""

    preferred_name: OptionalNullable[str] = UNSET
    r"""The name the employee prefers to be addressed by, which may be different from their legal name."""

    initials: OptionalNullable[str] = UNSET
    r"""The initials of the person, usually derived from their first, middle, and last names."""

    salutation: OptionalNullable[str] = UNSET
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""

    title: OptionalNullable[str] = UNSET
    r"""The job title of the person."""

    marital_status: OptionalNullable[str] = UNSET
    r"""The marital status of the employee."""

    partner: Optional[Person] = None

    division: OptionalNullable[str] = UNSET
    r"""The division the person is currently in. Usually a collection of departments or teams or regions."""

    division_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the division this employee belongs to."""

    department: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field."""

    department_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the department ID this employee belongs to."""

    department_name: OptionalNullable[str] = UNSET
    r"""Name of the department this employee belongs to."""

    team: OptionalNullable[Team] = UNSET
    r"""The team the person is currently in."""

    company_id: OptionalNullable[str] = UNSET
    r"""The unique identifier of the company."""

    company_name: OptionalNullable[str] = UNSET
    r"""The name of the company."""

    employment_start_date: OptionalNullable[str] = UNSET
    r"""A Start Date is the date that the employee started working at the company"""

    employment_end_date: OptionalNullable[str] = UNSET
    r"""An End Date is the date that the employee ended working at the company"""

    leaving_reason: OptionalNullable[LeavingReason] = UNSET
    r"""The reason because the employment ended."""

    employee_number: OptionalNullable[str] = UNSET
    r"""An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company."""

    employment_status: OptionalNullable[EmploymentStatus] = UNSET
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""

    employment_role: Optional[EmploymentRole] = None

    ethnicity: OptionalNullable[str] = UNSET
    r"""The ethnicity of the employee"""

    manager: Optional[Manager] = None

    direct_reports: OptionalNullable[List[str]] = UNSET
    r"""Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee."""

    social_security_number: OptionalNullable[str] = UNSET
    r"""A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions."""

    birthday: OptionalNullable[date] = UNSET
    r"""The date of birth of the person."""

    deceased_on: OptionalNullable[date] = UNSET
    r"""The date the person deceased."""

    country_of_birth: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    description: OptionalNullable[str] = UNSET
    r"""A description of the object."""

    gender: OptionalNullable[Gender] = UNSET
    r"""The gender represents the gender identity of a person."""

    pronouns: OptionalNullable[str] = UNSET
    r"""The preferred pronouns of the person."""

    preferred_language: OptionalNullable[str] = UNSET
    r"""language code according to ISO 639-1. For the United States - EN"""

    languages: Optional[List[Nullable[str]]] = None

    nationalities: Optional[List[Nullable[str]]] = None

    photo_url: OptionalNullable[str] = UNSET
    r"""The URL of the photo of a person."""

    timezone: OptionalNullable[str] = UNSET
    r"""The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London."""

    source: OptionalNullable[str] = UNSET
    r"""When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from."""

    source_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS)."""

    record_url: OptionalNullable[str] = UNSET

    jobs: OptionalNullable[List[EmployeeJob]] = UNSET

    compensations: OptionalNullable[List[EmployeeCompensation]] = UNSET

    works_remote: OptionalNullable[bool] = UNSET
    r"""Indicates if the employee works from a remote location."""

    addresses: Optional[List[Address]] = None

    phone_numbers: Optional[List[PhoneNumber]] = None

    emails: Optional[List[Email]] = None

    custom_fields: Optional[List[CustomField]] = None

    social_links: Optional[List[SocialLink]] = None

    bank_accounts: Optional[List[BankAccount]] = None

    tax_code: OptionalNullable[str] = UNSET

    tax_id: OptionalNullable[str] = UNSET

    dietary_preference: OptionalNullable[str] = UNSET
    r"""Indicate the employee's dietary preference."""

    food_allergies: OptionalNullable[List[str]] = UNSET
    r"""Indicate the employee's food allergies."""

    probation_period: Optional[ProbationPeriod] = None

    tags: OptionalNullable[List[str]] = UNSET

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    deleted: OptionalNullable[bool] = UNSET
    r"""Flag to indicate if the object is deleted."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "downstream_id",
            "first_name",
            "last_name",
            "middle_name",
            "display_name",
            "preferred_name",
            "initials",
            "salutation",
            "title",
            "marital_status",
            "partner",
            "division",
            "division_id",
            "department",
            "department_id",
            "department_name",
            "team",
            "company_id",
            "company_name",
            "employment_start_date",
            "employment_end_date",
            "leaving_reason",
            "employee_number",
            "employment_status",
            "employment_role",
            "ethnicity",
            "manager",
            "direct_reports",
            "social_security_number",
            "birthday",
            "deceased_on",
            "country_of_birth",
            "description",
            "gender",
            "pronouns",
            "preferred_language",
            "languages",
            "nationalities",
            "photo_url",
            "timezone",
            "source",
            "source_id",
            "record_url",
            "jobs",
            "compensations",
            "works_remote",
            "addresses",
            "phone_numbers",
            "emails",
            "custom_fields",
            "social_links",
            "bank_accounts",
            "tax_code",
            "tax_id",
            "dietary_preference",
            "food_allergies",
            "probation_period",
            "tags",
            "custom_mappings",
            "row_version",
            "deleted",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "id",
            "downstream_id",
            "first_name",
            "last_name",
            "middle_name",
            "display_name",
            "preferred_name",
            "initials",
            "salutation",
            "title",
            "marital_status",
            "division",
            "division_id",
            "department",
            "department_id",
            "department_name",
            "team",
            "company_id",
            "company_name",
            "employment_start_date",
            "employment_end_date",
            "leaving_reason",
            "employee_number",
            "employment_status",
            "ethnicity",
            "direct_reports",
            "social_security_number",
            "birthday",
            "deceased_on",
            "country_of_birth",
            "description",
            "gender",
            "pronouns",
            "preferred_language",
            "photo_url",
            "timezone",
            "source",
            "source_id",
            "record_url",
            "jobs",
            "compensations",
            "works_remote",
            "tax_code",
            "tax_id",
            "dietary_preference",
            "food_allergies",
            "tags",
            "custom_mappings",
            "row_version",
            "deleted",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeInputTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    middle_name: NotRequired[Nullable[str]]
    r"""Middle name of the person."""
    display_name: NotRequired[Nullable[str]]
    r"""The name used to display the employee, often a combination of their first and last names."""
    preferred_name: NotRequired[Nullable[str]]
    r"""The name the employee prefers to be addressed by, which may be different from their legal name."""
    initials: NotRequired[Nullable[str]]
    r"""The initials of the person, usually derived from their first, middle, and last names."""
    salutation: NotRequired[Nullable[str]]
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""
    title: NotRequired[Nullable[str]]
    r"""The job title of the person."""
    marital_status: NotRequired[Nullable[str]]
    r"""The marital status of the employee."""
    partner: NotRequired[PersonInputTypedDict]
    division: NotRequired[Nullable[str]]
    r"""The division the person is currently in. Usually a collection of departments or teams or regions."""
    division_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the division this employee belongs to."""
    department: NotRequired[Nullable[str]]
    r"""The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field."""
    department_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the department ID this employee belongs to."""
    department_name: NotRequired[Nullable[str]]
    r"""Name of the department this employee belongs to."""
    team: NotRequired[Nullable[TeamTypedDict]]
    r"""The team the person is currently in."""
    company_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the company."""
    company_name: NotRequired[Nullable[str]]
    r"""The name of the company."""
    employment_start_date: NotRequired[Nullable[str]]
    r"""A Start Date is the date that the employee started working at the company"""
    employment_end_date: NotRequired[Nullable[str]]
    r"""An End Date is the date that the employee ended working at the company"""
    leaving_reason: NotRequired[Nullable[LeavingReason]]
    r"""The reason because the employment ended."""
    employee_number: NotRequired[Nullable[str]]
    r"""An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company."""
    employment_status: NotRequired[Nullable[EmploymentStatus]]
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""
    employment_role: NotRequired[EmploymentRoleTypedDict]
    ethnicity: NotRequired[Nullable[str]]
    r"""The ethnicity of the employee"""
    manager: NotRequired[ManagerTypedDict]
    direct_reports: NotRequired[Nullable[List[str]]]
    r"""Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee."""
    social_security_number: NotRequired[Nullable[str]]
    r"""A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions."""
    birthday: NotRequired[Nullable[date]]
    r"""The date of birth of the person."""
    deceased_on: NotRequired[Nullable[date]]
    r"""The date the person deceased."""
    country_of_birth: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    description: NotRequired[Nullable[str]]
    r"""A description of the object."""
    gender: NotRequired[Nullable[Gender]]
    r"""The gender represents the gender identity of a person."""
    pronouns: NotRequired[Nullable[str]]
    r"""The preferred pronouns of the person."""
    preferred_language: NotRequired[Nullable[str]]
    r"""language code according to ISO 639-1. For the United States - EN"""
    languages: NotRequired[List[Nullable[str]]]
    nationalities: NotRequired[List[Nullable[str]]]
    photo_url: NotRequired[Nullable[str]]
    r"""The URL of the photo of a person."""
    timezone: NotRequired[Nullable[str]]
    r"""The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London."""
    source: NotRequired[Nullable[str]]
    r"""When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from."""
    source_id: NotRequired[Nullable[str]]
    r"""Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS)."""
    record_url: NotRequired[Nullable[str]]
    jobs: NotRequired[Nullable[List[EmployeeJobInputTypedDict]]]
    compensations: NotRequired[Nullable[List[EmployeeCompensationInputTypedDict]]]
    works_remote: NotRequired[Nullable[bool]]
    r"""Indicates if the employee works from a remote location."""
    addresses: NotRequired[List[AddressTypedDict]]
    phone_numbers: NotRequired[List[PhoneNumberTypedDict]]
    emails: NotRequired[List[EmailTypedDict]]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    social_links: NotRequired[List[SocialLinkTypedDict]]
    bank_accounts: NotRequired[List[BankAccountTypedDict]]
    tax_code: NotRequired[Nullable[str]]
    tax_id: NotRequired[Nullable[str]]
    dietary_preference: NotRequired[Nullable[str]]
    r"""Indicate the employee's dietary preference."""
    food_allergies: NotRequired[Nullable[List[str]]]
    r"""Indicate the employee's food allergies."""
    probation_period: NotRequired[ProbationPeriodTypedDict]
    tags: NotRequired[Nullable[List[str]]]
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    deleted: NotRequired[Nullable[bool]]
    r"""Flag to indicate if the object is deleted."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class EmployeeInput(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    middle_name: OptionalNullable[str] = UNSET
    r"""Middle name of the person."""

    display_name: OptionalNullable[str] = UNSET
    r"""The name used to display the employee, often a combination of their first and last names."""

    preferred_name: OptionalNullable[str] = UNSET
    r"""The name the employee prefers to be addressed by, which may be different from their legal name."""

    initials: OptionalNullable[str] = UNSET
    r"""The initials of the person, usually derived from their first, middle, and last names."""

    salutation: OptionalNullable[str] = UNSET
    r"""A formal salutation for the person. For example, 'Mr', 'Mrs'"""

    title: OptionalNullable[str] = UNSET
    r"""The job title of the person."""

    marital_status: OptionalNullable[str] = UNSET
    r"""The marital status of the employee."""

    partner: Optional[PersonInput] = None

    division: OptionalNullable[str] = UNSET
    r"""The division the person is currently in. Usually a collection of departments or teams or regions."""

    division_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the division this employee belongs to."""

    department: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""The department the person is currently in. [Deprecated](https://developers.apideck.com/changelog) in favor of the dedicated department_id and department_name field."""

    department_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the department ID this employee belongs to."""

    department_name: OptionalNullable[str] = UNSET
    r"""Name of the department this employee belongs to."""

    team: OptionalNullable[Team] = UNSET
    r"""The team the person is currently in."""

    company_id: OptionalNullable[str] = UNSET
    r"""The unique identifier of the company."""

    company_name: OptionalNullable[str] = UNSET
    r"""The name of the company."""

    employment_start_date: OptionalNullable[str] = UNSET
    r"""A Start Date is the date that the employee started working at the company"""

    employment_end_date: OptionalNullable[str] = UNSET
    r"""An End Date is the date that the employee ended working at the company"""

    leaving_reason: OptionalNullable[LeavingReason] = UNSET
    r"""The reason because the employment ended."""

    employee_number: OptionalNullable[str] = UNSET
    r"""An Employee Number, Employee ID or Employee Code, is a unique number that has been assigned to each individual staff member within a company."""

    employment_status: OptionalNullable[EmploymentStatus] = UNSET
    r"""The employment status of the employee, indicating whether they are currently employed, inactive, terminated, or in another status."""

    employment_role: Optional[EmploymentRole] = None

    ethnicity: OptionalNullable[str] = UNSET
    r"""The ethnicity of the employee"""

    manager: Optional[Manager] = None

    direct_reports: OptionalNullable[List[str]] = UNSET
    r"""Direct reports is an array of ids that reflect the individuals in an organizational hierarchy who are directly supervised by this specific employee."""

    social_security_number: OptionalNullable[str] = UNSET
    r"""A unique identifier assigned by the government. This field is considered sensitive information and may be subject to special security and privacy restrictions."""

    birthday: OptionalNullable[date] = UNSET
    r"""The date of birth of the person."""

    deceased_on: OptionalNullable[date] = UNSET
    r"""The date the person deceased."""

    country_of_birth: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    description: OptionalNullable[str] = UNSET
    r"""A description of the object."""

    gender: OptionalNullable[Gender] = UNSET
    r"""The gender represents the gender identity of a person."""

    pronouns: OptionalNullable[str] = UNSET
    r"""The preferred pronouns of the person."""

    preferred_language: OptionalNullable[str] = UNSET
    r"""language code according to ISO 639-1. For the United States - EN"""

    languages: Optional[List[Nullable[str]]] = None

    nationalities: Optional[List[Nullable[str]]] = None

    photo_url: OptionalNullable[str] = UNSET
    r"""The URL of the photo of a person."""

    timezone: OptionalNullable[str] = UNSET
    r"""The time zone related to the resource. The value is a string containing a standard time zone identifier, e.g. Europe/London."""

    source: OptionalNullable[str] = UNSET
    r"""When the employee is imported as a new hire, this field indicates what system (e.g. the name of the ATS) this employee was imported from."""

    source_id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the employee in the system this employee was imported from (e.g. the ID in the ATS)."""

    record_url: OptionalNullable[str] = UNSET

    jobs: OptionalNullable[List[EmployeeJobInput]] = UNSET

    compensations: OptionalNullable[List[EmployeeCompensationInput]] = UNSET

    works_remote: OptionalNullable[bool] = UNSET
    r"""Indicates if the employee works from a remote location."""

    addresses: Optional[List[Address]] = None

    phone_numbers: Optional[List[PhoneNumber]] = None

    emails: Optional[List[Email]] = None

    custom_fields: Optional[List[CustomField]] = None

    social_links: Optional[List[SocialLink]] = None

    bank_accounts: Optional[List[BankAccount]] = None

    tax_code: OptionalNullable[str] = UNSET

    tax_id: OptionalNullable[str] = UNSET

    dietary_preference: OptionalNullable[str] = UNSET
    r"""Indicate the employee's dietary preference."""

    food_allergies: OptionalNullable[List[str]] = UNSET
    r"""Indicate the employee's food allergies."""

    probation_period: Optional[ProbationPeriod] = None

    tags: OptionalNullable[List[str]] = UNSET

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    deleted: OptionalNullable[bool] = UNSET
    r"""Flag to indicate if the object is deleted."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "first_name",
            "last_name",
            "middle_name",
            "display_name",
            "preferred_name",
            "initials",
            "salutation",
            "title",
            "marital_status",
            "partner",
            "division",
            "division_id",
            "department",
            "department_id",
            "department_name",
            "team",
            "company_id",
            "company_name",
            "employment_start_date",
            "employment_end_date",
            "leaving_reason",
            "employee_number",
            "employment_status",
            "employment_role",
            "ethnicity",
            "manager",
            "direct_reports",
            "social_security_number",
            "birthday",
            "deceased_on",
            "country_of_birth",
            "description",
            "gender",
            "pronouns",
            "preferred_language",
            "languages",
            "nationalities",
            "photo_url",
            "timezone",
            "source",
            "source_id",
            "record_url",
            "jobs",
            "compensations",
            "works_remote",
            "addresses",
            "phone_numbers",
            "emails",
            "custom_fields",
            "social_links",
            "bank_accounts",
            "tax_code",
            "tax_id",
            "dietary_preference",
            "food_allergies",
            "probation_period",
            "tags",
            "row_version",
            "deleted",
            "pass_through",
        ]
        nullable_fields = [
            "id",
            "first_name",
            "last_name",
            "middle_name",
            "display_name",
            "preferred_name",
            "initials",
            "salutation",
            "title",
            "marital_status",
            "division",
            "division_id",
            "department",
            "department_id",
            "department_name",
            "team",
            "company_id",
            "company_name",
            "employment_start_date",
            "employment_end_date",
            "leaving_reason",
            "employee_number",
            "employment_status",
            "ethnicity",
            "direct_reports",
            "social_security_number",
            "birthday",
            "deceased_on",
            "country_of_birth",
            "description",
            "gender",
            "pronouns",
            "preferred_language",
            "photo_url",
            "timezone",
            "source",
            "source_id",
            "record_url",
            "jobs",
            "compensations",
            "works_remote",
            "tax_code",
            "tax_id",
            "dietary_preference",
            "food_allergies",
            "tags",
            "row_version",
            "deleted",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
