"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from .expenselineitem import ExpenseLineItem, ExpenseLineItemTypedDict
from .expenselineitem_input import ExpenseLineItemInput, ExpenseLineItemInputTypedDict
from .linkedtaxrate import LinkedTaxRate, LinkedTaxRateTypedDict
from .linkedtaxrate_input import LinkedTaxRateInput, LinkedTaxRateInputTypedDict
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class ExpensePaymentType(str, Enum):
    r"""The type of payment for the expense."""

    CASH = "cash"
    CHECK = "check"
    CREDIT_CARD = "credit_card"


class ExpenseType(str, Enum):
    r"""The type of expense."""

    EXPENSE = "expense"
    REFUND = "refund"


class ExpenseStatus(str, Enum):
    r"""Expense status"""

    DRAFT = "draft"
    POSTED = "posted"


class ExpenseTypedDict(TypedDict):
    transaction_date: Nullable[datetime]
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""
    account_id: str
    r"""The unique identifier for the ledger account that this expense should be credited to."""
    line_items: List[ExpenseLineItemTypedDict]
    r"""Expense line items linked to this expense."""
    id: NotRequired[str]
    r"""A unique identifier for an object."""
    number: NotRequired[Nullable[str]]
    r"""Number."""
    customer_id: NotRequired[str]
    r"""The ID of the customer this entity is linked to. Used for expenses that should be marked as billable to customers."""
    supplier_id: NotRequired[str]
    r"""The ID of the supplier this entity is linked to."""
    company_id: NotRequired[Nullable[str]]
    r"""The company ID the transaction belongs to"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    payment_type: NotRequired[Nullable[ExpensePaymentType]]
    r"""The type of payment for the expense."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    currency_rate: NotRequired[Nullable[float]]
    r"""Currency Exchange Rate at the time entity was recorded/generated."""
    type: NotRequired[Nullable[ExpenseType]]
    r"""The type of expense."""
    memo: NotRequired[Nullable[str]]
    r"""The memo of the expense."""
    tax_rate: NotRequired[LinkedTaxRateTypedDict]
    total_amount: NotRequired[Nullable[float]]
    r"""The total amount of the expense line item."""
    reference: NotRequired[Nullable[str]]
    r"""Optional reference identifier for the transaction."""
    source_document_url: NotRequired[Nullable[str]]
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app. Currently only supported for Xero."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    status: NotRequired[Nullable[ExpenseStatus]]
    r"""Expense status"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Expense(BaseModel):
    transaction_date: Nullable[datetime]
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""

    account_id: str
    r"""The unique identifier for the ledger account that this expense should be credited to."""

    line_items: List[ExpenseLineItem]
    r"""Expense line items linked to this expense."""

    id: Optional[str] = None
    r"""A unique identifier for an object."""

    number: OptionalNullable[str] = UNSET
    r"""Number."""

    customer_id: Optional[str] = None
    r"""The ID of the customer this entity is linked to. Used for expenses that should be marked as billable to customers."""

    supplier_id: Optional[str] = None
    r"""The ID of the supplier this entity is linked to."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company ID the transaction belongs to"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    payment_type: OptionalNullable[ExpensePaymentType] = UNSET
    r"""The type of payment for the expense."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    currency_rate: OptionalNullable[float] = UNSET
    r"""Currency Exchange Rate at the time entity was recorded/generated."""

    type: OptionalNullable[ExpenseType] = UNSET
    r"""The type of expense."""

    memo: OptionalNullable[str] = UNSET
    r"""The memo of the expense."""

    tax_rate: Optional[LinkedTaxRate] = None

    total_amount: OptionalNullable[float] = UNSET
    r"""The total amount of the expense line item."""

    reference: OptionalNullable[str] = UNSET
    r"""Optional reference identifier for the transaction."""

    source_document_url: OptionalNullable[str] = UNSET
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app. Currently only supported for Xero."""

    custom_fields: Optional[List[CustomField]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    status: OptionalNullable[ExpenseStatus] = UNSET
    r"""Expense status"""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "number",
            "customer_id",
            "supplier_id",
            "company_id",
            "department_id",
            "payment_type",
            "currency",
            "currency_rate",
            "type",
            "memo",
            "tax_rate",
            "total_amount",
            "reference",
            "source_document_url",
            "custom_fields",
            "custom_mappings",
            "status",
            "updated_at",
            "created_at",
            "row_version",
            "updated_by",
            "created_by",
            "pass_through",
        ]
        nullable_fields = [
            "number",
            "transaction_date",
            "company_id",
            "department_id",
            "payment_type",
            "currency",
            "currency_rate",
            "type",
            "memo",
            "total_amount",
            "reference",
            "source_document_url",
            "custom_mappings",
            "status",
            "updated_at",
            "created_at",
            "row_version",
            "updated_by",
            "created_by",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ExpenseInputTypedDict(TypedDict):
    transaction_date: Nullable[datetime]
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""
    account_id: str
    r"""The unique identifier for the ledger account that this expense should be credited to."""
    line_items: List[ExpenseLineItemInputTypedDict]
    r"""Expense line items linked to this expense."""
    number: NotRequired[Nullable[str]]
    r"""Number."""
    customer_id: NotRequired[str]
    r"""The ID of the customer this entity is linked to. Used for expenses that should be marked as billable to customers."""
    supplier_id: NotRequired[str]
    r"""The ID of the supplier this entity is linked to."""
    company_id: NotRequired[Nullable[str]]
    r"""The company ID the transaction belongs to"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    payment_type: NotRequired[Nullable[ExpensePaymentType]]
    r"""The type of payment for the expense."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    currency_rate: NotRequired[Nullable[float]]
    r"""Currency Exchange Rate at the time entity was recorded/generated."""
    type: NotRequired[Nullable[ExpenseType]]
    r"""The type of expense."""
    memo: NotRequired[Nullable[str]]
    r"""The memo of the expense."""
    tax_rate: NotRequired[LinkedTaxRateInputTypedDict]
    total_amount: NotRequired[Nullable[float]]
    r"""The total amount of the expense line item."""
    reference: NotRequired[Nullable[str]]
    r"""Optional reference identifier for the transaction."""
    source_document_url: NotRequired[Nullable[str]]
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app. Currently only supported for Xero."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    status: NotRequired[Nullable[ExpenseStatus]]
    r"""Expense status"""
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class ExpenseInput(BaseModel):
    transaction_date: Nullable[datetime]
    r"""The date of the transaction - YYYY:MM::DDThh:mm:ss.sTZD"""

    account_id: str
    r"""The unique identifier for the ledger account that this expense should be credited to."""

    line_items: List[ExpenseLineItemInput]
    r"""Expense line items linked to this expense."""

    number: OptionalNullable[str] = UNSET
    r"""Number."""

    customer_id: Optional[str] = None
    r"""The ID of the customer this entity is linked to. Used for expenses that should be marked as billable to customers."""

    supplier_id: Optional[str] = None
    r"""The ID of the supplier this entity is linked to."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company ID the transaction belongs to"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    payment_type: OptionalNullable[ExpensePaymentType] = UNSET
    r"""The type of payment for the expense."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    currency_rate: OptionalNullable[float] = UNSET
    r"""Currency Exchange Rate at the time entity was recorded/generated."""

    type: OptionalNullable[ExpenseType] = UNSET
    r"""The type of expense."""

    memo: OptionalNullable[str] = UNSET
    r"""The memo of the expense."""

    tax_rate: Optional[LinkedTaxRateInput] = None

    total_amount: OptionalNullable[float] = UNSET
    r"""The total amount of the expense line item."""

    reference: OptionalNullable[str] = UNSET
    r"""Optional reference identifier for the transaction."""

    source_document_url: OptionalNullable[str] = UNSET
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app. Currently only supported for Xero."""

    custom_fields: Optional[List[CustomField]] = None

    status: OptionalNullable[ExpenseStatus] = UNSET
    r"""Expense status"""

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "number",
            "customer_id",
            "supplier_id",
            "company_id",
            "department_id",
            "payment_type",
            "currency",
            "currency_rate",
            "type",
            "memo",
            "tax_rate",
            "total_amount",
            "reference",
            "source_document_url",
            "custom_fields",
            "status",
            "row_version",
            "pass_through",
        ]
        nullable_fields = [
            "number",
            "transaction_date",
            "company_id",
            "department_id",
            "payment_type",
            "currency",
            "currency_rate",
            "type",
            "memo",
            "total_amount",
            "reference",
            "source_document_url",
            "status",
            "row_version",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
