"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .deprecatedlinkedtrackingcategory import (
    DeprecatedLinkedTrackingCategory,
    DeprecatedLinkedTrackingCategoryTypedDict,
)
from .linkedcustomer import LinkedCustomer, LinkedCustomerTypedDict
from .linkedcustomer_input import LinkedCustomerInput, LinkedCustomerInputTypedDict
from .linkedledgeraccount import LinkedLedgerAccount, LinkedLedgerAccountTypedDict
from .linkedledgeraccount_input import (
    LinkedLedgerAccountInput,
    LinkedLedgerAccountInputTypedDict,
)
from .linkedsupplier import LinkedSupplier, LinkedSupplierTypedDict
from .linkedsupplier_input import LinkedSupplierInput, LinkedSupplierInputTypedDict
from .linkedtaxrate import LinkedTaxRate, LinkedTaxRateTypedDict
from .linkedtaxrate_input import LinkedTaxRateInput, LinkedTaxRateInputTypedDict
from .linkedtrackingcategory import (
    LinkedTrackingCategory,
    LinkedTrackingCategoryTypedDict,
)
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class JournalEntryLineItemType(str, Enum):
    r"""Debit entries are considered positive, and credit entries are considered negative."""

    DEBIT = "debit"
    CREDIT = "credit"


class JournalEntryLineItemTypedDict(TypedDict):
    type: JournalEntryLineItemType
    r"""Debit entries are considered positive, and credit entries are considered negative."""
    ledger_account: Nullable[LinkedLedgerAccountTypedDict]
    id: NotRequired[str]
    r"""A unique identifier for an object."""
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    sub_total: NotRequired[Nullable[float]]
    r"""Sub-total amount, normally before tax."""
    total_amount: NotRequired[Nullable[float]]
    r"""Debit entries are considered positive, and credit entries are considered negative."""
    tax_rate: NotRequired[LinkedTaxRateTypedDict]
    tracking_category: NotRequired[Nullable[DeprecatedLinkedTrackingCategoryTypedDict]]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    customer: NotRequired[Nullable[LinkedCustomerTypedDict]]
    r"""The customer this entity is linked to."""
    supplier: NotRequired[Nullable[LinkedSupplierTypedDict]]
    r"""The supplier this entity is linked to."""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    location_id: NotRequired[Nullable[str]]
    r"""The ID of the location"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number of the resource"""


class JournalEntryLineItem(BaseModel):
    type: JournalEntryLineItemType
    r"""Debit entries are considered positive, and credit entries are considered negative."""

    ledger_account: Nullable[LinkedLedgerAccount]

    id: Optional[str] = None
    r"""A unique identifier for an object."""

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    sub_total: OptionalNullable[float] = UNSET
    r"""Sub-total amount, normally before tax."""

    total_amount: OptionalNullable[float] = UNSET
    r"""Debit entries are considered positive, and credit entries are considered negative."""

    tax_rate: Optional[LinkedTaxRate] = None

    tracking_category: Annotated[
        OptionalNullable[DeprecatedLinkedTrackingCategory],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    customer: OptionalNullable[LinkedCustomer] = UNSET
    r"""The customer this entity is linked to."""

    supplier: OptionalNullable[LinkedSupplier] = UNSET
    r"""The supplier this entity is linked to."""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    location_id: OptionalNullable[str] = UNSET
    r"""The ID of the location"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number of the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "description",
            "tax_amount",
            "sub_total",
            "total_amount",
            "tax_rate",
            "tracking_category",
            "tracking_categories",
            "customer",
            "supplier",
            "department_id",
            "location_id",
            "line_number",
        ]
        nullable_fields = [
            "description",
            "tax_amount",
            "sub_total",
            "total_amount",
            "tracking_category",
            "tracking_categories",
            "ledger_account",
            "customer",
            "supplier",
            "department_id",
            "location_id",
            "line_number",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class JournalEntryLineItemInputTypedDict(TypedDict):
    type: JournalEntryLineItemType
    r"""Debit entries are considered positive, and credit entries are considered negative."""
    ledger_account: Nullable[LinkedLedgerAccountInputTypedDict]
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    sub_total: NotRequired[Nullable[float]]
    r"""Sub-total amount, normally before tax."""
    total_amount: NotRequired[Nullable[float]]
    r"""Debit entries are considered positive, and credit entries are considered negative."""
    tax_rate: NotRequired[LinkedTaxRateInputTypedDict]
    tracking_category: NotRequired[Nullable[DeprecatedLinkedTrackingCategoryTypedDict]]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    customer: NotRequired[Nullable[LinkedCustomerInputTypedDict]]
    r"""The customer this entity is linked to."""
    supplier: NotRequired[Nullable[LinkedSupplierInputTypedDict]]
    r"""The supplier this entity is linked to."""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    location_id: NotRequired[Nullable[str]]
    r"""The ID of the location"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number of the resource"""


class JournalEntryLineItemInput(BaseModel):
    type: JournalEntryLineItemType
    r"""Debit entries are considered positive, and credit entries are considered negative."""

    ledger_account: Nullable[LinkedLedgerAccountInput]

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    sub_total: OptionalNullable[float] = UNSET
    r"""Sub-total amount, normally before tax."""

    total_amount: OptionalNullable[float] = UNSET
    r"""Debit entries are considered positive, and credit entries are considered negative."""

    tax_rate: Optional[LinkedTaxRateInput] = None

    tracking_category: Annotated[
        OptionalNullable[DeprecatedLinkedTrackingCategory],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    customer: OptionalNullable[LinkedCustomerInput] = UNSET
    r"""The customer this entity is linked to."""

    supplier: OptionalNullable[LinkedSupplierInput] = UNSET
    r"""The supplier this entity is linked to."""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    location_id: OptionalNullable[str] = UNSET
    r"""The ID of the location"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number of the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "tax_amount",
            "sub_total",
            "total_amount",
            "tax_rate",
            "tracking_category",
            "tracking_categories",
            "customer",
            "supplier",
            "department_id",
            "location_id",
            "line_number",
        ]
        nullable_fields = [
            "description",
            "tax_amount",
            "sub_total",
            "total_amount",
            "tracking_category",
            "tracking_categories",
            "ledger_account",
            "customer",
            "supplier",
            "department_id",
            "location_id",
            "line_number",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
