"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .email import Email, EmailTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class LinkedEcommerceCustomerTypedDict(TypedDict):
    r"""The customer this entity is linked to."""

    id: NotRequired[Nullable[str]]
    r"""The ID of the customer this entity is linked to."""
    name: NotRequired[Nullable[str]]
    r"""Full name of the customer"""
    first_name: NotRequired[Nullable[str]]
    r"""First name of the customer"""
    last_name: NotRequired[Nullable[str]]
    r"""Last name of the customer"""
    company_name: NotRequired[Nullable[str]]
    r"""Company name of the customer"""
    phone_numbers: NotRequired[Nullable[List[PhoneNumberTypedDict]]]
    emails: NotRequired[Nullable[List[EmailTypedDict]]]


class LinkedEcommerceCustomer(BaseModel):
    r"""The customer this entity is linked to."""

    id: OptionalNullable[str] = UNSET
    r"""The ID of the customer this entity is linked to."""

    name: OptionalNullable[str] = UNSET
    r"""Full name of the customer"""

    first_name: OptionalNullable[str] = UNSET
    r"""First name of the customer"""

    last_name: OptionalNullable[str] = UNSET
    r"""Last name of the customer"""

    company_name: OptionalNullable[str] = UNSET
    r"""Company name of the customer"""

    phone_numbers: OptionalNullable[List[PhoneNumber]] = UNSET

    emails: OptionalNullable[List[Email]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "first_name",
            "last_name",
            "company_name",
            "phone_numbers",
            "emails",
        ]
        nullable_fields = [
            "id",
            "name",
            "first_name",
            "last_name",
            "company_name",
            "phone_numbers",
            "emails",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
