"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .balancebyperiod import BalanceByPeriod, BalanceByPeriodTypedDict
from .currency import Currency
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class OutstandingBalanceByCurrencyTypedDict(TypedDict):
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    total_amount: NotRequired[float]
    r"""Total amount of the outstanding balance."""
    balances_by_period: NotRequired[List[BalanceByPeriodTypedDict]]


class OutstandingBalanceByCurrency(BaseModel):
    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    total_amount: Optional[float] = None
    r"""Total amount of the outstanding balance."""

    balances_by_period: Optional[List[BalanceByPeriod]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency", "total_amount", "balances_by_period"]
        nullable_fields = ["currency"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
