"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class PhoneNumberType(str, Enum):
    r"""The type of phone number"""

    PRIMARY = "primary"
    SECONDARY = "secondary"
    HOME = "home"
    WORK = "work"
    OFFICE = "office"
    MOBILE = "mobile"
    ASSISTANT = "assistant"
    FAX = "fax"
    DIRECT_DIAL_IN = "direct-dial-in"
    PERSONAL = "personal"
    BILLING = "billing"
    OTHER = "other"


class PhoneNumberTypedDict(TypedDict):
    number: str
    r"""The phone number"""
    id: NotRequired[Nullable[str]]
    r"""Unique identifier of the phone number"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the phone number, e.g. +1"""
    area_code: NotRequired[Nullable[str]]
    r"""The area code of the phone number, e.g. 323"""
    extension: NotRequired[Nullable[str]]
    r"""The extension of the phone number"""
    type: NotRequired[Nullable[PhoneNumberType]]
    r"""The type of phone number"""


class PhoneNumber(BaseModel):
    number: str
    r"""The phone number"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier of the phone number"""

    country_code: OptionalNullable[str] = UNSET
    r"""The country code of the phone number, e.g. +1"""

    area_code: OptionalNullable[str] = UNSET
    r"""The area code of the phone number, e.g. 323"""

    extension: OptionalNullable[str] = UNSET
    r"""The extension of the phone number"""

    type: OptionalNullable[PhoneNumberType] = UNSET
    r"""The type of phone number"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "country_code", "area_code", "extension", "type"]
        nullable_fields = ["id", "country_code", "area_code", "extension", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
