"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from .linkedcustomer import LinkedCustomer, LinkedCustomerTypedDict
from .linkedcustomer_input import LinkedCustomerInput, LinkedCustomerInputTypedDict
from .linkedtrackingcategory import (
    LinkedTrackingCategory,
    LinkedTrackingCategoryTypedDict,
)
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from .quotelineitem import (
    QuoteLineItem,
    QuoteLineItemInput,
    QuoteLineItemInputTypedDict,
    QuoteLineItemTypedDict,
)
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import date, datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class QuoteStatus(str, Enum):
    r"""Quote status"""

    DRAFT = "draft"
    SENT = "sent"
    ACCEPTED = "accepted"
    REJECTED = "rejected"
    EXPIRED = "expired"
    CONVERTED = "converted"
    VOID = "void"
    DELETED = "deleted"


class QuoteTypedDict(TypedDict):
    id: NotRequired[str]
    r"""A unique identifier for an object."""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""
    number: NotRequired[Nullable[str]]
    r"""Quote number."""
    customer: NotRequired[Nullable[LinkedCustomerTypedDict]]
    r"""The customer this entity is linked to."""
    invoice_id: NotRequired[str]
    r"""The unique identifier for the invoice."""
    sales_order_id: NotRequired[Nullable[str]]
    r"""The unique identifier for the sales order."""
    company_id: NotRequired[Nullable[str]]
    r"""The company ID the transaction belongs to"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    project_id: NotRequired[str]
    r"""The unique identifier for the linked project."""
    quote_date: NotRequired[Nullable[date]]
    r"""Date quote was issued - YYYY-MM-DD."""
    expiry_date: NotRequired[Nullable[date]]
    r"""The date until which the quote is valid - YYYY-MM-DD."""
    terms: NotRequired[Nullable[str]]
    r"""Terms of the quote."""
    reference: NotRequired[Nullable[str]]
    r"""Optional reference identifier for the transaction."""
    status: NotRequired[Nullable[QuoteStatus]]
    r"""Quote status"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    currency_rate: NotRequired[Nullable[float]]
    r"""Currency Exchange Rate at the time entity was recorded/generated."""
    tax_inclusive: NotRequired[Nullable[bool]]
    r"""Amounts are including tax"""
    sub_total: NotRequired[Nullable[float]]
    r"""Sub-total amount, normally before tax."""
    total_tax: NotRequired[Nullable[float]]
    r"""Total tax amount applied to this quote."""
    tax_code: NotRequired[Nullable[str]]
    r"""Applicable tax id/code override if tax is not supplied on a line item basis."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to this quote."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to this quote."""
    total: NotRequired[Nullable[float]]
    r"""Total amount of quote, including tax."""
    customer_memo: NotRequired[Nullable[str]]
    r"""Customer memo"""
    line_items: NotRequired[List[QuoteLineItemTypedDict]]
    billing_address: NotRequired[AddressTypedDict]
    shipping_address: NotRequired[AddressTypedDict]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    template_id: NotRequired[Nullable[str]]
    r"""Optional quote template"""
    source_document_url: NotRequired[Nullable[str]]
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Quote(BaseModel):
    id: Optional[str] = None
    r"""A unique identifier for an object."""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    number: OptionalNullable[str] = UNSET
    r"""Quote number."""

    customer: OptionalNullable[LinkedCustomer] = UNSET
    r"""The customer this entity is linked to."""

    invoice_id: Optional[str] = None
    r"""The unique identifier for the invoice."""

    sales_order_id: OptionalNullable[str] = UNSET
    r"""The unique identifier for the sales order."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company ID the transaction belongs to"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    project_id: Optional[str] = None
    r"""The unique identifier for the linked project."""

    quote_date: OptionalNullable[date] = UNSET
    r"""Date quote was issued - YYYY-MM-DD."""

    expiry_date: OptionalNullable[date] = UNSET
    r"""The date until which the quote is valid - YYYY-MM-DD."""

    terms: OptionalNullable[str] = UNSET
    r"""Terms of the quote."""

    reference: OptionalNullable[str] = UNSET
    r"""Optional reference identifier for the transaction."""

    status: OptionalNullable[QuoteStatus] = UNSET
    r"""Quote status"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    currency_rate: OptionalNullable[float] = UNSET
    r"""Currency Exchange Rate at the time entity was recorded/generated."""

    tax_inclusive: OptionalNullable[bool] = UNSET
    r"""Amounts are including tax"""

    sub_total: OptionalNullable[float] = UNSET
    r"""Sub-total amount, normally before tax."""

    total_tax: OptionalNullable[float] = UNSET
    r"""Total tax amount applied to this quote."""

    tax_code: OptionalNullable[str] = UNSET
    r"""Applicable tax id/code override if tax is not supplied on a line item basis."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to this quote."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to this quote."""

    total: OptionalNullable[float] = UNSET
    r"""Total amount of quote, including tax."""

    customer_memo: OptionalNullable[str] = UNSET
    r"""Customer memo"""

    line_items: Optional[List[QuoteLineItem]] = None

    billing_address: Optional[Address] = None

    shipping_address: Optional[Address] = None

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    template_id: OptionalNullable[str] = UNSET
    r"""Optional quote template"""

    source_document_url: OptionalNullable[str] = UNSET
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app."""

    custom_fields: Optional[List[CustomField]] = None

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "downstream_id",
            "number",
            "customer",
            "invoice_id",
            "sales_order_id",
            "company_id",
            "department_id",
            "project_id",
            "quote_date",
            "expiry_date",
            "terms",
            "reference",
            "status",
            "currency",
            "currency_rate",
            "tax_inclusive",
            "sub_total",
            "total_tax",
            "tax_code",
            "discount_percentage",
            "discount_amount",
            "total",
            "customer_memo",
            "line_items",
            "billing_address",
            "shipping_address",
            "tracking_categories",
            "template_id",
            "source_document_url",
            "custom_fields",
            "row_version",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "downstream_id",
            "number",
            "customer",
            "sales_order_id",
            "company_id",
            "department_id",
            "quote_date",
            "expiry_date",
            "terms",
            "reference",
            "status",
            "currency",
            "currency_rate",
            "tax_inclusive",
            "sub_total",
            "total_tax",
            "tax_code",
            "discount_percentage",
            "discount_amount",
            "total",
            "customer_memo",
            "tracking_categories",
            "template_id",
            "source_document_url",
            "row_version",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class QuoteInputTypedDict(TypedDict):
    number: NotRequired[Nullable[str]]
    r"""Quote number."""
    customer: NotRequired[Nullable[LinkedCustomerInputTypedDict]]
    r"""The customer this entity is linked to."""
    sales_order_id: NotRequired[Nullable[str]]
    r"""The unique identifier for the sales order."""
    company_id: NotRequired[Nullable[str]]
    r"""The company ID the transaction belongs to"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    project_id: NotRequired[str]
    r"""The unique identifier for the linked project."""
    quote_date: NotRequired[Nullable[date]]
    r"""Date quote was issued - YYYY-MM-DD."""
    expiry_date: NotRequired[Nullable[date]]
    r"""The date until which the quote is valid - YYYY-MM-DD."""
    terms: NotRequired[Nullable[str]]
    r"""Terms of the quote."""
    reference: NotRequired[Nullable[str]]
    r"""Optional reference identifier for the transaction."""
    status: NotRequired[Nullable[QuoteStatus]]
    r"""Quote status"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    currency_rate: NotRequired[Nullable[float]]
    r"""Currency Exchange Rate at the time entity was recorded/generated."""
    tax_inclusive: NotRequired[Nullable[bool]]
    r"""Amounts are including tax"""
    sub_total: NotRequired[Nullable[float]]
    r"""Sub-total amount, normally before tax."""
    total_tax: NotRequired[Nullable[float]]
    r"""Total tax amount applied to this quote."""
    tax_code: NotRequired[Nullable[str]]
    r"""Applicable tax id/code override if tax is not supplied on a line item basis."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to this quote."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to this quote."""
    total: NotRequired[Nullable[float]]
    r"""Total amount of quote, including tax."""
    customer_memo: NotRequired[Nullable[str]]
    r"""Customer memo"""
    line_items: NotRequired[List[QuoteLineItemInputTypedDict]]
    billing_address: NotRequired[AddressTypedDict]
    shipping_address: NotRequired[AddressTypedDict]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    template_id: NotRequired[Nullable[str]]
    r"""Optional quote template"""
    source_document_url: NotRequired[Nullable[str]]
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app."""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class QuoteInput(BaseModel):
    number: OptionalNullable[str] = UNSET
    r"""Quote number."""

    customer: OptionalNullable[LinkedCustomerInput] = UNSET
    r"""The customer this entity is linked to."""

    sales_order_id: OptionalNullable[str] = UNSET
    r"""The unique identifier for the sales order."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company ID the transaction belongs to"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    project_id: Optional[str] = None
    r"""The unique identifier for the linked project."""

    quote_date: OptionalNullable[date] = UNSET
    r"""Date quote was issued - YYYY-MM-DD."""

    expiry_date: OptionalNullable[date] = UNSET
    r"""The date until which the quote is valid - YYYY-MM-DD."""

    terms: OptionalNullable[str] = UNSET
    r"""Terms of the quote."""

    reference: OptionalNullable[str] = UNSET
    r"""Optional reference identifier for the transaction."""

    status: OptionalNullable[QuoteStatus] = UNSET
    r"""Quote status"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    currency_rate: OptionalNullable[float] = UNSET
    r"""Currency Exchange Rate at the time entity was recorded/generated."""

    tax_inclusive: OptionalNullable[bool] = UNSET
    r"""Amounts are including tax"""

    sub_total: OptionalNullable[float] = UNSET
    r"""Sub-total amount, normally before tax."""

    total_tax: OptionalNullable[float] = UNSET
    r"""Total tax amount applied to this quote."""

    tax_code: OptionalNullable[str] = UNSET
    r"""Applicable tax id/code override if tax is not supplied on a line item basis."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to this quote."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to this quote."""

    total: OptionalNullable[float] = UNSET
    r"""Total amount of quote, including tax."""

    customer_memo: OptionalNullable[str] = UNSET
    r"""Customer memo"""

    line_items: Optional[List[QuoteLineItemInput]] = None

    billing_address: Optional[Address] = None

    shipping_address: Optional[Address] = None

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    template_id: OptionalNullable[str] = UNSET
    r"""Optional quote template"""

    source_document_url: OptionalNullable[str] = UNSET
    r"""URL link to a source document - shown as 'Go to [appName]' in the downstream app."""

    custom_fields: Optional[List[CustomField]] = None

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "number",
            "customer",
            "sales_order_id",
            "company_id",
            "department_id",
            "project_id",
            "quote_date",
            "expiry_date",
            "terms",
            "reference",
            "status",
            "currency",
            "currency_rate",
            "tax_inclusive",
            "sub_total",
            "total_tax",
            "tax_code",
            "discount_percentage",
            "discount_amount",
            "total",
            "customer_memo",
            "line_items",
            "billing_address",
            "shipping_address",
            "tracking_categories",
            "template_id",
            "source_document_url",
            "custom_fields",
            "row_version",
            "pass_through",
        ]
        nullable_fields = [
            "number",
            "customer",
            "sales_order_id",
            "company_id",
            "department_id",
            "quote_date",
            "expiry_date",
            "terms",
            "reference",
            "status",
            "currency",
            "currency_rate",
            "tax_inclusive",
            "sub_total",
            "total_tax",
            "tax_code",
            "discount_percentage",
            "discount_amount",
            "total",
            "customer_memo",
            "tracking_categories",
            "template_id",
            "source_document_url",
            "row_version",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
