"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class RebillStatus(str, Enum):
    r"""Status of the rebilling process for this line item."""

    PENDING = "pending"
    BILLED = "billed"
    VOIDED = "voided"


class RebillingTypedDict(TypedDict):
    r"""Rebilling metadata for this line item."""

    rebillable: NotRequired[bool]
    r"""Whether this line item is eligible for rebilling."""
    rebill_status: NotRequired[Nullable[RebillStatus]]
    r"""Status of the rebilling process for this line item."""
    linked_transaction_id: NotRequired[Nullable[str]]
    r"""The ID of the transaction this line item was rebilled to."""
    linked_transaction_line_id: NotRequired[Nullable[str]]
    r"""The ID of the line item in the rebilled transaction."""


class Rebilling(BaseModel):
    r"""Rebilling metadata for this line item."""

    rebillable: Optional[bool] = None
    r"""Whether this line item is eligible for rebilling."""

    rebill_status: OptionalNullable[RebillStatus] = UNSET
    r"""Status of the rebilling process for this line item."""

    linked_transaction_id: OptionalNullable[str] = UNSET
    r"""The ID of the transaction this line item was rebilled to."""

    linked_transaction_line_id: OptionalNullable[str] = UNSET
    r"""The ID of the line item in the rebilled transaction."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "rebillable",
            "rebill_status",
            "linked_transaction_id",
            "linked_transaction_line_id",
        ]
        nullable_fields = [
            "rebill_status",
            "linked_transaction_id",
            "linked_transaction_line_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
