"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import BaseModel
from enum import Enum
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class Mode(str, Enum):
    r"""Mode of the webhook support."""

    NATIVE = "native"
    VIRTUAL = "virtual"
    NONE = "none"


class SubscriptionLevel(str, Enum):
    r"""Received events are scoped to connection or across integration."""

    CONNECTION = "connection"
    INTEGRATION = "integration"


class ManagedVia(str, Enum):
    r"""How the subscription is managed in the downstream."""

    MANUAL = "manual"
    API = "api"


class Unit(str, Enum):
    r"""The window unit for the rate."""

    SECOND = "second"
    MINUTE = "minute"
    HOUR = "hour"
    DAY = "day"


class RequestRateTypedDict(TypedDict):
    r"""The rate at which requests for resources will be made to downstream."""

    rate: int
    r"""The number of requests per window unit."""
    size: int
    r"""Size of request window."""
    unit: Unit
    r"""The window unit for the rate."""


class RequestRate(BaseModel):
    r"""The rate at which requests for resources will be made to downstream."""

    rate: int
    r"""The number of requests per window unit."""

    size: int
    r"""Size of request window."""

    unit: Unit
    r"""The window unit for the rate."""


class WebhookSupportResourcesTypedDict(TypedDict):
    events: NotRequired[List[str]]


class WebhookSupportResources(BaseModel):
    events: Optional[List[str]] = None


class VirtualWebhooksTypedDict(TypedDict):
    r"""Virtual webhook config for the connector."""

    request_rate: RequestRateTypedDict
    r"""The rate at which requests for resources will be made to downstream."""
    resources: NotRequired[Dict[str, WebhookSupportResourcesTypedDict]]
    r"""The resources that will be requested from downstream."""


class VirtualWebhooks(BaseModel):
    r"""Virtual webhook config for the connector."""

    request_rate: RequestRate
    r"""The rate at which requests for resources will be made to downstream."""

    resources: Optional[Dict[str, WebhookSupportResources]] = None
    r"""The resources that will be requested from downstream."""


class WebhookSupportTypedDict(TypedDict):
    r"""How webhooks are supported for the connector. Sometimes the connector natively supports webhooks, other times Apideck virtualizes them based on polling."""

    mode: NotRequired[Mode]
    r"""Mode of the webhook support."""
    subscription_level: NotRequired[SubscriptionLevel]
    r"""Received events are scoped to connection or across integration."""
    managed_via: NotRequired[ManagedVia]
    r"""How the subscription is managed in the downstream."""
    virtual_webhooks: NotRequired[VirtualWebhooksTypedDict]
    r"""Virtual webhook config for the connector."""


class WebhookSupport(BaseModel):
    r"""How webhooks are supported for the connector. Sometimes the connector natively supports webhooks, other times Apideck virtualizes them based on polling."""

    mode: Optional[Mode] = None
    r"""Mode of the webhook support."""

    subscription_level: Optional[SubscriptionLevel] = None
    r"""Received events are scoped to connection or across integration."""

    managed_via: Optional[ManagedVia] = None
    r"""How the subscription is managed in the downstream."""

    virtual_webhooks: Optional[VirtualWebhooks] = None
    r"""Virtual webhook config for the connector."""
