import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AdministrativeUnitConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description for the administrative unit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#description AdministrativeUnit#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name for the administrative unit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#display_name AdministrativeUnit#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether the administrative unit and its members are hidden or publicly viewable in the directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#hidden_membership_enabled AdministrativeUnit#hidden_membership_enabled}
     *
     * @stability stable
     */
    readonly hiddenMembershipEnabled?: boolean | cdktf.IResolvable;
    /**
     * A set of object IDs of members who should be present in this administrative unit.
     *
     * Supported object types are Users or Groups
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#members AdministrativeUnit#members}
     *
     * @stability stable
     */
    readonly members?: string[];
    /**
     * If `true`, will return an error if an existing administrative unit is found with the same name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#prevent_duplicate_names AdministrativeUnit#prevent_duplicate_names}
     *
     * @stability stable
     */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#timeouts AdministrativeUnit#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AdministrativeUnitTimeouts;
}
/**
 * @stability stable
 */
export interface AdministrativeUnitTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#create AdministrativeUnit#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#delete AdministrativeUnit#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#read AdministrativeUnit#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#update AdministrativeUnit#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function administrativeUnitTimeoutsToTerraform(struct?: AdministrativeUnitTimeoutsOutputReference | AdministrativeUnitTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AdministrativeUnitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AdministrativeUnitTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AdministrativeUnitTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit azuread_administrative_unit}.
 *
 * @stability stable
 */
export declare class AdministrativeUnit extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit azuread_administrative_unit} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AdministrativeUnitConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _hiddenMembershipEnabled?;
    /**
     * @stability stable
     */
    get hiddenMembershipEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hiddenMembershipEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHiddenMembershipEnabled(): void;
    /**
     * @stability stable
     */
    get hiddenMembershipEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    resetMembers(): void;
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get objectId(): string;
    private _preventDuplicateNames?;
    /**
     * @stability stable
     */
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreventDuplicateNames(): void;
    /**
     * @stability stable
     */
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AdministrativeUnitTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AdministrativeUnitTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AdministrativeUnitTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
