import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the app role to be assigned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#app_role_id AppRoleAssignment#app_role_id}
     *
     * @stability stable
     */
    readonly appRoleId: string;
    /**
     * The object ID of the user, group or service principal to be assigned this app role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#principal_object_id AppRoleAssignment#principal_object_id}
     *
     * @stability stable
     */
    readonly principalObjectId: string;
    /**
     * The object ID of the service principal representing the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#resource_object_id AppRoleAssignment#resource_object_id}
     *
     * @stability stable
     */
    readonly resourceObjectId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#timeouts AppRoleAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppRoleAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface AppRoleAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#create AppRoleAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#delete AppRoleAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#read AppRoleAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function appRoleAssignmentTimeoutsToTerraform(struct?: AppRoleAssignmentTimeoutsOutputReference | AppRoleAssignmentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppRoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppRoleAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment azuread_app_role_assignment}.
 *
 * @stability stable
 */
export declare class AppRoleAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment azuread_app_role_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppRoleAssignmentConfig);
    private _appRoleId?;
    /**
     * @stability stable
     */
    get appRoleId(): string;
    /**
     * @stability stable
     */
    set appRoleId(value: string);
    /**
     * @stability stable
     */
    get appRoleIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get principalDisplayName(): string;
    private _principalObjectId?;
    /**
     * @stability stable
     */
    get principalObjectId(): string;
    /**
     * @stability stable
     */
    set principalObjectId(value: string);
    /**
     * @stability stable
     */
    get principalObjectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get principalType(): string;
    /**
     * @stability stable
     */
    get resourceDisplayName(): string;
    private _resourceObjectId?;
    /**
     * @stability stable
     */
    get resourceObjectId(): string;
    /**
     * @stability stable
     */
    set resourceObjectId(value: string);
    /**
     * @stability stable
     */
    get resourceObjectIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppRoleAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppRoleAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppRoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
