import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The object ID of the application for which this certificate should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#application_object_id ApplicationCertificate#application_object_id}
     *
     * @stability stable
     */
    readonly applicationObjectId: string;
    /**
     * Specifies the encoding used for the supplied certificate data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#encoding ApplicationCertificate#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * The end date until which the certificate is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`). If omitted, the API will decide a suitable expiry date, which is typically around 2 years from the start date.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#end_date ApplicationCertificate#end_date}
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * A relative duration for which the certificate is valid until, for example `240h` (10 days) or `2400h30m`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#end_date_relative ApplicationCertificate#end_date_relative}
     *
     * @stability stable
     */
    readonly endDateRelative?: string;
    /**
     * A UUID used to uniquely identify this certificate. If omitted, a random UUID will be automatically generated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#key_id ApplicationCertificate#key_id}
     *
     * @stability stable
     */
    readonly keyId?: string;
    /**
     * The start date from which the certificate is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`). If this isn't specified, the current date and time are use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#start_date ApplicationCertificate#start_date}
     *
     * @stability stable
     */
    readonly startDate?: string;
    /**
     * The type of key/certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#type ApplicationCertificate#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * The certificate data, which can be PEM encoded, base64 encoded DER or hexadecimal encoded DER.
     *
     * See also the `encoding` argumen
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#value ApplicationCertificate#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#timeouts ApplicationCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#create ApplicationCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#delete ApplicationCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#read ApplicationCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate#update ApplicationCertificate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationCertificateTimeoutsToTerraform(struct?: ApplicationCertificateTimeoutsOutputReference | ApplicationCertificateTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApplicationCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate azuread_application_certificate}.
 *
 * @stability stable
 */
export declare class ApplicationCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_certificate azuread_application_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationCertificateConfig);
    private _applicationObjectId?;
    /**
     * @stability stable
     */
    get applicationObjectId(): string;
    /**
     * @stability stable
     */
    set applicationObjectId(value: string);
    /**
     * @stability stable
     */
    get applicationObjectIdInput(): string | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    set endDate(value: string);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    private _endDateRelative?;
    /**
     * @stability stable
     */
    get endDateRelative(): string;
    /**
     * @stability stable
     */
    set endDateRelative(value: string);
    /**
     * @stability stable
     */
    resetEndDateRelative(): void;
    /**
     * @stability stable
     */
    get endDateRelativeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    resetKeyId(): void;
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string;
    /**
     * @stability stable
     */
    set startDate(value: string);
    /**
     * @stability stable
     */
    resetStartDate(): void;
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
