import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationFederatedIdentityCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
     * The object ID of the application for which this federated identity credential should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#application_object_id ApplicationFederatedIdentityCredential#application_object_id}
     *
     * @stability stable
     */
    readonly applicationObjectId: string;
    /**
     * List of audiences that can appear in the external token.
     *
     * This specifies what should be accepted in the `aud` claim of incoming tokens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#audiences ApplicationFederatedIdentityCredential#audiences}
     *
     * @stability stable
     */
    readonly audiences: string[];
    /**
     * A description for the federated identity credential.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#description ApplicationFederatedIdentityCredential#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A unique display name for the federated identity credential.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#display_name ApplicationFederatedIdentityCredential#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The URL of the external identity provider, which must match the issuer claim of the external token being exchanged.
     *
     * The combination of the values of issuer and subject must be unique on the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#issuer ApplicationFederatedIdentityCredential#issuer}
     *
     * @stability stable
     */
    readonly issuer: string;
    /**
     * The identifier of the external software workload within the external identity provider.
     *
     * The combination of issuer and subject must be unique on the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#subject ApplicationFederatedIdentityCredential#subject}
     *
     * @stability stable
     */
    readonly subject: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#timeouts ApplicationFederatedIdentityCredential#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationFederatedIdentityCredentialTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationFederatedIdentityCredentialTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#create ApplicationFederatedIdentityCredential#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#delete ApplicationFederatedIdentityCredential#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#read ApplicationFederatedIdentityCredential#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#update ApplicationFederatedIdentityCredential#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationFederatedIdentityCredentialTimeoutsToTerraform(struct?: ApplicationFederatedIdentityCredentialTimeoutsOutputReference | ApplicationFederatedIdentityCredentialTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApplicationFederatedIdentityCredentialTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationFederatedIdentityCredentialTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationFederatedIdentityCredentialTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential azuread_application_federated_identity_credential}.
 *
 * @stability stable
 */
export declare class ApplicationFederatedIdentityCredential extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential azuread_application_federated_identity_credential} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationFederatedIdentityCredentialConfig);
    private _applicationObjectId?;
    /**
     * @stability stable
     */
    get applicationObjectId(): string;
    /**
     * @stability stable
     */
    set applicationObjectId(value: string);
    /**
     * @stability stable
     */
    get applicationObjectIdInput(): string | undefined;
    private _audiences?;
    /**
     * @stability stable
     */
    get audiences(): string[];
    /**
     * @stability stable
     */
    set audiences(value: string[]);
    /**
     * @stability stable
     */
    get audiencesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get credentialId(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationFederatedIdentityCredentialTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationFederatedIdentityCredentialTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationFederatedIdentityCredentialTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
