import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
     * The object ID of the application for which this password should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#application_object_id ApplicationPassword#application_object_id}
     *
     * @stability stable
     */
    readonly applicationObjectId: string;
    /**
     * A display name for the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#display_name ApplicationPassword#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The end date until which the password is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#end_date ApplicationPassword#end_date}
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * A relative duration for which the password is valid until, for example `240h` (10 days) or `2400h30m`.
     *
     * Changing this field forces a new resource to be created
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#end_date_relative ApplicationPassword#end_date_relative}
     *
     * @stability stable
     */
    readonly endDateRelative?: string;
    /**
     * Arbitrary map of values that, when changed, will trigger rotation of the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#rotate_when_changed ApplicationPassword#rotate_when_changed}
     *
     * @stability stable
     */
    readonly rotateWhenChanged?: {
        [key: string]: string;
    };
    /**
     * The start date from which the password is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`). If this isn't specified, the current date is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#start_date ApplicationPassword#start_date}
     *
     * @stability stable
     */
    readonly startDate?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#timeouts ApplicationPassword#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationPasswordTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationPasswordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#create ApplicationPassword#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#delete ApplicationPassword#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#read ApplicationPassword#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#update ApplicationPassword#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationPasswordTimeoutsToTerraform(struct?: ApplicationPasswordTimeoutsOutputReference | ApplicationPasswordTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApplicationPasswordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationPasswordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationPasswordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_password azuread_application_password}.
 *
 * @stability stable
 */
export declare class ApplicationPassword extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_password azuread_application_password} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationPasswordConfig);
    private _applicationObjectId?;
    /**
     * @stability stable
     */
    get applicationObjectId(): string;
    /**
     * @stability stable
     */
    set applicationObjectId(value: string);
    /**
     * @stability stable
     */
    get applicationObjectIdInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    set endDate(value: string);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    private _endDateRelative?;
    /**
     * @stability stable
     */
    get endDateRelative(): string;
    /**
     * @stability stable
     */
    set endDateRelative(value: string);
    /**
     * @stability stable
     */
    resetEndDateRelative(): void;
    /**
     * @stability stable
     */
    get endDateRelativeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyId(): string;
    private _rotateWhenChanged?;
    /**
     * @stability stable
     */
    get rotateWhenChanged(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set rotateWhenChanged(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetRotateWhenChanged(): void;
    /**
     * @stability stable
     */
    get rotateWhenChangedInput(): {
        [key: string]: string;
    } | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string;
    /**
     * @stability stable
     */
    set startDate(value: string);
    /**
     * @stability stable
     */
    resetStartDate(): void;
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
    /**
     * @stability stable
     */
    get value(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationPasswordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationPasswordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationPasswordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
