import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationPreAuthorizedConfig extends cdktf.TerraformMetaArguments {
    /**
     * The object ID of the application to which this pre-authorized application should be added.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#application_object_id ApplicationPreAuthorized#application_object_id}
     *
     * @stability stable
     */
    readonly applicationObjectId: string;
    /**
     * The application ID of the pre-authorized application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#authorized_app_id ApplicationPreAuthorized#authorized_app_id}
     *
     * @stability stable
     */
    readonly authorizedAppId: string;
    /**
     * The IDs of the permission scopes required by the pre-authorized application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#permission_ids ApplicationPreAuthorized#permission_ids}
     *
     * @stability stable
     */
    readonly permissionIds: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#timeouts ApplicationPreAuthorized#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationPreAuthorizedTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationPreAuthorizedTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#create ApplicationPreAuthorized#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#delete ApplicationPreAuthorized#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#read ApplicationPreAuthorized#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#update ApplicationPreAuthorized#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationPreAuthorizedTimeoutsToTerraform(struct?: ApplicationPreAuthorizedTimeoutsOutputReference | ApplicationPreAuthorizedTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApplicationPreAuthorizedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationPreAuthorizedTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationPreAuthorizedTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized azuread_application_pre_authorized}.
 *
 * @stability stable
 */
export declare class ApplicationPreAuthorized extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized azuread_application_pre_authorized} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationPreAuthorizedConfig);
    private _applicationObjectId?;
    /**
     * @stability stable
     */
    get applicationObjectId(): string;
    /**
     * @stability stable
     */
    set applicationObjectId(value: string);
    /**
     * @stability stable
     */
    get applicationObjectIdInput(): string | undefined;
    private _authorizedAppId?;
    /**
     * @stability stable
     */
    get authorizedAppId(): string;
    /**
     * @stability stable
     */
    set authorizedAppId(value: string);
    /**
     * @stability stable
     */
    get authorizedAppIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _permissionIds?;
    /**
     * @stability stable
     */
    get permissionIds(): string[];
    /**
     * @stability stable
     */
    set permissionIds(value: string[]);
    /**
     * @stability stable
     */
    get permissionIdsInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationPreAuthorizedTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationPreAuthorizedTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationPreAuthorizedTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
