import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies whether this application supports device authentication without a user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#device_only_auth_enabled Application#device_only_auth_enabled}
     *
     * @stability stable
     */
    readonly deviceOnlyAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * The display name for the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#display_name Application#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Specifies whether the application is a public client.
     *
     * Appropriate for apps using token grant flows that don't use a redirect URI
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#fallback_public_client_enabled Application#fallback_public_client_enabled}
     *
     * @stability stable
     */
    readonly fallbackPublicClientEnabled?: boolean | cdktf.IResolvable;
    /**
     * Configures the `groups` claim issued in a user or OAuth 2.0 access token that the app expects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#group_membership_claims Application#group_membership_claims}
     *
     * @stability stable
     */
    readonly groupMembershipClaims?: string[];
    /**
     * The user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#identifier_uris Application#identifier_uris}
     *
     * @stability stable
     */
    readonly identifierUris?: string[];
    /**
     * Base64 encoded logo image in gif, png or jpeg format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#logo_image Application#logo_image}
     *
     * @stability stable
     */
    readonly logoImage?: string;
    /**
     * URL of the application's marketing page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#marketing_url Application#marketing_url}
     *
     * @stability stable
     */
    readonly marketingUrl?: string;
    /**
     * Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#oauth2_post_response_required Application#oauth2_post_response_required}
     *
     * @stability stable
     */
    readonly oauth2PostResponseRequired?: boolean | cdktf.IResolvable;
    /**
     * A list of object IDs of principals that will be granted ownership of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#owners Application#owners}
     *
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * If `true`, will return an error if an existing application is found with the same name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#prevent_duplicate_names Application#prevent_duplicate_names}
     *
     * @stability stable
     */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
     * URL of the application's privacy statement.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#privacy_statement_url Application#privacy_statement_url}
     *
     * @stability stable
     */
    readonly privacyStatementUrl?: string;
    /**
     * The Microsoft account types that are supported for the current application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#sign_in_audience Application#sign_in_audience}
     *
     * @stability stable
     */
    readonly signInAudience?: string;
    /**
     * URL of the application's support page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#support_url Application#support_url}
     *
     * @stability stable
     */
    readonly supportUrl?: string;
    /**
     * A set of tags to apply to the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#tags Application#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Unique ID of the application template from which this application is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#template_id Application#template_id}
     *
     * @stability stable
     */
    readonly templateId?: string;
    /**
     * URL of the application's terms of service statement.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#terms_of_service_url Application#terms_of_service_url}
     *
     * @stability stable
     */
    readonly termsOfServiceUrl?: string;
    /**
     * api block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#api Application#api}
     *
     * @stability stable
     */
    readonly api?: ApplicationApi;
    /**
     * app_role block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#app_role Application#app_role}
     *
     * @stability stable
     */
    readonly appRole?: ApplicationAppRole[] | cdktf.IResolvable;
    /**
     * feature_tags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#feature_tags Application#feature_tags}
     *
     * @stability stable
     */
    readonly featureTags?: ApplicationFeatureTags[] | cdktf.IResolvable;
    /**
     * optional_claims block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#optional_claims Application#optional_claims}
     *
     * @stability stable
     */
    readonly optionalClaims?: ApplicationOptionalClaims;
    /**
     * public_client block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#public_client Application#public_client}
     *
     * @stability stable
     */
    readonly publicClient?: ApplicationPublicClient;
    /**
     * required_resource_access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#required_resource_access Application#required_resource_access}
     *
     * @stability stable
     */
    readonly requiredResourceAccess?: ApplicationRequiredResourceAccess[] | cdktf.IResolvable;
    /**
     * single_page_application block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#single_page_application Application#single_page_application}
     *
     * @stability stable
     */
    readonly singlePageApplication?: ApplicationSinglePageApplication;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#timeouts Application#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationTimeouts;
    /**
     * web block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#web Application#web}
     *
     * @stability stable
     */
    readonly web?: ApplicationWeb;
}
/**
 * @stability stable
 */
export interface ApplicationApiOauth2PermissionScope {
    /**
     * Delegated permission description that appears in all tenant-wide admin consent experiences, intended to be read by an administrator granting the permission on behalf of all users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#admin_consent_description Application#admin_consent_description}
     *
     * @stability stable
     */
    readonly adminConsentDescription?: string;
    /**
     * Display name for the delegated permission, intended to be read by an administrator granting the permission on behalf of all users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#admin_consent_display_name Application#admin_consent_display_name}
     *
     * @stability stable
     */
    readonly adminConsentDisplayName?: string;
    /**
     * Determines if the permission scope is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enabled Application#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The unique identifier of the delegated permission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#type Application#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Delegated permission description that appears in the end user consent experience, intended to be read by a user consenting on their own behalf.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#user_consent_description Application#user_consent_description}
     *
     * @stability stable
     */
    readonly userConsentDescription?: string;
    /**
     * Display name for the delegated permission that appears in the end user consent experience.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#user_consent_display_name Application#user_consent_display_name}
     *
     * @stability stable
     */
    readonly userConsentDisplayName?: string;
    /**
     * The value that is used for the `scp` claim in OAuth 2.0 access tokens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#value Application#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function applicationApiOauth2PermissionScopeToTerraform(struct?: ApplicationApiOauth2PermissionScope | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationApi {
    /**
     * Used for bundling consent if you have a solution that contains two parts: a client app and a custom web API app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#known_client_applications Application#known_client_applications}
     *
     * @stability stable
     */
    readonly knownClientApplications?: string[];
    /**
     * Allows an application to use claims mapping without specifying a custom signing key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#mapped_claims_enabled Application#mapped_claims_enabled}
     *
     * @stability stable
     */
    readonly mappedClaimsEnabled?: boolean | cdktf.IResolvable;
    /**
     * The access token version expected by this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#requested_access_token_version Application#requested_access_token_version}
     *
     * @stability stable
     */
    readonly requestedAccessTokenVersion?: number;
    /**
     * oauth2_permission_scope block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#oauth2_permission_scope Application#oauth2_permission_scope}
     *
     * @stability stable
     */
    readonly oauth2PermissionScope?: ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable;
}
export declare function applicationApiToTerraform(struct?: ApplicationApiOutputReference | ApplicationApi): any;
/**
 * @stability stable
 */
export declare class ApplicationApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationApi | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationApi | undefined);
    private _knownClientApplications?;
    /**
     * @stability stable
     */
    get knownClientApplications(): string[];
    /**
     * @stability stable
     */
    set knownClientApplications(value: string[]);
    /**
     * @stability stable
     */
    resetKnownClientApplications(): void;
    /**
     * @stability stable
     */
    get knownClientApplicationsInput(): string[] | undefined;
    private _mappedClaimsEnabled?;
    /**
     * @stability stable
     */
    get mappedClaimsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mappedClaimsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMappedClaimsEnabled(): void;
    /**
     * @stability stable
     */
    get mappedClaimsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _requestedAccessTokenVersion?;
    /**
     * @stability stable
     */
    get requestedAccessTokenVersion(): number;
    /**
     * @stability stable
     */
    set requestedAccessTokenVersion(value: number);
    /**
     * @stability stable
     */
    resetRequestedAccessTokenVersion(): void;
    /**
     * @stability stable
     */
    get requestedAccessTokenVersionInput(): number | undefined;
    private _oauth2PermissionScope?;
    /**
     * @stability stable
     */
    get oauth2PermissionScope(): ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oauth2PermissionScope(value: ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOauth2PermissionScope(): void;
    /**
     * @stability stable
     */
    get oauth2PermissionScopeInput(): cdktf.IResolvable | ApplicationApiOauth2PermissionScope[] | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationAppRole {
    /**
     * Specifies whether this app role definition can be assigned to users and groups by setting to `User`, or to other applications (that are accessing this application in a standalone scenario) by setting to `Application`, or to both.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#allowed_member_types Application#allowed_member_types}
     *
     * @stability stable
     */
    readonly allowedMemberTypes: string[];
    /**
     * Description of the app role that appears when the role is being assigned and, if the role functions as an application permissions, during the consent experiences.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#description Application#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Display name for the app role that appears during app role assignment and in consent experiences.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#display_name Application#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Determines if the app role is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enabled Application#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The unique identifier of the app role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The value that is used for the `roles` claim in ID tokens and OAuth 2.0 access tokens that are authenticating an assigned service or user principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#value Application#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function applicationAppRoleToTerraform(struct?: ApplicationAppRole | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationFeatureTags {
    /**
     * Whether this application represents a custom SAML application for linked service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#custom_single_sign_on Application#custom_single_sign_on}
     *
     * @stability stable
     */
    readonly customSingleSignOn?: boolean | cdktf.IResolvable;
    /**
     * Whether this application represents an Enterprise Application for linked service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enterprise Application#enterprise}
     *
     * @stability stable
     */
    readonly enterprise?: boolean | cdktf.IResolvable;
    /**
     * Whether this application represents a gallery application for linked service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#gallery Application#gallery}
     *
     * @stability stable
     */
    readonly gallery?: boolean | cdktf.IResolvable;
    /**
     * Whether this application is invisible to users in My Apps and Office 365 Launcher.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#hide Application#hide}
     *
     * @stability stable
     */
    readonly hide?: boolean | cdktf.IResolvable;
}
export declare function applicationFeatureTagsToTerraform(struct?: ApplicationFeatureTags | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationOptionalClaimsAccessToken {
    /**
     * List of additional properties of the claim.
     *
     * If a property exists in this list, it modifies the behaviour of the optional claim
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
     *
     * @stability stable
     */
    readonly additionalProperties?: string[];
    /**
     * Whether the claim specified by the client is necessary to ensure a smooth authorization experience.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
     *
     * @stability stable
     */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
     * The name of the optional claim.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The source of the claim.
     *
     * If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function applicationOptionalClaimsAccessTokenToTerraform(struct?: ApplicationOptionalClaimsAccessToken | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationOptionalClaimsIdToken {
    /**
     * List of additional properties of the claim.
     *
     * If a property exists in this list, it modifies the behaviour of the optional claim
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
     *
     * @stability stable
     */
    readonly additionalProperties?: string[];
    /**
     * Whether the claim specified by the client is necessary to ensure a smooth authorization experience.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
     *
     * @stability stable
     */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
     * The name of the optional claim.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The source of the claim.
     *
     * If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function applicationOptionalClaimsIdTokenToTerraform(struct?: ApplicationOptionalClaimsIdToken | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationOptionalClaimsSaml2Token {
    /**
     * List of additional properties of the claim.
     *
     * If a property exists in this list, it modifies the behaviour of the optional claim
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
     *
     * @stability stable
     */
    readonly additionalProperties?: string[];
    /**
     * Whether the claim specified by the client is necessary to ensure a smooth authorization experience.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
     *
     * @stability stable
     */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
     * The name of the optional claim.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The source of the claim.
     *
     * If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function applicationOptionalClaimsSaml2TokenToTerraform(struct?: ApplicationOptionalClaimsSaml2Token | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationOptionalClaims {
    /**
     * access_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#access_token Application#access_token}
     *
     * @stability stable
     */
    readonly accessToken?: ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable;
    /**
     * id_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id_token Application#id_token}
     *
     * @stability stable
     */
    readonly idToken?: ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable;
    /**
     * saml2_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#saml2_token Application#saml2_token}
     *
     * @stability stable
     */
    readonly saml2Token?: ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable;
}
export declare function applicationOptionalClaimsToTerraform(struct?: ApplicationOptionalClaimsOutputReference | ApplicationOptionalClaims): any;
/**
 * @stability stable
 */
export declare class ApplicationOptionalClaimsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationOptionalClaims | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationOptionalClaims | undefined);
    private _accessToken?;
    /**
     * @stability stable
     */
    get accessToken(): ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessToken(value: ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessToken(): void;
    /**
     * @stability stable
     */
    get accessTokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsAccessToken[] | undefined;
    private _idToken?;
    /**
     * @stability stable
     */
    get idToken(): ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set idToken(value: ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIdToken(): void;
    /**
     * @stability stable
     */
    get idTokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsIdToken[] | undefined;
    private _saml2Token?;
    /**
     * @stability stable
     */
    get saml2Token(): ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set saml2Token(value: ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSaml2Token(): void;
    /**
     * @stability stable
     */
    get saml2TokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsSaml2Token[] | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationPublicClient {
    /**
     * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
     *
     * @stability stable
     */
    readonly redirectUris?: string[];
}
export declare function applicationPublicClientToTerraform(struct?: ApplicationPublicClientOutputReference | ApplicationPublicClient): any;
/**
 * @stability stable
 */
export declare class ApplicationPublicClientOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationPublicClient | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationPublicClient | undefined);
    private _redirectUris?;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    set redirectUris(value: string[]);
    /**
     * @stability stable
     */
    resetRedirectUris(): void;
    /**
     * @stability stable
     */
    get redirectUrisInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationRequiredResourceAccessResourceAccess {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#type Application#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function applicationRequiredResourceAccessResourceAccessToTerraform(struct?: ApplicationRequiredResourceAccessResourceAccess | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationRequiredResourceAccess {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#resource_app_id Application#resource_app_id}.
     *
     * @stability stable
     */
    readonly resourceAppId: string;
    /**
     * resource_access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#resource_access Application#resource_access}
     *
     * @stability stable
     */
    readonly resourceAccess: ApplicationRequiredResourceAccessResourceAccess[] | cdktf.IResolvable;
}
export declare function applicationRequiredResourceAccessToTerraform(struct?: ApplicationRequiredResourceAccess | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApplicationSinglePageApplication {
    /**
     * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
     *
     * @stability stable
     */
    readonly redirectUris?: string[];
}
export declare function applicationSinglePageApplicationToTerraform(struct?: ApplicationSinglePageApplicationOutputReference | ApplicationSinglePageApplication): any;
/**
 * @stability stable
 */
export declare class ApplicationSinglePageApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationSinglePageApplication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationSinglePageApplication | undefined);
    private _redirectUris?;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    set redirectUris(value: string[]);
    /**
     * @stability stable
     */
    resetRedirectUris(): void;
    /**
     * @stability stable
     */
    get redirectUrisInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#create Application#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#delete Application#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#read Application#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#update Application#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationTimeoutsToTerraform(struct?: ApplicationTimeoutsOutputReference | ApplicationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationWebImplicitGrant {
    /**
     * Whether this web application can request an access token using OAuth 2.0 implicit flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#access_token_issuance_enabled Application#access_token_issuance_enabled}
     *
     * @stability stable
     */
    readonly accessTokenIssuanceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Whether this web application can request an ID token using OAuth 2.0 implicit flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id_token_issuance_enabled Application#id_token_issuance_enabled}
     *
     * @stability stable
     */
    readonly idTokenIssuanceEnabled?: boolean | cdktf.IResolvable;
}
export declare function applicationWebImplicitGrantToTerraform(struct?: ApplicationWebImplicitGrantOutputReference | ApplicationWebImplicitGrant): any;
/**
 * @stability stable
 */
export declare class ApplicationWebImplicitGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationWebImplicitGrant | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationWebImplicitGrant | undefined);
    private _accessTokenIssuanceEnabled?;
    /**
     * @stability stable
     */
    get accessTokenIssuanceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessTokenIssuanceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessTokenIssuanceEnabled(): void;
    /**
     * @stability stable
     */
    get accessTokenIssuanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _idTokenIssuanceEnabled?;
    /**
     * @stability stable
     */
    get idTokenIssuanceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set idTokenIssuanceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIdTokenIssuanceEnabled(): void;
    /**
     * @stability stable
     */
    get idTokenIssuanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationWeb {
    /**
     * Home page or landing page of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#homepage_url Application#homepage_url}
     *
     * @stability stable
     */
    readonly homepageUrl?: string;
    /**
     * The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#logout_url Application#logout_url}
     *
     * @stability stable
     */
    readonly logoutUrl?: string;
    /**
     * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
     *
     * @stability stable
     */
    readonly redirectUris?: string[];
    /**
     * implicit_grant block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#implicit_grant Application#implicit_grant}
     *
     * @stability stable
     */
    readonly implicitGrant?: ApplicationWebImplicitGrant;
}
export declare function applicationWebToTerraform(struct?: ApplicationWebOutputReference | ApplicationWeb): any;
/**
 * @stability stable
 */
export declare class ApplicationWebOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationWeb | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationWeb | undefined);
    private _homepageUrl?;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    set homepageUrl(value: string);
    /**
     * @stability stable
     */
    resetHomepageUrl(): void;
    /**
     * @stability stable
     */
    get homepageUrlInput(): string | undefined;
    private _logoutUrl?;
    /**
     * @stability stable
     */
    get logoutUrl(): string;
    /**
     * @stability stable
     */
    set logoutUrl(value: string);
    /**
     * @stability stable
     */
    resetLogoutUrl(): void;
    /**
     * @stability stable
     */
    get logoutUrlInput(): string | undefined;
    private _redirectUris?;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    set redirectUris(value: string[]);
    /**
     * @stability stable
     */
    resetRedirectUris(): void;
    /**
     * @stability stable
     */
    get redirectUrisInput(): string[] | undefined;
    private _implicitGrant;
    /**
     * @stability stable
     */
    get implicitGrant(): ApplicationWebImplicitGrantOutputReference;
    /**
     * @stability stable
     */
    putImplicitGrant(value: ApplicationWebImplicitGrant): void;
    /**
     * @stability stable
     */
    resetImplicitGrant(): void;
    /**
     * @stability stable
     */
    get implicitGrantInput(): ApplicationWebImplicitGrant | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application}.
 *
 * @stability stable
 */
export declare class Application extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationConfig);
    /**
     * @stability stable
     */
    appRoleIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get applicationId(): string;
    private _deviceOnlyAuthEnabled?;
    /**
     * @stability stable
     */
    get deviceOnlyAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deviceOnlyAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeviceOnlyAuthEnabled(): void;
    /**
     * @stability stable
     */
    get deviceOnlyAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get disabledByMicrosoft(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _fallbackPublicClientEnabled?;
    /**
     * @stability stable
     */
    get fallbackPublicClientEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fallbackPublicClientEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFallbackPublicClientEnabled(): void;
    /**
     * @stability stable
     */
    get fallbackPublicClientEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _groupMembershipClaims?;
    /**
     * @stability stable
     */
    get groupMembershipClaims(): string[];
    /**
     * @stability stable
     */
    set groupMembershipClaims(value: string[]);
    /**
     * @stability stable
     */
    resetGroupMembershipClaims(): void;
    /**
     * @stability stable
     */
    get groupMembershipClaimsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _identifierUris?;
    /**
     * @stability stable
     */
    get identifierUris(): string[];
    /**
     * @stability stable
     */
    set identifierUris(value: string[]);
    /**
     * @stability stable
     */
    resetIdentifierUris(): void;
    /**
     * @stability stable
     */
    get identifierUrisInput(): string[] | undefined;
    private _logoImage?;
    /**
     * @stability stable
     */
    get logoImage(): string;
    /**
     * @stability stable
     */
    set logoImage(value: string);
    /**
     * @stability stable
     */
    resetLogoImage(): void;
    /**
     * @stability stable
     */
    get logoImageInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    private _marketingUrl?;
    /**
     * @stability stable
     */
    get marketingUrl(): string;
    /**
     * @stability stable
     */
    set marketingUrl(value: string);
    /**
     * @stability stable
     */
    resetMarketingUrl(): void;
    /**
     * @stability stable
     */
    get marketingUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    private _oauth2PostResponseRequired?;
    /**
     * @stability stable
     */
    get oauth2PostResponseRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oauth2PostResponseRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOauth2PostResponseRequired(): void;
    /**
     * @stability stable
     */
    get oauth2PostResponseRequiredInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get objectId(): string;
    private _owners?;
    /**
     * @stability stable
     */
    get owners(): string[];
    /**
     * @stability stable
     */
    set owners(value: string[]);
    /**
     * @stability stable
     */
    resetOwners(): void;
    /**
     * @stability stable
     */
    get ownersInput(): string[] | undefined;
    private _preventDuplicateNames?;
    /**
     * @stability stable
     */
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreventDuplicateNames(): void;
    /**
     * @stability stable
     */
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _privacyStatementUrl?;
    /**
     * @stability stable
     */
    get privacyStatementUrl(): string;
    /**
     * @stability stable
     */
    set privacyStatementUrl(value: string);
    /**
     * @stability stable
     */
    resetPrivacyStatementUrl(): void;
    /**
     * @stability stable
     */
    get privacyStatementUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get publisherDomain(): string;
    private _signInAudience?;
    /**
     * @stability stable
     */
    get signInAudience(): string;
    /**
     * @stability stable
     */
    set signInAudience(value: string);
    /**
     * @stability stable
     */
    resetSignInAudience(): void;
    /**
     * @stability stable
     */
    get signInAudienceInput(): string | undefined;
    private _supportUrl?;
    /**
     * @stability stable
     */
    get supportUrl(): string;
    /**
     * @stability stable
     */
    set supportUrl(value: string);
    /**
     * @stability stable
     */
    resetSupportUrl(): void;
    /**
     * @stability stable
     */
    get supportUrlInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _templateId?;
    /**
     * @stability stable
     */
    get templateId(): string;
    /**
     * @stability stable
     */
    set templateId(value: string);
    /**
     * @stability stable
     */
    resetTemplateId(): void;
    /**
     * @stability stable
     */
    get templateIdInput(): string | undefined;
    private _termsOfServiceUrl?;
    /**
     * @stability stable
     */
    get termsOfServiceUrl(): string;
    /**
     * @stability stable
     */
    set termsOfServiceUrl(value: string);
    /**
     * @stability stable
     */
    resetTermsOfServiceUrl(): void;
    /**
     * @stability stable
     */
    get termsOfServiceUrlInput(): string | undefined;
    private _api;
    /**
     * @stability stable
     */
    get api(): ApplicationApiOutputReference;
    /**
     * @stability stable
     */
    putApi(value: ApplicationApi): void;
    /**
     * @stability stable
     */
    resetApi(): void;
    /**
     * @stability stable
     */
    get apiInput(): ApplicationApi | undefined;
    private _appRole?;
    /**
     * @stability stable
     */
    get appRole(): ApplicationAppRole[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appRole(value: ApplicationAppRole[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppRole(): void;
    /**
     * @stability stable
     */
    get appRoleInput(): cdktf.IResolvable | ApplicationAppRole[] | undefined;
    private _featureTags?;
    /**
     * @stability stable
     */
    get featureTags(): ApplicationFeatureTags[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set featureTags(value: ApplicationFeatureTags[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFeatureTags(): void;
    /**
     * @stability stable
     */
    get featureTagsInput(): cdktf.IResolvable | ApplicationFeatureTags[] | undefined;
    private _optionalClaims;
    /**
     * @stability stable
     */
    get optionalClaims(): ApplicationOptionalClaimsOutputReference;
    /**
     * @stability stable
     */
    putOptionalClaims(value: ApplicationOptionalClaims): void;
    /**
     * @stability stable
     */
    resetOptionalClaims(): void;
    /**
     * @stability stable
     */
    get optionalClaimsInput(): ApplicationOptionalClaims | undefined;
    private _publicClient;
    /**
     * @stability stable
     */
    get publicClient(): ApplicationPublicClientOutputReference;
    /**
     * @stability stable
     */
    putPublicClient(value: ApplicationPublicClient): void;
    /**
     * @stability stable
     */
    resetPublicClient(): void;
    /**
     * @stability stable
     */
    get publicClientInput(): ApplicationPublicClient | undefined;
    private _requiredResourceAccess?;
    /**
     * @stability stable
     */
    get requiredResourceAccess(): ApplicationRequiredResourceAccess[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiredResourceAccess(value: ApplicationRequiredResourceAccess[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiredResourceAccess(): void;
    /**
     * @stability stable
     */
    get requiredResourceAccessInput(): cdktf.IResolvable | ApplicationRequiredResourceAccess[] | undefined;
    private _singlePageApplication;
    /**
     * @stability stable
     */
    get singlePageApplication(): ApplicationSinglePageApplicationOutputReference;
    /**
     * @stability stable
     */
    putSinglePageApplication(value: ApplicationSinglePageApplication): void;
    /**
     * @stability stable
     */
    resetSinglePageApplication(): void;
    /**
     * @stability stable
     */
    get singlePageApplicationInput(): ApplicationSinglePageApplication | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationTimeouts | undefined;
    private _web;
    /**
     * @stability stable
     */
    get web(): ApplicationWebOutputReference;
    /**
     * @stability stable
     */
    putWeb(value: ApplicationWeb): void;
    /**
     * @stability stable
     */
    resetWeb(): void;
    /**
     * @stability stable
     */
    get webInput(): ApplicationWeb | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
