import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AzureadProviderConfig {
    /**
     * Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate AzureadProvider#client_certificate}
     *
     * @stability stable
     */
    readonly clientCertificate?: string;
    /**
     * The password to decrypt the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate_password AzureadProvider#client_certificate_password}
     *
     * @stability stable
     */
    readonly clientCertificatePassword?: string;
    /**
     * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate_path AzureadProvider#client_certificate_path}
     *
     * @stability stable
     */
    readonly clientCertificatePath?: string;
    /**
     * The Client ID which should be used for service principal authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_id AzureadProvider#client_id}
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * The application password to use when authenticating as a Service Principal using a Client Secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_secret AzureadProvider#client_secret}
     *
     * @stability stable
     */
    readonly clientSecret?: string;
    /**
     * Disable the Terraform Partner ID, which is used if a custom `partner_id` isn't specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#disable_terraform_partner_id AzureadProvider#disable_terraform_partner_id}
     *
     * @stability stable
     */
    readonly disableTerraformPartnerId?: boolean | cdktf.IResolvable;
    /**
     * The cloud environment which should be used.
     *
     * Possible values are: `global` (also `public`), `usgovernmentl4` (also `usgovernment`), `usgovernmentl5` (also `dod`), and `china`. Defaults to `global`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#environment AzureadProvider#environment}
     *
     * @stability stable
     */
    readonly environment?: string;
    /**
     * The path to a custom endpoint for Managed Identity - in most circumstances this should be detected automatically.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#msi_endpoint AzureadProvider#msi_endpoint}
     *
     * @stability stable
     */
    readonly msiEndpoint?: string;
    /**
     * A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#partner_id AzureadProvider#partner_id}
     *
     * @stability stable
     */
    readonly partnerId?: string;
    /**
     * The Tenant ID which should be used. Works with all authentication methods except Managed Identity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#tenant_id AzureadProvider#tenant_id}
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Allow Azure CLI to be used for Authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#use_cli AzureadProvider#use_cli}
     *
     * @stability stable
     */
    readonly useCli?: boolean | cdktf.IResolvable;
    /**
     * Allow Managed Identity to be used for Authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#use_msi AzureadProvider#use_msi}
     *
     * @stability stable
     */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#alias AzureadProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread azuread}.
 *
 * @stability stable
 */
export declare class AzureadProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread azuread} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: AzureadProviderConfig);
    private _clientCertificate?;
    /**
     * @stability stable
     */
    get clientCertificate(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificate(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificate(): void;
    /**
     * @stability stable
     */
    get clientCertificateInput(): string | undefined;
    private _clientCertificatePassword?;
    /**
     * @stability stable
     */
    get clientCertificatePassword(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificatePassword(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificatePassword(): void;
    /**
     * @stability stable
     */
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    /**
     * @stability stable
     */
    get clientCertificatePath(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificatePath(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificatePath(): void;
    /**
     * @stability stable
     */
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string | undefined;
    /**
     * @stability stable
     */
    set clientId(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string | undefined;
    /**
     * @stability stable
     */
    set clientSecret(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _disableTerraformPartnerId?;
    /**
     * @stability stable
     */
    get disableTerraformPartnerId(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableTerraformPartnerId(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableTerraformPartnerId(): void;
    /**
     * @stability stable
     */
    get disableTerraformPartnerIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): string | undefined;
    /**
     * @stability stable
     */
    set environment(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): string | undefined;
    private _msiEndpoint?;
    /**
     * @stability stable
     */
    get msiEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set msiEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetMsiEndpoint(): void;
    /**
     * @stability stable
     */
    get msiEndpointInput(): string | undefined;
    private _partnerId?;
    /**
     * @stability stable
     */
    get partnerId(): string | undefined;
    /**
     * @stability stable
     */
    set partnerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPartnerId(): void;
    /**
     * @stability stable
     */
    get partnerIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _useCli?;
    /**
     * @stability stable
     */
    get useCli(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set useCli(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUseCli(): void;
    /**
     * @stability stable
     */
    get useCliInput(): boolean | cdktf.IResolvable | undefined;
    private _useMsi?;
    /**
     * @stability stable
     */
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUseMsi(): void;
    /**
     * @stability stable
     */
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
