import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#display_name ConditionalAccessPolicy#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#state ConditionalAccessPolicy#state}.
     *
     * @stability stable
     */
    readonly state: string;
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#conditions ConditionalAccessPolicy#conditions}
     *
     * @stability stable
     */
    readonly conditions: ConditionalAccessPolicyConditions;
    /**
     * grant_controls block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#grant_controls ConditionalAccessPolicy#grant_controls}
     *
     * @stability stable
     */
    readonly grantControls: ConditionalAccessPolicyGrantControls;
    /**
     * session_controls block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#session_controls ConditionalAccessPolicy#session_controls}
     *
     * @stability stable
     */
    readonly sessionControls?: ConditionalAccessPolicySessionControls;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#timeouts ConditionalAccessPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ConditionalAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsApplications {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_applications ConditionalAccessPolicy#excluded_applications}.
     *
     * @stability stable
     */
    readonly excludedApplications?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_applications ConditionalAccessPolicy#included_applications}.
     *
     * @stability stable
     */
    readonly includedApplications: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_user_actions ConditionalAccessPolicy#included_user_actions}.
     *
     * @stability stable
     */
    readonly includedUserActions?: string[];
}
export declare function conditionalAccessPolicyConditionsApplicationsToTerraform(struct?: ConditionalAccessPolicyConditionsApplicationsOutputReference | ConditionalAccessPolicyConditionsApplications): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsApplications | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsApplications | undefined);
    private _excludedApplications?;
    /**
     * @stability stable
     */
    get excludedApplications(): string[];
    /**
     * @stability stable
     */
    set excludedApplications(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedApplications(): void;
    /**
     * @stability stable
     */
    get excludedApplicationsInput(): string[] | undefined;
    private _includedApplications?;
    /**
     * @stability stable
     */
    get includedApplications(): string[];
    /**
     * @stability stable
     */
    set includedApplications(value: string[]);
    /**
     * @stability stable
     */
    get includedApplicationsInput(): string[] | undefined;
    private _includedUserActions?;
    /**
     * @stability stable
     */
    get includedUserActions(): string[];
    /**
     * @stability stable
     */
    set includedUserActions(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedUserActions(): void;
    /**
     * @stability stable
     */
    get includedUserActionsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsDevicesFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#mode ConditionalAccessPolicy#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#rule ConditionalAccessPolicy#rule}.
     *
     * @stability stable
     */
    readonly rule: string;
}
export declare function conditionalAccessPolicyConditionsDevicesFilterToTerraform(struct?: ConditionalAccessPolicyConditionsDevicesFilterOutputReference | ConditionalAccessPolicyConditionsDevicesFilter): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsDevicesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsDevicesFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsDevicesFilter | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): string;
    /**
     * @stability stable
     */
    set rule(value: string);
    /**
     * @stability stable
     */
    get ruleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsDevices {
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#filter ConditionalAccessPolicy#filter}
     *
     * @stability stable
     */
    readonly filter?: ConditionalAccessPolicyConditionsDevicesFilter;
}
export declare function conditionalAccessPolicyConditionsDevicesToTerraform(struct?: ConditionalAccessPolicyConditionsDevicesOutputReference | ConditionalAccessPolicyConditionsDevices): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsDevicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsDevices | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsDevices | undefined);
    private _filter;
    /**
     * @stability stable
     */
    get filter(): ConditionalAccessPolicyConditionsDevicesFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: ConditionalAccessPolicyConditionsDevicesFilter): void;
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ConditionalAccessPolicyConditionsDevicesFilter | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsLocations {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_locations ConditionalAccessPolicy#excluded_locations}.
     *
     * @stability stable
     */
    readonly excludedLocations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_locations ConditionalAccessPolicy#included_locations}.
     *
     * @stability stable
     */
    readonly includedLocations: string[];
}
export declare function conditionalAccessPolicyConditionsLocationsToTerraform(struct?: ConditionalAccessPolicyConditionsLocationsOutputReference | ConditionalAccessPolicyConditionsLocations): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsLocations | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsLocations | undefined);
    private _excludedLocations?;
    /**
     * @stability stable
     */
    get excludedLocations(): string[];
    /**
     * @stability stable
     */
    set excludedLocations(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedLocations(): void;
    /**
     * @stability stable
     */
    get excludedLocationsInput(): string[] | undefined;
    private _includedLocations?;
    /**
     * @stability stable
     */
    get includedLocations(): string[];
    /**
     * @stability stable
     */
    set includedLocations(value: string[]);
    /**
     * @stability stable
     */
    get includedLocationsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsPlatforms {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_platforms ConditionalAccessPolicy#excluded_platforms}.
     *
     * @stability stable
     */
    readonly excludedPlatforms?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_platforms ConditionalAccessPolicy#included_platforms}.
     *
     * @stability stable
     */
    readonly includedPlatforms: string[];
}
export declare function conditionalAccessPolicyConditionsPlatformsToTerraform(struct?: ConditionalAccessPolicyConditionsPlatformsOutputReference | ConditionalAccessPolicyConditionsPlatforms): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsPlatformsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsPlatforms | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsPlatforms | undefined);
    private _excludedPlatforms?;
    /**
     * @stability stable
     */
    get excludedPlatforms(): string[];
    /**
     * @stability stable
     */
    set excludedPlatforms(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedPlatforms(): void;
    /**
     * @stability stable
     */
    get excludedPlatformsInput(): string[] | undefined;
    private _includedPlatforms?;
    /**
     * @stability stable
     */
    get includedPlatforms(): string[];
    /**
     * @stability stable
     */
    set includedPlatforms(value: string[]);
    /**
     * @stability stable
     */
    get includedPlatformsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditionsUsers {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_groups ConditionalAccessPolicy#excluded_groups}.
     *
     * @stability stable
     */
    readonly excludedGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_roles ConditionalAccessPolicy#excluded_roles}.
     *
     * @stability stable
     */
    readonly excludedRoles?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_users ConditionalAccessPolicy#excluded_users}.
     *
     * @stability stable
     */
    readonly excludedUsers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_groups ConditionalAccessPolicy#included_groups}.
     *
     * @stability stable
     */
    readonly includedGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_roles ConditionalAccessPolicy#included_roles}.
     *
     * @stability stable
     */
    readonly includedRoles?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_users ConditionalAccessPolicy#included_users}.
     *
     * @stability stable
     */
    readonly includedUsers?: string[];
}
export declare function conditionalAccessPolicyConditionsUsersToTerraform(struct?: ConditionalAccessPolicyConditionsUsersOutputReference | ConditionalAccessPolicyConditionsUsers): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditionsUsers | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditionsUsers | undefined);
    private _excludedGroups?;
    /**
     * @stability stable
     */
    get excludedGroups(): string[];
    /**
     * @stability stable
     */
    set excludedGroups(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedGroups(): void;
    /**
     * @stability stable
     */
    get excludedGroupsInput(): string[] | undefined;
    private _excludedRoles?;
    /**
     * @stability stable
     */
    get excludedRoles(): string[];
    /**
     * @stability stable
     */
    set excludedRoles(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedRoles(): void;
    /**
     * @stability stable
     */
    get excludedRolesInput(): string[] | undefined;
    private _excludedUsers?;
    /**
     * @stability stable
     */
    get excludedUsers(): string[];
    /**
     * @stability stable
     */
    set excludedUsers(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedUsers(): void;
    /**
     * @stability stable
     */
    get excludedUsersInput(): string[] | undefined;
    private _includedGroups?;
    /**
     * @stability stable
     */
    get includedGroups(): string[];
    /**
     * @stability stable
     */
    set includedGroups(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedGroups(): void;
    /**
     * @stability stable
     */
    get includedGroupsInput(): string[] | undefined;
    private _includedRoles?;
    /**
     * @stability stable
     */
    get includedRoles(): string[];
    /**
     * @stability stable
     */
    set includedRoles(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedRoles(): void;
    /**
     * @stability stable
     */
    get includedRolesInput(): string[] | undefined;
    private _includedUsers?;
    /**
     * @stability stable
     */
    get includedUsers(): string[];
    /**
     * @stability stable
     */
    set includedUsers(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedUsers(): void;
    /**
     * @stability stable
     */
    get includedUsersInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyConditions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#client_app_types ConditionalAccessPolicy#client_app_types}.
     *
     * @stability stable
     */
    readonly clientAppTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_risk_levels ConditionalAccessPolicy#sign_in_risk_levels}.
     *
     * @stability stable
     */
    readonly signInRiskLevels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#user_risk_levels ConditionalAccessPolicy#user_risk_levels}.
     *
     * @stability stable
     */
    readonly userRiskLevels?: string[];
    /**
     * applications block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#applications ConditionalAccessPolicy#applications}
     *
     * @stability stable
     */
    readonly applications: ConditionalAccessPolicyConditionsApplications;
    /**
     * devices block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#devices ConditionalAccessPolicy#devices}
     *
     * @stability stable
     */
    readonly devices?: ConditionalAccessPolicyConditionsDevices;
    /**
     * locations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#locations ConditionalAccessPolicy#locations}
     *
     * @stability stable
     */
    readonly locations: ConditionalAccessPolicyConditionsLocations;
    /**
     * platforms block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#platforms ConditionalAccessPolicy#platforms}
     *
     * @stability stable
     */
    readonly platforms: ConditionalAccessPolicyConditionsPlatforms;
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#users ConditionalAccessPolicy#users}
     *
     * @stability stable
     */
    readonly users: ConditionalAccessPolicyConditionsUsers;
}
export declare function conditionalAccessPolicyConditionsToTerraform(struct?: ConditionalAccessPolicyConditionsOutputReference | ConditionalAccessPolicyConditions): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyConditions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyConditions | undefined);
    private _clientAppTypes?;
    /**
     * @stability stable
     */
    get clientAppTypes(): string[];
    /**
     * @stability stable
     */
    set clientAppTypes(value: string[]);
    /**
     * @stability stable
     */
    get clientAppTypesInput(): string[] | undefined;
    private _signInRiskLevels?;
    /**
     * @stability stable
     */
    get signInRiskLevels(): string[];
    /**
     * @stability stable
     */
    set signInRiskLevels(value: string[]);
    /**
     * @stability stable
     */
    resetSignInRiskLevels(): void;
    /**
     * @stability stable
     */
    get signInRiskLevelsInput(): string[] | undefined;
    private _userRiskLevels?;
    /**
     * @stability stable
     */
    get userRiskLevels(): string[];
    /**
     * @stability stable
     */
    set userRiskLevels(value: string[]);
    /**
     * @stability stable
     */
    resetUserRiskLevels(): void;
    /**
     * @stability stable
     */
    get userRiskLevelsInput(): string[] | undefined;
    private _applications;
    /**
     * @stability stable
     */
    get applications(): ConditionalAccessPolicyConditionsApplicationsOutputReference;
    /**
     * @stability stable
     */
    putApplications(value: ConditionalAccessPolicyConditionsApplications): void;
    /**
     * @stability stable
     */
    get applicationsInput(): ConditionalAccessPolicyConditionsApplications | undefined;
    private _devices;
    /**
     * @stability stable
     */
    get devices(): ConditionalAccessPolicyConditionsDevicesOutputReference;
    /**
     * @stability stable
     */
    putDevices(value: ConditionalAccessPolicyConditionsDevices): void;
    /**
     * @stability stable
     */
    resetDevices(): void;
    /**
     * @stability stable
     */
    get devicesInput(): ConditionalAccessPolicyConditionsDevices | undefined;
    private _locations;
    /**
     * @stability stable
     */
    get locations(): ConditionalAccessPolicyConditionsLocationsOutputReference;
    /**
     * @stability stable
     */
    putLocations(value: ConditionalAccessPolicyConditionsLocations): void;
    /**
     * @stability stable
     */
    get locationsInput(): ConditionalAccessPolicyConditionsLocations | undefined;
    private _platforms;
    /**
     * @stability stable
     */
    get platforms(): ConditionalAccessPolicyConditionsPlatformsOutputReference;
    /**
     * @stability stable
     */
    putPlatforms(value: ConditionalAccessPolicyConditionsPlatforms): void;
    /**
     * @stability stable
     */
    get platformsInput(): ConditionalAccessPolicyConditionsPlatforms | undefined;
    private _users;
    /**
     * @stability stable
     */
    get users(): ConditionalAccessPolicyConditionsUsersOutputReference;
    /**
     * @stability stable
     */
    putUsers(value: ConditionalAccessPolicyConditionsUsers): void;
    /**
     * @stability stable
     */
    get usersInput(): ConditionalAccessPolicyConditionsUsers | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyGrantControls {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#built_in_controls ConditionalAccessPolicy#built_in_controls}.
     *
     * @stability stable
     */
    readonly builtInControls: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#custom_authentication_factors ConditionalAccessPolicy#custom_authentication_factors}.
     *
     * @stability stable
     */
    readonly customAuthenticationFactors?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#operator ConditionalAccessPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#terms_of_use ConditionalAccessPolicy#terms_of_use}.
     *
     * @stability stable
     */
    readonly termsOfUse?: string[];
}
export declare function conditionalAccessPolicyGrantControlsToTerraform(struct?: ConditionalAccessPolicyGrantControlsOutputReference | ConditionalAccessPolicyGrantControls): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyGrantControlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyGrantControls | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyGrantControls | undefined);
    private _builtInControls?;
    /**
     * @stability stable
     */
    get builtInControls(): string[];
    /**
     * @stability stable
     */
    set builtInControls(value: string[]);
    /**
     * @stability stable
     */
    get builtInControlsInput(): string[] | undefined;
    private _customAuthenticationFactors?;
    /**
     * @stability stable
     */
    get customAuthenticationFactors(): string[];
    /**
     * @stability stable
     */
    set customAuthenticationFactors(value: string[]);
    /**
     * @stability stable
     */
    resetCustomAuthenticationFactors(): void;
    /**
     * @stability stable
     */
    get customAuthenticationFactorsInput(): string[] | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _termsOfUse?;
    /**
     * @stability stable
     */
    get termsOfUse(): string[];
    /**
     * @stability stable
     */
    set termsOfUse(value: string[]);
    /**
     * @stability stable
     */
    resetTermsOfUse(): void;
    /**
     * @stability stable
     */
    get termsOfUseInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicySessionControls {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#application_enforced_restrictions_enabled ConditionalAccessPolicy#application_enforced_restrictions_enabled}.
     *
     * @stability stable
     */
    readonly applicationEnforcedRestrictionsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#cloud_app_security_policy ConditionalAccessPolicy#cloud_app_security_policy}.
     *
     * @stability stable
     */
    readonly cloudAppSecurityPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#persistent_browser_mode ConditionalAccessPolicy#persistent_browser_mode}.
     *
     * @stability stable
     */
    readonly persistentBrowserMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_frequency ConditionalAccessPolicy#sign_in_frequency}.
     *
     * @stability stable
     */
    readonly signInFrequency?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_frequency_period ConditionalAccessPolicy#sign_in_frequency_period}.
     *
     * @stability stable
     */
    readonly signInFrequencyPeriod?: string;
}
export declare function conditionalAccessPolicySessionControlsToTerraform(struct?: ConditionalAccessPolicySessionControlsOutputReference | ConditionalAccessPolicySessionControls): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicySessionControlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicySessionControls | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicySessionControls | undefined);
    private _applicationEnforcedRestrictionsEnabled?;
    /**
     * @stability stable
     */
    get applicationEnforcedRestrictionsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set applicationEnforcedRestrictionsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetApplicationEnforcedRestrictionsEnabled(): void;
    /**
     * @stability stable
     */
    get applicationEnforcedRestrictionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cloudAppSecurityPolicy?;
    /**
     * @stability stable
     */
    get cloudAppSecurityPolicy(): string;
    /**
     * @stability stable
     */
    set cloudAppSecurityPolicy(value: string);
    /**
     * @stability stable
     */
    resetCloudAppSecurityPolicy(): void;
    /**
     * @stability stable
     */
    get cloudAppSecurityPolicyInput(): string | undefined;
    private _persistentBrowserMode?;
    /**
     * @stability stable
     */
    get persistentBrowserMode(): string;
    /**
     * @stability stable
     */
    set persistentBrowserMode(value: string);
    /**
     * @stability stable
     */
    resetPersistentBrowserMode(): void;
    /**
     * @stability stable
     */
    get persistentBrowserModeInput(): string | undefined;
    private _signInFrequency?;
    /**
     * @stability stable
     */
    get signInFrequency(): number;
    /**
     * @stability stable
     */
    set signInFrequency(value: number);
    /**
     * @stability stable
     */
    resetSignInFrequency(): void;
    /**
     * @stability stable
     */
    get signInFrequencyInput(): number | undefined;
    private _signInFrequencyPeriod?;
    /**
     * @stability stable
     */
    get signInFrequencyPeriod(): string;
    /**
     * @stability stable
     */
    set signInFrequencyPeriod(value: string);
    /**
     * @stability stable
     */
    resetSignInFrequencyPeriod(): void;
    /**
     * @stability stable
     */
    get signInFrequencyPeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ConditionalAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#create ConditionalAccessPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#delete ConditionalAccessPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#read ConditionalAccessPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#update ConditionalAccessPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function conditionalAccessPolicyTimeoutsToTerraform(struct?: ConditionalAccessPolicyTimeoutsOutputReference | ConditionalAccessPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ConditionalAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConditionalAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConditionalAccessPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy}.
 *
 * @stability stable
 */
export declare class ConditionalAccessPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConditionalAccessPolicyConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _conditions;
    /**
     * @stability stable
     */
    get conditions(): ConditionalAccessPolicyConditionsOutputReference;
    /**
     * @stability stable
     */
    putConditions(value: ConditionalAccessPolicyConditions): void;
    /**
     * @stability stable
     */
    get conditionsInput(): ConditionalAccessPolicyConditions | undefined;
    private _grantControls;
    /**
     * @stability stable
     */
    get grantControls(): ConditionalAccessPolicyGrantControlsOutputReference;
    /**
     * @stability stable
     */
    putGrantControls(value: ConditionalAccessPolicyGrantControls): void;
    /**
     * @stability stable
     */
    get grantControlsInput(): ConditionalAccessPolicyGrantControls | undefined;
    private _sessionControls;
    /**
     * @stability stable
     */
    get sessionControls(): ConditionalAccessPolicySessionControlsOutputReference;
    /**
     * @stability stable
     */
    putSessionControls(value: ConditionalAccessPolicySessionControls): void;
    /**
     * @stability stable
     */
    resetSessionControls(): void;
    /**
     * @stability stable
     */
    get sessionControlsInput(): ConditionalAccessPolicySessionControls | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ConditionalAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ConditionalAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ConditionalAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
