import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CustomDirectoryRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description of the custom directory role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#description CustomDirectoryRole#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name of the custom directory role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#display_name CustomDirectoryRole#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Indicates whether the role is enabled for assignment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#enabled CustomDirectoryRole#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Custom template identifier that is typically used if one needs an identifier to be the same across different directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#template_id CustomDirectoryRole#template_id}
     *
     * @stability stable
     */
    readonly templateId?: string;
    /**
     * The version of the role definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#version CustomDirectoryRole#version}
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * permissions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#permissions CustomDirectoryRole#permissions}
     *
     * @stability stable
     */
    readonly permissions: CustomDirectoryRolePermissions[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#timeouts CustomDirectoryRole#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CustomDirectoryRoleTimeouts;
}
/**
 * @stability stable
 */
export interface CustomDirectoryRolePermissions {
    /**
     * Set of tasks that can be performed on a resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#allowed_resource_actions CustomDirectoryRole#allowed_resource_actions}
     *
     * @stability stable
     */
    readonly allowedResourceActions: string[];
}
export declare function customDirectoryRolePermissionsToTerraform(struct?: CustomDirectoryRolePermissions | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface CustomDirectoryRoleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#create CustomDirectoryRole#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#delete CustomDirectoryRole#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#read CustomDirectoryRole#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role#update CustomDirectoryRole#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function customDirectoryRoleTimeoutsToTerraform(struct?: CustomDirectoryRoleTimeoutsOutputReference | CustomDirectoryRoleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CustomDirectoryRoleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CustomDirectoryRoleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CustomDirectoryRoleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role azuread_custom_directory_role}.
 *
 * @stability stable
 */
export declare class CustomDirectoryRole extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/custom_directory_role azuread_custom_directory_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CustomDirectoryRoleConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    private _templateId?;
    /**
     * @stability stable
     */
    get templateId(): string;
    /**
     * @stability stable
     */
    set templateId(value: string);
    /**
     * @stability stable
     */
    resetTemplateId(): void;
    /**
     * @stability stable
     */
    get templateIdInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): CustomDirectoryRolePermissions[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set permissions(value: CustomDirectoryRolePermissions[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get permissionsInput(): cdktf.IResolvable | CustomDirectoryRolePermissions[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CustomDirectoryRoleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CustomDirectoryRoleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CustomDirectoryRoleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
