import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadAdministrativeUnitConfig extends cdktf.TerraformMetaArguments {
    /**
     * The display name for the administrative unit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#display_name DataAzureadAdministrativeUnit#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The object ID of the administrative unit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#object_id DataAzureadAdministrativeUnit#object_id}
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#timeouts DataAzureadAdministrativeUnit#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadAdministrativeUnitTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzureadAdministrativeUnitTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#create DataAzureadAdministrativeUnit#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#delete DataAzureadAdministrativeUnit#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#read DataAzureadAdministrativeUnit#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#update DataAzureadAdministrativeUnit#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataAzureadAdministrativeUnitTimeoutsToTerraform(struct?: DataAzureadAdministrativeUnitTimeoutsOutputReference | DataAzureadAdministrativeUnitTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadAdministrativeUnitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadAdministrativeUnitTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadAdministrativeUnitTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit azuread_administrative_unit}.
 *
 * @stability stable
 */
export declare class DataAzureadAdministrativeUnit extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit azuread_administrative_unit} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadAdministrativeUnitConfig);
    /**
     * @stability stable
     */
    get description(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get members(): string[];
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get visibility(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadAdministrativeUnitTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadAdministrativeUnitTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadAdministrativeUnitTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
