import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadApplicationPublishedAppIdsConfig extends cdktf.TerraformMetaArguments {
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#timeouts DataAzureadApplicationPublishedAppIds#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadApplicationPublishedAppIdsTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzureadApplicationPublishedAppIdsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#read DataAzureadApplicationPublishedAppIds#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadApplicationPublishedAppIdsTimeoutsToTerraform(struct?: DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference | DataAzureadApplicationPublishedAppIdsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadApplicationPublishedAppIdsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadApplicationPublishedAppIdsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids}.
 *
 * @stability stable
 */
export declare class DataAzureadApplicationPublishedAppIds extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationPublishedAppIdsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    result(key: string): string | cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadApplicationPublishedAppIdsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadApplicationPublishedAppIdsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
