import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadApplicationTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The display name for the application template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#display_name DataAzureadApplicationTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The application template's ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#template_id DataAzureadApplicationTemplate#template_id}
     *
     * @stability stable
     */
    readonly templateId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#timeouts DataAzureadApplicationTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadApplicationTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzureadApplicationTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#read DataAzureadApplicationTemplate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadApplicationTemplateTimeoutsToTerraform(struct?: DataAzureadApplicationTemplateTimeoutsOutputReference | DataAzureadApplicationTemplateTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadApplicationTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadApplicationTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadApplicationTemplateTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application_template azuread_application_template}.
 *
 * @stability stable
 */
export declare class DataAzureadApplicationTemplate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application_template azuread_application_template} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationTemplateConfig);
    /**
     * @stability stable
     */
    get categories(): string[];
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    get supportedProvisioningTypes(): string[];
    /**
     * @stability stable
     */
    get supportedSingleSignOnModes(): string[];
    private _templateId?;
    /**
     * @stability stable
     */
    get templateId(): string;
    /**
     * @stability stable
     */
    set templateId(value: string);
    /**
     * @stability stable
     */
    resetTemplateId(): void;
    /**
     * @stability stable
     */
    get templateIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadApplicationTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadApplicationTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadApplicationTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
