import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The Application ID (also called Client ID).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#application_id DataAzureadApplication#application_id}
     *
     * @stability stable
     */
    readonly applicationId?: string;
    /**
     * The display name for the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#display_name DataAzureadApplication#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The application's object ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#object_id DataAzureadApplication#object_id}
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#timeouts DataAzureadApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadApplicationTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationApiOauth2PermissionScopes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminConsentDescription(): string;
    /**
     * @stability stable
     */
    get adminConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userConsentDescription(): string;
    /**
     * @stability stable
     */
    get userConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationApi extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get knownClientApplications(): string[];
    /**
     * @stability stable
     */
    get mappedClaimsEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get oauth2PermissionScopes(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get requestedAccessTokenVersion(): number;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationAppRoles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedMemberTypes(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationFeatureTags extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customSingleSignOn(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enterprise(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get gallery(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hide(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationOptionalClaimsAccessToken extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalProperties(): string[];
    /**
     * @stability stable
     */
    get essential(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get source(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationOptionalClaimsIdToken extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalProperties(): string[];
    /**
     * @stability stable
     */
    get essential(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get source(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationOptionalClaimsSaml2Token extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalProperties(): string[];
    /**
     * @stability stable
     */
    get essential(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get source(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationOptionalClaims extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accessToken(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get idToken(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get saml2Token(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationPublicClient extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get redirectUris(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationRequiredResourceAccessResourceAccess extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationRequiredResourceAccess extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceAccess(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get resourceAppId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationSinglePageApplication extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get redirectUris(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationWebImplicitGrant extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accessTokenIssuanceEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get idTokenIssuanceEnabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzureadApplicationWeb extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    get implicitGrant(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get logoutUrl(): string;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
}
/**
 * @stability stable
 */
export interface DataAzureadApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#read DataAzureadApplication#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadApplicationTimeoutsToTerraform(struct?: DataAzureadApplicationTimeoutsOutputReference | DataAzureadApplicationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadApplicationTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application azuread_application}.
 *
 * @stability stable
 */
export declare class DataAzureadApplication extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application azuread_application} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationConfig);
    /**
     * @stability stable
     */
    api(index: string): DataAzureadApplicationApi;
    /**
     * @stability stable
     */
    appRoleIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    appRoles(index: string): DataAzureadApplicationAppRoles;
    private _applicationId?;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    set applicationId(value: string);
    /**
     * @stability stable
     */
    resetApplicationId(): void;
    /**
     * @stability stable
     */
    get applicationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get deviceOnlyAuthEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get disabledByMicrosoft(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get fallbackPublicClientEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    featureTags(index: string): DataAzureadApplicationFeatureTags;
    /**
     * @stability stable
     */
    get groupMembershipClaims(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get identifierUris(): string[];
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get marketingUrl(): string;
    /**
     * @stability stable
     */
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get oauth2PostResponseRequired(): cdktf.IResolvable;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    optionalClaims(index: string): DataAzureadApplicationOptionalClaims;
    /**
     * @stability stable
     */
    get owners(): string[];
    /**
     * @stability stable
     */
    get privacyStatementUrl(): string;
    /**
     * @stability stable
     */
    publicClient(index: string): DataAzureadApplicationPublicClient;
    /**
     * @stability stable
     */
    get publisherDomain(): string;
    /**
     * @stability stable
     */
    requiredResourceAccess(index: string): DataAzureadApplicationRequiredResourceAccess;
    /**
     * @stability stable
     */
    get signInAudience(): string;
    /**
     * @stability stable
     */
    singlePageApplication(index: string): DataAzureadApplicationSinglePageApplication;
    /**
     * @stability stable
     */
    get supportUrl(): string;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get termsOfServiceUrl(): string;
    /**
     * @stability stable
     */
    web(index: string): DataAzureadApplicationWeb;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
