import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadDomainsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Set to `true` to only return domains whose DNS is managed by Microsoft 365.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#admin_managed DataAzureadDomains#admin_managed}
     *
     * @stability stable
     */
    readonly adminManaged?: boolean | cdktf.IResolvable;
    /**
     * Set to `true` if unverified Azure AD domains should be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#include_unverified DataAzureadDomains#include_unverified}
     *
     * @stability stable
     */
    readonly includeUnverified?: boolean | cdktf.IResolvable;
    /**
     * Set to `true` to only return the default domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_default DataAzureadDomains#only_default}
     *
     * @stability stable
     */
    readonly onlyDefault?: boolean | cdktf.IResolvable;
    /**
     * Set to `true` to only return the initial domain, which is your primary Azure Active Directory tenant domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_initial DataAzureadDomains#only_initial}
     *
     * @stability stable
     */
    readonly onlyInitial?: boolean | cdktf.IResolvable;
    /**
     * Set to `true` to only return verified root domains. Excludes subdomains and unverified domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_root DataAzureadDomains#only_root}
     *
     * @stability stable
     */
    readonly onlyRoot?: boolean | cdktf.IResolvable;
    /**
     * A list of supported services that must be supported by a domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#supports_services DataAzureadDomains#supports_services}
     *
     * @stability stable
     */
    readonly supportsServices?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#timeouts DataAzureadDomains#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadDomainsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadDomainsDomains extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminManaged(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get authenticationType(): string;
    /**
     * @stability stable
     */
    get default(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    get initial(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get root(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get supportedServices(): string[];
    /**
     * @stability stable
     */
    get verified(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzureadDomainsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#read DataAzureadDomains#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadDomainsTimeoutsToTerraform(struct?: DataAzureadDomainsTimeoutsOutputReference | DataAzureadDomainsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadDomainsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadDomainsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadDomainsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/domains azuread_domains}.
 *
 * @stability stable
 */
export declare class DataAzureadDomains extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/domains azuread_domains} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadDomainsConfig);
    private _adminManaged?;
    /**
     * @stability stable
     */
    get adminManaged(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminManaged(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminManaged(): void;
    /**
     * @stability stable
     */
    get adminManagedInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    domains(index: string): DataAzureadDomainsDomains;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeUnverified?;
    /**
     * @stability stable
     */
    get includeUnverified(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeUnverified(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeUnverified(): void;
    /**
     * @stability stable
     */
    get includeUnverifiedInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyDefault?;
    /**
     * @stability stable
     */
    get onlyDefault(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onlyDefault(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnlyDefault(): void;
    /**
     * @stability stable
     */
    get onlyDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyInitial?;
    /**
     * @stability stable
     */
    get onlyInitial(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onlyInitial(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnlyInitial(): void;
    /**
     * @stability stable
     */
    get onlyInitialInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyRoot?;
    /**
     * @stability stable
     */
    get onlyRoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onlyRoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnlyRoot(): void;
    /**
     * @stability stable
     */
    get onlyRootInput(): boolean | cdktf.IResolvable | undefined;
    private _supportsServices?;
    /**
     * @stability stable
     */
    get supportsServices(): string[];
    /**
     * @stability stable
     */
    set supportsServices(value: string[]);
    /**
     * @stability stable
     */
    resetSupportsServices(): void;
    /**
     * @stability stable
     */
    get supportsServicesInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadDomainsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadDomainsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadDomainsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
