import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * The display name for the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#display_name DataAzureadGroup#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Whether the group is mail-enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#mail_enabled DataAzureadGroup#mail_enabled}
     *
     * @stability stable
     */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
     * The object ID of the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#object_id DataAzureadGroup#object_id}
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Whether the group is a security group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#security_enabled DataAzureadGroup#security_enabled}
     *
     * @stability stable
     */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#timeouts DataAzureadGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadGroupTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadGroupDynamicMembership extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get rule(): string;
}
/**
 * @stability stable
 */
export interface DataAzureadGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#read DataAzureadGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadGroupTimeoutsToTerraform(struct?: DataAzureadGroupTimeoutsOutputReference | DataAzureadGroupTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/group azuread_group}.
 *
 * @stability stable
 */
export declare class DataAzureadGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/group azuread_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadGroupConfig);
    /**
     * @stability stable
     */
    get assignableToRole(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get autoSubscribeNewMembers(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get behaviors(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    dynamicMembership(index: string): DataAzureadGroupDynamicMembership;
    /**
     * @stability stable
     */
    get externalSendersAllowed(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hideFromAddressLists(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hideFromOutlookClients(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get mail(): string;
    private _mailEnabled?;
    /**
     * @stability stable
     */
    get mailEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mailEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMailEnabled(): void;
    /**
     * @stability stable
     */
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get mailNickname(): string;
    /**
     * @stability stable
     */
    get members(): string[];
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get onpremisesDomainName(): string;
    /**
     * @stability stable
     */
    get onpremisesNetbiosName(): string;
    /**
     * @stability stable
     */
    get onpremisesSamAccountName(): string;
    /**
     * @stability stable
     */
    get onpremisesSecurityIdentifier(): string;
    /**
     * @stability stable
     */
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get owners(): string[];
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    get provisioningOptions(): string[];
    /**
     * @stability stable
     */
    get proxyAddresses(): string[];
    private _securityEnabled?;
    /**
     * @stability stable
     */
    get securityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set securityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get theme(): string;
    /**
     * @stability stable
     */
    get types(): string[];
    /**
     * @stability stable
     */
    get visibility(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
