import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Common display name prefix of the groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#display_name_prefix DataAzureadGroups#display_name_prefix}
     *
     * @stability stable
     */
    readonly displayNamePrefix?: string;
    /**
     * The display names of the groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#display_names DataAzureadGroups#display_names}
     *
     * @stability stable
     */
    readonly displayNames?: string[];
    /**
     * Whether the groups are mail-enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#mail_enabled DataAzureadGroups#mail_enabled}
     *
     * @stability stable
     */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
     * The object IDs of the groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#object_ids DataAzureadGroups#object_ids}
     *
     * @stability stable
     */
    readonly objectIds?: string[];
    /**
     * Retrieve all groups with no filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#return_all DataAzureadGroups#return_all}
     *
     * @stability stable
     */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
     * Whether the groups are security-enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#security_enabled DataAzureadGroups#security_enabled}
     *
     * @stability stable
     */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#timeouts DataAzureadGroups#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadGroupsTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzureadGroupsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#read DataAzureadGroups#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadGroupsTimeoutsToTerraform(struct?: DataAzureadGroupsTimeoutsOutputReference | DataAzureadGroupsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadGroupsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadGroupsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadGroupsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/groups azuread_groups}.
 *
 * @stability stable
 */
export declare class DataAzureadGroups extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/groups azuread_groups} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadGroupsConfig);
    private _displayNamePrefix?;
    /**
     * @stability stable
     */
    get displayNamePrefix(): string;
    /**
     * @stability stable
     */
    set displayNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetDisplayNamePrefix(): void;
    /**
     * @stability stable
     */
    get displayNamePrefixInput(): string | undefined;
    private _displayNames?;
    /**
     * @stability stable
     */
    get displayNames(): string[];
    /**
     * @stability stable
     */
    set displayNames(value: string[]);
    /**
     * @stability stable
     */
    resetDisplayNames(): void;
    /**
     * @stability stable
     */
    get displayNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mailEnabled?;
    /**
     * @stability stable
     */
    get mailEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mailEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMailEnabled(): void;
    /**
     * @stability stable
     */
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _objectIds?;
    /**
     * @stability stable
     */
    get objectIds(): string[];
    /**
     * @stability stable
     */
    set objectIds(value: string[]);
    /**
     * @stability stable
     */
    resetObjectIds(): void;
    /**
     * @stability stable
     */
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    /**
     * @stability stable
     */
    get returnAll(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnAll(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnAll(): void;
    /**
     * @stability stable
     */
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    private _securityEnabled?;
    /**
     * @stability stable
     */
    get securityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set securityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadGroupsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadGroupsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadGroupsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
