import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
     * The application ID (client ID) of the application associated with this service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#application_id DataAzureadServicePrincipal#application_id}
     *
     * @stability stable
     */
    readonly applicationId?: string;
    /**
     * The display name of the application associated with this service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#display_name DataAzureadServicePrincipal#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The object ID of the service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#object_id DataAzureadServicePrincipal#object_id}
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#timeouts DataAzureadServicePrincipal#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadServicePrincipalTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalAppRoles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedMemberTypes(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalFeatureTags extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customSingleSignOn(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enterprise(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get gallery(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hide(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalFeatures extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customSingleSignOnApp(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enterpriseApplication(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get galleryApplication(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get visibleToUsers(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalOauth2PermissionScopes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminConsentDescription(): string;
    /**
     * @stability stable
     */
    get adminConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userConsentDescription(): string;
    /**
     * @stability stable
     */
    get userConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalSamlSingleSignOn extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get relayState(): string;
}
/**
 * @stability stable
 */
export interface DataAzureadServicePrincipalTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#read DataAzureadServicePrincipal#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadServicePrincipalTimeoutsToTerraform(struct?: DataAzureadServicePrincipalTimeoutsOutputReference | DataAzureadServicePrincipalTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadServicePrincipalTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/service_principal azuread_service_principal}.
 *
 * @stability stable
 */
export declare class DataAzureadServicePrincipal extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/service_principal azuread_service_principal} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadServicePrincipalConfig);
    /**
     * @stability stable
     */
    get accountEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get alternativeNames(): string[];
    /**
     * @stability stable
     */
    get appRoleAssignmentRequired(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    appRoleIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    appRoles(index: string): DataAzureadServicePrincipalAppRoles;
    private _applicationId?;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    set applicationId(value: string);
    /**
     * @stability stable
     */
    resetApplicationId(): void;
    /**
     * @stability stable
     */
    get applicationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get applicationTenantId(): string;
    /**
     * @stability stable
     */
    get description(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    featureTags(index: string): DataAzureadServicePrincipalFeatureTags;
    /**
     * @stability stable
     */
    features(index: string): DataAzureadServicePrincipalFeatures;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get loginUrl(): string;
    /**
     * @stability stable
     */
    get logoutUrl(): string;
    /**
     * @stability stable
     */
    get notes(): string;
    /**
     * @stability stable
     */
    get notificationEmailAddresses(): string[];
    /**
     * @stability stable
     */
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    oauth2PermissionScopes(index: string): DataAzureadServicePrincipalOauth2PermissionScopes;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get preferredSingleSignOnMode(): string;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    get samlMetadataUrl(): string;
    /**
     * @stability stable
     */
    samlSingleSignOn(index: string): DataAzureadServicePrincipalSamlSingleSignOn;
    /**
     * @stability stable
     */
    get servicePrincipalNames(): string[];
    /**
     * @stability stable
     */
    get signInAudience(): string;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get type(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadServicePrincipalTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadServicePrincipalTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
