import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadServicePrincipalsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The application IDs (client IDs) of the applications associated with the service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#application_ids DataAzureadServicePrincipals#application_ids}
     *
     * @stability stable
     */
    readonly applicationIds?: string[];
    /**
     * The display names of the applications associated with the service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#display_names DataAzureadServicePrincipals#display_names}
     *
     * @stability stable
     */
    readonly displayNames?: string[];
    /**
     * Ignore missing service principals and return the service principals that were found.
     *
     * The data source will still fail if no service principals are found
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#ignore_missing DataAzureadServicePrincipals#ignore_missing}
     *
     * @stability stable
     */
    readonly ignoreMissing?: boolean | cdktf.IResolvable;
    /**
     * The object IDs of the service principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#object_ids DataAzureadServicePrincipals#object_ids}
     *
     * @stability stable
     */
    readonly objectIds?: string[];
    /**
     * Fetch all service principals with no filter and return all that were found.
     *
     * The data source will still fail if no service principals are found.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#return_all DataAzureadServicePrincipals#return_all}
     *
     * @stability stable
     */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#timeouts DataAzureadServicePrincipals#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadServicePrincipalsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalsServicePrincipals extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accountEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get appRoleAssignmentRequired(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    get applicationTenantId(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get preferredSingleSignOnMode(): string;
    /**
     * @stability stable
     */
    get samlMetadataUrl(): string;
    /**
     * @stability stable
     */
    get servicePrincipalNames(): string[];
    /**
     * @stability stable
     */
    get signInAudience(): string;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DataAzureadServicePrincipalsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#read DataAzureadServicePrincipals#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadServicePrincipalsTimeoutsToTerraform(struct?: DataAzureadServicePrincipalsTimeoutsOutputReference | DataAzureadServicePrincipalsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadServicePrincipalsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadServicePrincipalsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadServicePrincipalsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/service_principals azuread_service_principals}.
 *
 * @stability stable
 */
export declare class DataAzureadServicePrincipals extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/service_principals azuread_service_principals} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadServicePrincipalsConfig);
    private _applicationIds?;
    /**
     * @stability stable
     */
    get applicationIds(): string[];
    /**
     * @stability stable
     */
    set applicationIds(value: string[]);
    /**
     * @stability stable
     */
    resetApplicationIds(): void;
    /**
     * @stability stable
     */
    get applicationIdsInput(): string[] | undefined;
    private _displayNames?;
    /**
     * @stability stable
     */
    get displayNames(): string[];
    /**
     * @stability stable
     */
    set displayNames(value: string[]);
    /**
     * @stability stable
     */
    resetDisplayNames(): void;
    /**
     * @stability stable
     */
    get displayNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreMissing?;
    /**
     * @stability stable
     */
    get ignoreMissing(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreMissing(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreMissing(): void;
    /**
     * @stability stable
     */
    get ignoreMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _objectIds?;
    /**
     * @stability stable
     */
    get objectIds(): string[];
    /**
     * @stability stable
     */
    set objectIds(value: string[]);
    /**
     * @stability stable
     */
    resetObjectIds(): void;
    /**
     * @stability stable
     */
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    /**
     * @stability stable
     */
    get returnAll(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnAll(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnAll(): void;
    /**
     * @stability stable
     */
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    servicePrincipals(index: string): DataAzureadServicePrincipalsServicePrincipals;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadServicePrincipalsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadServicePrincipalsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadServicePrincipalsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
