import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * The email alias of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#mail_nickname DataAzureadUser#mail_nickname}
     *
     * @stability stable
     */
    readonly mailNickname?: string;
    /**
     * The object ID of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#object_id DataAzureadUser#object_id}
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * The user principal name (UPN) of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#user_principal_name DataAzureadUser#user_principal_name}
     *
     * @stability stable
     */
    readonly userPrincipalName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#timeouts DataAzureadUser#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadUserTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzureadUserTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#read DataAzureadUser#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadUserTimeoutsToTerraform(struct?: DataAzureadUserTimeoutsOutputReference | DataAzureadUserTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadUserTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadUserTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/user azuread_user}.
 *
 * @stability stable
 */
export declare class DataAzureadUser extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/user azuread_user} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadUserConfig);
    /**
     * @stability stable
     */
    get accountEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get ageGroup(): string;
    /**
     * @stability stable
     */
    get businessPhones(): string[];
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    get companyName(): string;
    /**
     * @stability stable
     */
    get consentProvidedForMinor(): string;
    /**
     * @stability stable
     */
    get costCenter(): string;
    /**
     * @stability stable
     */
    get country(): string;
    /**
     * @stability stable
     */
    get creationType(): string;
    /**
     * @stability stable
     */
    get department(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get division(): string;
    /**
     * @stability stable
     */
    get employeeId(): string;
    /**
     * @stability stable
     */
    get employeeType(): string;
    /**
     * @stability stable
     */
    get externalUserState(): string;
    /**
     * @stability stable
     */
    get faxNumber(): string;
    /**
     * @stability stable
     */
    get givenName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imAddresses(): string[];
    /**
     * @stability stable
     */
    get jobTitle(): string;
    /**
     * @stability stable
     */
    get mail(): string;
    private _mailNickname?;
    /**
     * @stability stable
     */
    get mailNickname(): string;
    /**
     * @stability stable
     */
    set mailNickname(value: string);
    /**
     * @stability stable
     */
    resetMailNickname(): void;
    /**
     * @stability stable
     */
    get mailNicknameInput(): string | undefined;
    /**
     * @stability stable
     */
    get managerId(): string;
    /**
     * @stability stable
     */
    get mobilePhone(): string;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get officeLocation(): string;
    /**
     * @stability stable
     */
    get onpremisesDistinguishedName(): string;
    /**
     * @stability stable
     */
    get onpremisesDomainName(): string;
    /**
     * @stability stable
     */
    get onpremisesImmutableId(): string;
    /**
     * @stability stable
     */
    get onpremisesSamAccountName(): string;
    /**
     * @stability stable
     */
    get onpremisesSecurityIdentifier(): string;
    /**
     * @stability stable
     */
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get onpremisesUserPrincipalName(): string;
    /**
     * @stability stable
     */
    get otherMails(): string[];
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    get proxyAddresses(): string[];
    /**
     * @stability stable
     */
    get showInAddressList(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    get surname(): string;
    /**
     * @stability stable
     */
    get usageLocation(): string;
    private _userPrincipalName?;
    /**
     * @stability stable
     */
    get userPrincipalName(): string;
    /**
     * @stability stable
     */
    set userPrincipalName(value: string);
    /**
     * @stability stable
     */
    resetUserPrincipalName(): void;
    /**
     * @stability stable
     */
    get userPrincipalNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get userType(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadUserTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadUserTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadUserTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
