import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzureadUsersConfig extends cdktf.TerraformMetaArguments {
    /**
     * Ignore missing users and return users that were found.
     *
     * The data source will still fail if no users are found
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#ignore_missing DataAzureadUsers#ignore_missing}
     *
     * @stability stable
     */
    readonly ignoreMissing?: boolean | cdktf.IResolvable;
    /**
     * The email aliases of the users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#mail_nicknames DataAzureadUsers#mail_nicknames}
     *
     * @stability stable
     */
    readonly mailNicknames?: string[];
    /**
     * The object IDs of the users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#object_ids DataAzureadUsers#object_ids}
     *
     * @stability stable
     */
    readonly objectIds?: string[];
    /**
     * Fetch all users with no filter and return all that were found.
     *
     * The data source will still fail if no users are found.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#return_all DataAzureadUsers#return_all}
     *
     * @stability stable
     */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
     * The user principal names (UPNs) of the users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#user_principal_names DataAzureadUsers#user_principal_names}
     *
     * @stability stable
     */
    readonly userPrincipalNames?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#timeouts DataAzureadUsers#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzureadUsersTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzureadUsersUsers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accountEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get mail(): string;
    /**
     * @stability stable
     */
    get mailNickname(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get onpremisesImmutableId(): string;
    /**
     * @stability stable
     */
    get onpremisesSamAccountName(): string;
    /**
     * @stability stable
     */
    get onpremisesUserPrincipalName(): string;
    /**
     * @stability stable
     */
    get usageLocation(): string;
    /**
     * @stability stable
     */
    get userPrincipalName(): string;
}
/**
 * @stability stable
 */
export interface DataAzureadUsersTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#read DataAzureadUsers#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzureadUsersTimeoutsToTerraform(struct?: DataAzureadUsersTimeoutsOutputReference | DataAzureadUsersTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzureadUsersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzureadUsersTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzureadUsersTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/d/users azuread_users}.
 *
 * @stability stable
 */
export declare class DataAzureadUsers extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/users azuread_users} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzureadUsersConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreMissing?;
    /**
     * @stability stable
     */
    get ignoreMissing(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreMissing(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreMissing(): void;
    /**
     * @stability stable
     */
    get ignoreMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _mailNicknames?;
    /**
     * @stability stable
     */
    get mailNicknames(): string[];
    /**
     * @stability stable
     */
    set mailNicknames(value: string[]);
    /**
     * @stability stable
     */
    resetMailNicknames(): void;
    /**
     * @stability stable
     */
    get mailNicknamesInput(): string[] | undefined;
    private _objectIds?;
    /**
     * @stability stable
     */
    get objectIds(): string[];
    /**
     * @stability stable
     */
    set objectIds(value: string[]);
    /**
     * @stability stable
     */
    resetObjectIds(): void;
    /**
     * @stability stable
     */
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    /**
     * @stability stable
     */
    get returnAll(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnAll(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnAll(): void;
    /**
     * @stability stable
     */
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    private _userPrincipalNames?;
    /**
     * @stability stable
     */
    get userPrincipalNames(): string[];
    /**
     * @stability stable
     */
    set userPrincipalNames(value: string[]);
    /**
     * @stability stable
     */
    resetUserPrincipalNames(): void;
    /**
     * @stability stable
     */
    get userPrincipalNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    users(index: string): DataAzureadUsersUsers;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzureadUsersTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzureadUsersTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzureadUsersTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
