import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DirectoryRoleMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * The object ID of the member.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#member_object_id DirectoryRoleMember#member_object_id}
     *
     * @stability stable
     */
    readonly memberObjectId?: string;
    /**
     * The object ID of the directory role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#role_object_id DirectoryRoleMember#role_object_id}
     *
     * @stability stable
     */
    readonly roleObjectId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#timeouts DirectoryRoleMember#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DirectoryRoleMemberTimeouts;
}
/**
 * @stability stable
 */
export interface DirectoryRoleMemberTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#create DirectoryRoleMember#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#delete DirectoryRoleMember#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#read DirectoryRoleMember#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#update DirectoryRoleMember#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function directoryRoleMemberTimeoutsToTerraform(struct?: DirectoryRoleMemberTimeoutsOutputReference | DirectoryRoleMemberTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DirectoryRoleMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DirectoryRoleMemberTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DirectoryRoleMemberTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member azuread_directory_role_member}.
 *
 * @stability stable
 */
export declare class DirectoryRoleMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member azuread_directory_role_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DirectoryRoleMemberConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _memberObjectId?;
    /**
     * @stability stable
     */
    get memberObjectId(): string;
    /**
     * @stability stable
     */
    set memberObjectId(value: string);
    /**
     * @stability stable
     */
    resetMemberObjectId(): void;
    /**
     * @stability stable
     */
    get memberObjectIdInput(): string | undefined;
    private _roleObjectId?;
    /**
     * @stability stable
     */
    get roleObjectId(): string;
    /**
     * @stability stable
     */
    set roleObjectId(value: string);
    /**
     * @stability stable
     */
    resetRoleObjectId(): void;
    /**
     * @stability stable
     */
    get roleObjectIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DirectoryRoleMemberTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DirectoryRoleMemberTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DirectoryRoleMemberTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
