import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Indicates whether this group can be assigned to an Azure Active Directory role.
     *
     * This property can only be `true` for security-enabled groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#assignable_to_role Group#assignable_to_role}
     *
     * @stability stable
     */
    readonly assignableToRole?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether new members added to the group will be auto-subscribed to receive email notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#auto_subscribe_new_members Group#auto_subscribe_new_members}
     *
     * @stability stable
     */
    readonly autoSubscribeNewMembers?: boolean | cdktf.IResolvable;
    /**
     * The group behaviours for a Microsoft 365 group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#behaviors Group#behaviors}
     *
     * @stability stable
     */
    readonly behaviors?: string[];
    /**
     * The description for the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#description Group#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name for the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#display_name Group#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Indicates whether people external to the organization can send messages to the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#external_senders_allowed Group#external_senders_allowed}
     *
     * @stability stable
     */
    readonly externalSendersAllowed?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#hide_from_address_lists Group#hide_from_address_lists}
     *
     * @stability stable
     */
    readonly hideFromAddressLists?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#hide_from_outlook_clients Group#hide_from_outlook_clients}
     *
     * @stability stable
     */
    readonly hideFromOutlookClients?: boolean | cdktf.IResolvable;
    /**
     * Whether the group is a mail enabled, with a shared group mailbox.
     *
     * At least one of `mail_enabled` or `security_enabled` must be specified. A group can be mail enabled _and_ security enabled
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#mail_enabled Group#mail_enabled}
     *
     * @stability stable
     */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
     * The mail alias for the group, unique in the organisation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#mail_nickname Group#mail_nickname}
     *
     * @stability stable
     */
    readonly mailNickname?: string;
    /**
     * A set of members who should be present in this group.
     *
     * Supported object types are Users, Groups or Service Principals
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#members Group#members}
     *
     * @stability stable
     */
    readonly members?: string[];
    /**
     * A set of owners who own this group. Supported object types are Users or Service Principals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#owners Group#owners}
     *
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * If `true`, will return an error if an existing group is found with the same name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#prevent_duplicate_names Group#prevent_duplicate_names}
     *
     * @stability stable
     */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
     * The group provisioning options for a Microsoft 365 group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#provisioning_options Group#provisioning_options}
     *
     * @stability stable
     */
    readonly provisioningOptions?: string[];
    /**
     * Whether the group is a security group for controlling access to in-app resources.
     *
     * At least one of `security_enabled` or `mail_enabled` must be specified. A group can be security enabled _and_ mail enabled
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#security_enabled Group#security_enabled}
     *
     * @stability stable
     */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
     * The colour theme for a Microsoft 365 group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#theme Group#theme}
     *
     * @stability stable
     */
    readonly theme?: string;
    /**
     * A set of group types to configure for the group.
     *
     * `Unified` specifies a Microsoft 365 group. Required when `mail_enabled` is true
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#types Group#types}
     *
     * @stability stable
     */
    readonly types?: string[];
    /**
     * Specifies the group join policy and group content visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#visibility Group#visibility}
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * dynamic_membership block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#dynamic_membership Group#dynamic_membership}
     *
     * @stability stable
     */
    readonly dynamicMembership?: GroupDynamicMembership;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#timeouts Group#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: GroupTimeouts;
}
/**
 * @stability stable
 */
export interface GroupDynamicMembership {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#enabled Group#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Rule to determine members for a dynamic group. Required when `group_types` contains 'DynamicMembership'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#rule Group#rule}
     *
     * @stability stable
     */
    readonly rule: string;
}
export declare function groupDynamicMembershipToTerraform(struct?: GroupDynamicMembershipOutputReference | GroupDynamicMembership): any;
/**
 * @stability stable
 */
export declare class GroupDynamicMembershipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GroupDynamicMembership | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GroupDynamicMembership | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): string;
    /**
     * @stability stable
     */
    set rule(value: string);
    /**
     * @stability stable
     */
    get ruleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface GroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#create Group#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#delete Group#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#read Group#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#update Group#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function groupTimeoutsToTerraform(struct?: GroupTimeoutsOutputReference | GroupTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class GroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/group azuread_group}.
 *
 * @stability stable
 */
export declare class Group extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/group azuread_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _assignableToRole?;
    /**
     * @stability stable
     */
    get assignableToRole(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set assignableToRole(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAssignableToRole(): void;
    /**
     * @stability stable
     */
    get assignableToRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSubscribeNewMembers?;
    /**
     * @stability stable
     */
    get autoSubscribeNewMembers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubscribeNewMembers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubscribeNewMembers(): void;
    /**
     * @stability stable
     */
    get autoSubscribeNewMembersInput(): boolean | cdktf.IResolvable | undefined;
    private _behaviors?;
    /**
     * @stability stable
     */
    get behaviors(): string[];
    /**
     * @stability stable
     */
    set behaviors(value: string[]);
    /**
     * @stability stable
     */
    resetBehaviors(): void;
    /**
     * @stability stable
     */
    get behaviorsInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _externalSendersAllowed?;
    /**
     * @stability stable
     */
    get externalSendersAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set externalSendersAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExternalSendersAllowed(): void;
    /**
     * @stability stable
     */
    get externalSendersAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _hideFromAddressLists?;
    /**
     * @stability stable
     */
    get hideFromAddressLists(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideFromAddressLists(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideFromAddressLists(): void;
    /**
     * @stability stable
     */
    get hideFromAddressListsInput(): boolean | cdktf.IResolvable | undefined;
    private _hideFromOutlookClients?;
    /**
     * @stability stable
     */
    get hideFromOutlookClients(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideFromOutlookClients(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideFromOutlookClients(): void;
    /**
     * @stability stable
     */
    get hideFromOutlookClientsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get mail(): string;
    private _mailEnabled?;
    /**
     * @stability stable
     */
    get mailEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mailEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMailEnabled(): void;
    /**
     * @stability stable
     */
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mailNickname?;
    /**
     * @stability stable
     */
    get mailNickname(): string;
    /**
     * @stability stable
     */
    set mailNickname(value: string);
    /**
     * @stability stable
     */
    resetMailNickname(): void;
    /**
     * @stability stable
     */
    get mailNicknameInput(): string | undefined;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    resetMembers(): void;
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get onpremisesDomainName(): string;
    /**
     * @stability stable
     */
    get onpremisesNetbiosName(): string;
    /**
     * @stability stable
     */
    get onpremisesSamAccountName(): string;
    /**
     * @stability stable
     */
    get onpremisesSecurityIdentifier(): string;
    /**
     * @stability stable
     */
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    private _owners?;
    /**
     * @stability stable
     */
    get owners(): string[];
    /**
     * @stability stable
     */
    set owners(value: string[]);
    /**
     * @stability stable
     */
    resetOwners(): void;
    /**
     * @stability stable
     */
    get ownersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    private _preventDuplicateNames?;
    /**
     * @stability stable
     */
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreventDuplicateNames(): void;
    /**
     * @stability stable
     */
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningOptions?;
    /**
     * @stability stable
     */
    get provisioningOptions(): string[];
    /**
     * @stability stable
     */
    set provisioningOptions(value: string[]);
    /**
     * @stability stable
     */
    resetProvisioningOptions(): void;
    /**
     * @stability stable
     */
    get provisioningOptionsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get proxyAddresses(): string[];
    private _securityEnabled?;
    /**
     * @stability stable
     */
    get securityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set securityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _theme?;
    /**
     * @stability stable
     */
    get theme(): string;
    /**
     * @stability stable
     */
    set theme(value: string);
    /**
     * @stability stable
     */
    resetTheme(): void;
    /**
     * @stability stable
     */
    get themeInput(): string | undefined;
    private _types?;
    /**
     * @stability stable
     */
    get types(): string[];
    /**
     * @stability stable
     */
    set types(value: string[]);
    /**
     * @stability stable
     */
    resetTypes(): void;
    /**
     * @stability stable
     */
    get typesInput(): string[] | undefined;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _dynamicMembership;
    /**
     * @stability stable
     */
    get dynamicMembership(): GroupDynamicMembershipOutputReference;
    /**
     * @stability stable
     */
    putDynamicMembership(value: GroupDynamicMembership): void;
    /**
     * @stability stable
     */
    resetDynamicMembership(): void;
    /**
     * @stability stable
     */
    get dynamicMembershipInput(): GroupDynamicMembership | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): GroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: GroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): GroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
